/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.dranger;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ColorUtilities;

public class DRangerFeature
extends AbstractFeature {
    private int index;
    String chr2;
    int pos2;
    Strand str2;
    private int tumreads;
    private int normreads;
    private String featureClass;
    private int span;
    private String site1;
    private String site2;
    private int quality;
    private int score;
    float[] defaultColor = Color.blue.getComponents(null);
    static Map<String, float[]> colorMap = new HashMap<String, float[]>();

    public DRangerFeature() {
    }

    public DRangerFeature(String chr, int pos1, Strand strand1, String chr2, int pos2, Strand str2) {
        super(chr, pos1 - 5, pos1 + 5, strand1);
        this.chr2 = chr2;
        this.pos2 = pos2;
        this.str2 = str2;
    }

    @Override
    public boolean hasScore() {
        return true;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public LocusScore copy() {
        DRangerFeature newFeat = new DRangerFeature();
        newFeat.setChr(this.getChr());
        newFeat.setStart(this.getStart());
        newFeat.setEnd(this.getEnd());
        newFeat.chr2 = this.chr2;
        newFeat.pos2 = this.pos2;
        newFeat.str2 = this.str2;
        newFeat.tumreads = this.tumreads;
        newFeat.normreads = this.normreads;
        newFeat.featureClass = this.featureClass;
        newFeat.span = this.span;
        newFeat.site1 = this.site1;
        newFeat.site2 = this.site2;
        newFeat.quality = this.quality;
        newFeat.score = this.score;
        return newFeat;
    }

    public String positionString() {
        return this.getChr() + ":" + this.getStart() + "-" + this.getEnd();
    }

    public String getSite() {
        return this.site1;
    }

    public void setSite1(String site1) {
        this.site1 = site1;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getTumreads() {
        return this.tumreads;
    }

    public void setTumreads(int tumreads) {
        this.tumreads = tumreads;
    }

    public int getNormreads() {
        return this.normreads;
    }

    public void setNormreads(int normreads) {
        this.normreads = normreads;
    }

    public String getFeatureClass() {
        return this.featureClass;
    }

    public void setFeatureClass(String featureClass) {
        this.featureClass = featureClass;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public String getSite1() {
        return this.site1;
    }

    public String getSite2() {
        return this.site2;
    }

    public void setSite2(String site2) {
        this.site2 = site2;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void setScore(int score) {
        this.score = score;
    }

    @Override
    public Color getColor() {
        float[] baseColor = this.defaultColor;
        if (this.featureClass != null && colorMap.containsKey(this.featureClass)) {
            baseColor = colorMap.get(this.featureClass);
        }
        float alpha = Math.min(1.0f, Math.max(0.15f, 0.15f + 0.28333333f * (float)this.score));
        return ColorUtilities.getCompositeColor(baseColor, alpha);
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        StringBuffer buf = new StringBuffer();
        if (this.index > 0) {
            buf.append("Index:   " + this.index + "<br>");
        }
        if (this.site1 != null) {
            buf.append("Site1:    " + this.site1 + "<br>");
        }
        if (this.site2 != null) {
            buf.append("Site2:    " + this.site2 + "<br>");
        }
        if (this.tumreads > 0) {
            buf.append("T reads: " + this.tumreads + "<br>");
        }
        if (this.normreads > 0) {
            buf.append("N reads: " + this.normreads + "<br>");
        }
        if (this.featureClass != null) {
            buf.append("Class: " + this.featureClass + "<br>");
        }
        if (this.span > 0) {
            buf.append("Span:    " + this.span + "<br>");
        }
        if (this.quality > 0) {
            buf.append("Quality:   " + this.quality + "<br>");
        }
        if (this.score > 0) {
            buf.append("Score:   " + this.score);
        }
        return buf.toString();
    }

    static {
        colorMap.put("deletion", Color.red.getComponents(null));
        colorMap.put("inter_chr", Color.blue.getComponents(null));
        colorMap.put("inversion", Color.green.getComponents(null));
        colorMap.put("long_range", Color.MAGENTA.getComponents(null));
        colorMap.put("tandem_dup", Color.cyan.getComponents(null));
    }
}

