/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.remote;

import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;

public class SequenceServletWrapper {
    public static boolean SEQUENCE_SERVER_AVAILALBLE = true;
    public static final int CONNECTION_TIMEOUT = 20000;
    private static Logger logger = Logger.getLogger(SequenceServletWrapper.class);

    public static byte[] readBytes(String location, String chr, int start, int end) {
        byte[] bytes = new byte[end - start];
        if (!SEQUENCE_SERVER_AVAILALBLE) {
            return bytes;
        }
        try {
            URL url = new URL(location);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            connection.setConnectTimeout(20000);
            connection.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
            out.write("chr=" + chr);
            out.write("&start=" + start);
            out.write("&end=" + end);
            out.close();
            InputStream cis = connection.getInputStream();
            DataInputStream is = new DataInputStream(new BufferedInputStream(cis));
            int numRead = 0;
            for (int offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            is.close();
            return bytes;
        }
        catch (IOException ex) {
            if (SEQUENCE_SERVER_AVAILALBLE) {
                SEQUENCE_SERVER_AVAILALBLE = false;
                SequenceServletWrapper.showUnavailableMessage();
                logger.error("Error retrieving sequence from : " + location + ex.getMessage());
            }
            return null;
        }
    }

    private static void showUnavailableMessage() throws HeadlessException {
        MessageUtils.showMessage("<html>The IGV server at the Broad Institute is currently unavailable.  Features that require a reference sequence, <br>such as displaying alignment mismatches, will be disabled.  If this problem persists please <br>send email to igv-help@broadinstitute.org");
    }
}

