/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.util.SOLIDUtils;

public class SequenceRenderer
implements Renderer {
    static Map<Character, Color> nucleotideColors = new HashMap<Character, Color>();

    public void draw(RenderContext context, Rectangle trackRectangle) {
        this.draw(context, trackRectangle, false);
    }

    public void draw(RenderContext context, Rectangle trackRectangle, boolean showColorSpace) {
        double locScale = context.getScale();
        double origin = context.getOrigin();
        String chr = context.getChr();
        String genome = context.getGenomeId();
        int start = Math.max(0, (int)origin - 1);
        int end = (int)(origin + (double)trackRectangle.width * locScale) + 1;
        byte[] seq = SequenceManager.readSequence(genome, chr, start, end);
        byte[] seqCS = null;
        if (showColorSpace) {
            seqCS = SOLIDUtils.convertToColorSpace(seq);
        }
        if (seq != null && seq.length > 0) {
            int hCS = showColorSpace ? trackRectangle.height / 2 : 0;
            int yBase = hCS + trackRectangle.y + 2;
            int yCS = trackRectangle.y + 2;
            int dY = (showColorSpace ? hCS : trackRectangle.height) - 4;
            int dX = (int)(1.0 / locScale);
            Graphics2D g2 = (Graphics2D)context.getGraphics().create();
            if (dX >= 8) {
                Font f2 = FontManager.getScalableFont(1, Math.min(dX, 12));
                g2.setFont(f2);
            }
            for (int loc = start; loc < end; ++loc) {
                int idx = loc - start;
                int pX0 = (int)(((double)loc - origin) / locScale);
                char c2 = (char)seq[idx];
                Color color = nucleotideColors.get(Character.valueOf(c2));
                if (dX >= 8) {
                    if (color == null) {
                        color = Color.black;
                    }
                    g2.setColor(color);
                    this.drawCenteredText(g2, new char[]{c2}, pX0, yBase + 2, dX, dY - 2);
                    if (!showColorSpace) continue;
                    g2.setColor(Color.black);
                    String cCS = String.valueOf(seqCS[idx]);
                    this.drawCenteredText(g2, cCS.toCharArray(), pX0 - dX / 2, yCS + 2, dX, dY - 2);
                    continue;
                }
                int bw = dX - 1;
                if (color == null) continue;
                g2.setColor(color);
                g2.fillRect(pX0, yBase, bw, dY);
            }
        }
    }

    private void drawCenteredText(Graphics2D g2, char[] chars, int x, int y, int w, int h2) {
        FontMetrics fm = g2.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h2 / 2 - descent / 2 + ascent / 2;
        g2.drawChars(chars, 0, 1, msgX, msgY);
    }

    @Override
    public void renderBorder(Track track, RenderContext context, Rectangle rect) {
    }

    @Override
    public void renderAxis(Track track, RenderContext context, Rectangle rect) {
    }

    @Override
    public void setOverlayMode(boolean overlayMode) {
    }

    @Override
    public Color getDefaultColor() {
        return Color.BLACK;
    }

    static {
        nucleotideColors.put(Character.valueOf('A'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('a'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('C'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('c'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('T'), Color.RED);
        nucleotideColors.put(Character.valueOf('t'), Color.RED);
        nucleotideColors.put(Character.valueOf('G'), new Color(209, 113, 5));
        nucleotideColors.put(Character.valueOf('g'), new Color(209, 113, 5));
        nucleotideColors.put(Character.valueOf('N'), Color.gray);
        nucleotideColors.put(Character.valueOf('n'), Color.gray);
    }
}

