/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.List;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.MiscStuff;
import org.broad.igv.ui.UIConstants;

public abstract class XYPlotRenderer
extends DataRenderer {
    static DecimalFormat formatter = new DecimalFormat();

    protected void drawDataPoint(Color graphColor, int dx, int pX, int baseY, int pY, RenderContext context) {
        context.getGraphic2DForColor(graphColor).fillRect(pX, pY, dx, 2);
    }

    @Override
    public synchronized void renderScores(Track track, List<LocusScore> locusScores, RenderContext context, Rectangle arect) {
        int w;
        Graphics2D noDataGraphics = context.getGraphic2DForColor(UIConstants.NO_DATA_COLOR);
        Graphics2D tickGraphics = context.getGraphic2DForColor(Color.BLACK);
        Rectangle adjustedRect = this.calculateDrawingRect(arect);
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color posColor = track.getColor();
        Color negColor = track.getAltColor();
        if (negColor == null) {
            negColor = posColor;
        }
        DataRange dataRange = track.getDataRange();
        float maxValue = dataRange.getMaximum();
        float baseValue = dataRange.getBaseline();
        float minValue = dataRange.getMinimum();
        boolean isLog = dataRange.isLog();
        if (isLog) {
            minValue = (float)(minValue == 0.0f ? 0.0 : Math.log10(minValue));
            maxValue = (float)Math.log10(maxValue);
        }
        double delta = maxValue - minValue;
        double yScaleFactor = adjustedRect.getHeight() / delta;
        double baseDelta = maxValue - baseValue;
        int baseY = (int)(adjustedRect.getY() + baseDelta * yScaleFactor);
        if (baseY < adjustedRect.y) {
            baseY = adjustedRect.y;
        } else if (baseY > adjustedRect.y + adjustedRect.height) {
            baseY = adjustedRect.y + adjustedRect.height;
        }
        int lastPx = 0;
        for (LocusScore score : locusScores) {
            int w2;
            double dx;
            double pX = ((double)score.getStart() - origin) / locScale;
            if (pX + (dx = Math.ceil((double)Math.max(1, score.getEnd() - score.getStart()) / locScale) + 1.0) < 0.0) continue;
            if (pX > adjustedRect.getMaxX()) break;
            float dataY = score.getScore();
            if (isLog && dataY <= 0.0f) continue;
            if (!Float.isNaN(dataY) && score.getConfidence() > confThreshold) {
                double dy = isLog ? Math.log10(dataY) - (double)baseValue : (double)(dataY - baseValue);
                int pY = baseY - (int)(dy * yScaleFactor);
                if (pY < adjustedRect.y) {
                    pY = adjustedRect.y;
                } else if (pY > adjustedRect.y + adjustedRect.height) {
                    pY = adjustedRect.y + adjustedRect.height;
                }
                Color color = dataY >= baseValue ? posColor : negColor;
                this.drawDataPoint(color, (int)dx, (int)pX, baseY, pY, context);
            }
            if (MiscStuff.isShowMissingDataEnabled() && (w2 = (int)pX - lastPx - 4) > 0) {
                noDataGraphics.fillRect(lastPx + 2, (int)arect.getY(), w2, (int)arect.getHeight());
            }
            if (Float.isNaN(dataY)) continue;
            lastPx = (int)pX + (int)dx;
        }
        if (MiscStuff.isShowMissingDataEnabled() && (w = (int)arect.getMaxX() - lastPx - 4) > 0) {
            noDataGraphics.fillRect(lastPx + 2, (int)arect.getY(), w, (int)arect.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderAxis(Track track, RenderContext context, Rectangle arect) {
        DataRange range;
        if (context.getChr().equals("All")) {
            return;
        }
        super.renderAxis(track, context, arect);
        Rectangle drawingRect = this.calculateDrawingRect(arect);
        PreferenceManager.ChartPreferences prefs = PreferenceManager.getInstance().getChartPreferences();
        Color labelColor = prefs.isColorTrackName() ? track.getColor() : Color.black;
        Graphics2D labelGraphics = context.getGraphic2DForColor(labelColor);
        labelGraphics.setFont(FontManager.getScalableFont(8));
        if (prefs.isDrawTrackName() && arect.getHeight() > 25.0) {
            Rectangle labelRect = new Rectangle(arect.x, arect.y + 10, arect.width, 10);
            labelGraphics.setFont(FontManager.getScalableFont(10));
            GraphicUtils.drawCenteredText(track.getName(), labelRect, labelGraphics);
        }
        if (prefs.isDrawAxis()) {
            Rectangle axisRect = new Rectangle(arect.x, arect.y + 1, 60, arect.height);
            DataRange axisDefinition = track.getDataRange();
            float maxValue = axisDefinition.getMaximum();
            float baseValue = axisDefinition.getBaseline();
            float minValue = axisDefinition.getMinimum();
            int pY = this.computeYPixelValue(drawingRect, axisDefinition, minValue);
            labelGraphics.drawLine(axisRect.x + 60 - 10, pY, axisRect.x + 60 - 5, pY);
            GraphicUtils.drawRightJustifiedText(formatter.format(minValue), axisRect.x + 60 - 15, pY, labelGraphics);
            int topPY = this.computeYPixelValue(drawingRect, axisDefinition, maxValue);
            labelGraphics.drawLine(axisRect.x + 60 - 10, topPY, axisRect.x + 60 - 5, topPY);
            GraphicUtils.drawRightJustifiedText(formatter.format(maxValue), axisRect.x + 60 - 15, topPY + 4, labelGraphics);
            labelGraphics.drawLine(axisRect.x + 60 - 10, topPY, axisRect.x + 60 - 10, pY);
            int midPY = this.computeYPixelValue(drawingRect, axisDefinition, baseValue);
            if (midPY < pY - 15 && midPY > topPY + 15) {
                labelGraphics.drawLine(axisRect.x + 60 - 10, midPY, axisRect.x + 60 - 5, midPY);
                GraphicUtils.drawRightJustifiedText(formatter.format(baseValue), axisRect.x + 60 - 15, midPY + 4, labelGraphics);
            }
        } else if (track.isShowDataRange() && arect.height > 20 && (range = track.getDataRange()) != null) {
            Graphics2D g2 = context.getGraphic2DForColor(Color.black);
            Font font = g2.getFont();
            Font smallFont = FontManager.getScalableFont(8);
            try {
                g2.setFont(smallFont);
                String minString = range.getMinimum() == 0.0f ? "0" : String.format("%.3f", Float.valueOf(range.getMinimum()));
                String fmtString = range.getMaximum() > 10.0f ? "%.0f" : "%.2f";
                String maxString = String.format(fmtString, Float.valueOf(range.getMaximum()));
                String scale = "[" + minString + " - " + maxString + "]";
                g2.drawString(scale, arect.x + 5, arect.y + 10);
            }
            finally {
                g2.setFont(font);
            }
        }
    }

    @Override
    public void renderBorder(Track track, RenderContext context, Rectangle arect) {
        Rectangle adjustedRect = this.calculateDrawingRect(arect);
        if (adjustedRect.getHeight() >= 10.0) {
            PreferenceManager.ChartPreferences prefs;
            DataRange axisDefinition = track.getDataRange();
            float maxValue = axisDefinition.getMaximum();
            float baseValue = axisDefinition.getBaseline();
            float minValue = axisDefinition.getMinimum();
            double maxX = adjustedRect.getMaxX();
            double x = adjustedRect.getX();
            double y = adjustedRect.getY();
            if (baseValue > minValue && baseValue < maxValue) {
                int baseY = this.computeYPixelValue(adjustedRect, axisDefinition, baseValue);
                XYPlotRenderer.getBaselineGraphics(context).drawLine((int)x, baseY, (int)maxX, baseY);
            }
            Color borderColor = (prefs = PreferenceManager.getInstance().getChartPreferences()).isColorBorders() && track.getAltColor() == track.getColor() ? track.getColor() : Color.lightGray;
            Graphics2D borderGraphics = context.getGraphic2DForColor(borderColor);
            double zeroValue = axisDefinition.getBaseline();
            int zeroX = this.computeYPixelValue(adjustedRect, axisDefinition, zeroValue);
            borderGraphics.drawLine(adjustedRect.x, zeroX, adjustedRect.x + adjustedRect.width, zeroX);
            boolean drawBorders = true;
            if (minValue * maxValue < 0.0f) {
                boolean bl = drawBorders = prefs.isDrawBottomBorder() && prefs.isDrawTopBorder();
            }
            if (drawBorders && prefs.isDrawTopBorder()) {
                borderGraphics.drawLine(adjustedRect.x, adjustedRect.y, adjustedRect.x + adjustedRect.width, adjustedRect.y);
            }
            if (drawBorders && prefs.isDrawBottomBorder()) {
                borderGraphics.drawLine(adjustedRect.x, adjustedRect.y + adjustedRect.height, adjustedRect.x + adjustedRect.width, adjustedRect.y + adjustedRect.height);
            }
        }
    }

    private static Graphics2D getBaselineGraphics(RenderContext context) {
        Graphics2D baselineGraphics = (Graphics2D)context.getGraphic2DForColor(Color.lightGray).create();
        return baselineGraphics;
    }

    public String getDisplayName() {
        return "Scatter Plot";
    }

    protected int computeYPixelValue(Rectangle drawingRect, DataRange axisDefinition, double dataY) {
        double maxValue = axisDefinition.getMaximum();
        double minValue = axisDefinition.getMinimum();
        double yScaleFactor = drawingRect.getHeight() / (maxValue - minValue);
        double delta = (maxValue - dataY) * yScaleFactor;
        double pY = drawingRect.getY() + delta;
        return (int)Math.max(drawingRect.getMinY(), Math.min(drawingRect.getMaxY(), pY));
    }

    protected Rectangle calculateDrawingRect(Rectangle arect) {
        double buffer = Math.min(arect.getHeight() * 0.2, 10.0);
        Rectangle adjustedRect = new Rectangle(arect);
        adjustedRect.y = (int)(arect.getY() + buffer);
        adjustedRect.height = (int)((double)arect.height - ((double)adjustedRect.y - arect.getY()));
        return adjustedRect;
    }
}

