/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import javax.swing.JOptionPane;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentLoader;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.reader.CachingQueryReader;
import org.broad.igv.sam.reader.SamListReader;
import org.broad.igv.sam.reader.SamQueryReaderFactory;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.MultiFileWrapper;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;

public class AlignmentDataManager {
    private static Logger log = Logger.getLogger(AlignmentDataManager.class);
    private AlignmentInterval loadedInterval = null;
    private HashMap<String, String> chrMappings = new HashMap();
    private boolean isLoading = false;
    private CachingQueryReader reader;
    private CoverageTrack coverageTrack;
    private int maxLevels;
    private static final int DEFAULT_DEPTH = 10;

    public static AlignmentDataManager getDataManager(ResourceLocator locator) throws IOException {
        return new AlignmentDataManager(locator);
    }

    public AlignmentDataManager(ResourceLocator locator) throws IOException {
        PreferenceManager.SAMPreferences prefs = PreferenceManager.getInstance().getSAMPreferences();
        this.maxLevels = prefs.getMaxLevels();
        if (locator.getPath().endsWith(".sam.list")) {
            MultiFileWrapper mfw = MultiFileWrapper.parse(locator);
            this.reader = new CachingQueryReader(new SamListReader(mfw.getLocators()));
        } else {
            this.reader = new CachingQueryReader(SamQueryReaderFactory.getReader(locator));
        }
        this.initChrMap();
    }

    private void initChrMap() {
        Set<String> seqNames;
        Genome genome = ViewContext.getInstance().getGenome();
        if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
            for (String chr : seqNames) {
                String alias = genome.getChromosomeAlias(chr);
                this.chrMappings.put(alias, chr);
            }
        }
    }

    public CachingQueryReader getReader() {
        return this.reader;
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public int getMaxDepth() {
        return this.loadedInterval == null ? 10 : (this.loadedInterval.getDepth() == 0 ? 10 : this.loadedInterval.getDepth());
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public AlignmentInterval getLoadedInterval() {
        return this.loadedInterval;
    }

    public void sortRows(AlignmentTrack.SortOption option) {
        if (this.loadedInterval != null) {
            this.loadedInterval.sortRows(option);
        }
    }

    public void sortRows(AlignmentTrack.SortOption option, double location) {
        if (this.loadedInterval != null) {
            this.loadedInterval.sortRows(option, location);
        }
    }

    public void packAlignments() {
        if (this.loadedInterval == null) {
            return;
        }
        RowIterator iter = new RowIterator();
        List<AlignmentInterval.Row> alignmentRows = AlignmentLoader.packAlignments(iter, this.maxLevels, this.getLoadedInterval().getEnd());
        this.loadedInterval.setAlignmentRows(alignmentRows);
    }

    public synchronized List<AlignmentInterval.Row> getAlignmentRows(String genomeId, String chr, int start, int end) {
        log.debug("Enter getAlignmentRows: " + chr + ":" + start + "-" + end);
        if (this.loadedInterval == null || !this.loadedInterval.contains(genomeId, chr, start, end)) {
            this.loadAlignments(genomeId, chr, start, end);
        }
        if (this.loadedInterval != null && this.loadedInterval.overlaps(genomeId, chr, start, end)) {
            return this.loadedInterval.getAlignmentRows();
        }
        return null;
    }

    public void reload() {
        this.reader.clearCache();
        if (this.loadedInterval != null) {
            String genomeId = this.loadedInterval.genomeId;
            String chr = this.loadedInterval.getChr();
            int start = this.loadedInterval.getStart();
            int end = this.loadedInterval.getEnd();
            this.loadedInterval = null;
            this.loadAlignments(genomeId, chr, start, end);
        }
    }

    public void loadAlignments(final String genomeId, final String chr, final int start, final int end) {
        if (this.isLoading || chr.equals("All")) {
            return;
        }
        if (this.loadedInterval == null || !this.loadedInterval.contains(genomeId, chr, start, end)) {
            log.debug("Load alignments.  isLoading=" + this.isLoading);
            this.isLoading = true;
            NamedRunnable runnable = new NamedRunnable(){

                @Override
                public String getName() {
                    return "preloadData";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    log.debug("Loading " + chr + ":" + start + "-" + end);
                    int expandLength = AlignmentDataManager.this.reader.getTileSize(chr) / 2;
                    int intervalStart = Math.max(0, start - expandLength);
                    int intervalEnd = end + expandLength;
                    CloseableIterator<Alignment> iter = null;
                    try {
                        String sequence = AlignmentDataManager.this.chrMappings.containsKey(chr) ? (String)AlignmentDataManager.this.chrMappings.get(chr) : chr;
                        ArrayList<CachingQueryReader.AlignmentCounts> counts = new ArrayList<CachingQueryReader.AlignmentCounts>();
                        iter = AlignmentDataManager.this.reader.query(sequence, intervalStart, intervalEnd, counts, AlignmentDataManager.this.maxLevels);
                        List<AlignmentInterval.Row> alignmentRows = AlignmentLoader.packAlignments(iter, AlignmentDataManager.this.maxLevels, intervalEnd);
                        AlignmentDataManager.this.loadedInterval = new AlignmentInterval(genomeId, chr, intervalStart, intervalEnd, alignmentRows, counts);
                        if (AlignmentDataManager.this.coverageTrack != null) {
                            AlignmentDataManager.this.coverageTrack.rescale();
                        }
                        IGVMainFrame.getInstance().doResizeTrackPanels();
                        IGVMainFrame.getInstance().repaintDataAndHeaderPanels();
                    }
                    catch (Exception exception) {
                        log.error("Error loading alignments", exception);
                        JOptionPane.showMessageDialog(IGVMainFrame.getInstance(), "Error reading file: " + exception.getMessage());
                    }
                    finally {
                        AlignmentDataManager.this.isLoading = false;
                        if (iter != null) {
                            iter.close();
                        }
                    }
                }
            };
            LongRunningTask.submit(runnable);
        }
    }

    private boolean isMitochondria(String chr) {
        return chr.equals("M") || chr.equals("chrM") || chr.equals("MT") || chr.equals("chrMT");
    }

    public List<AlignmentInterval.Row> getAlignmentRows() {
        return this.loadedInterval == null ? null : this.loadedInterval.getAlignmentRows();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                log.error("Error closing AlignmentQueryReader. ", ex);
            }
        }
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public void setMaxLevels(int maxLevels) {
        this.reader.clearCache();
        this.maxLevels = maxLevels;
    }

    class RowIterator
    implements CloseableIterator<Alignment> {
        PriorityQueue<AlignmentInterval.Row> rows;
        Alignment nextAlignment;

        RowIterator() {
            this.rows = new PriorityQueue<AlignmentInterval.Row>(5, new Comparator<AlignmentInterval.Row>(){

                @Override
                public int compare(AlignmentInterval.Row o1, AlignmentInterval.Row o2) {
                    return o1.getNextStartPos() - o2.getNextStartPos();
                }
            });
            for (AlignmentInterval.Row r : AlignmentDataManager.this.loadedInterval.getAlignmentRows()) {
                r.resetIdx();
                this.rows.add(r);
            }
            this.advance();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.nextAlignment != null;
        }

        @Override
        public Alignment next() {
            Alignment tmp = this.nextAlignment;
            if (tmp != null) {
                this.advance();
            }
            return tmp;
        }

        private void advance() {
            this.nextAlignment = null;
            AlignmentInterval.Row nextRow = null;
            block0: while (this.nextAlignment == null && !this.rows.isEmpty()) {
                while ((nextRow = this.rows.poll()) != null) {
                    if (!nextRow.hasNext()) continue;
                    this.nextAlignment = nextRow.nextAlignment();
                    continue block0;
                }
            }
            if (nextRow != null && this.nextAlignment != null) {
                this.rows.add(nextRow);
            }
        }

        @Override
        public void remove() {
        }
    }
}

