/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;

public class AlignmentLoader {
    private static Logger log = Logger.getLogger(AlignmentLoader.class);
    public static final int MIN_ALIGNMENT_SPACING = 5;

    public static List<AlignmentInterval.Row> packAlignments(CloseableIterator<Alignment> iter, int maxLevels, int end) {
        PriorityQueue<Alignment> firstBucket;
        ArrayList<AlignmentInterval.Row> alignmentRows = new ArrayList<AlignmentInterval.Row>((int)(1.3 * (double)maxLevels));
        if (iter == null || !iter.hasNext()) {
            return alignmentRows;
        }
        Comparator<Alignment> lengthComparator = new Comparator<Alignment>(){

            @Override
            public int compare(Alignment row1, Alignment row2) {
                return row2.getEnd() - row2.getStart() - (row1.getEnd() - row2.getStart());
            }
        };
        Alignment firstAlignment = (Alignment)iter.next();
        int start = firstAlignment.getStart();
        int bucketCount = end - start + 1;
        PriorityQueue[] bucketArray = new PriorityQueue[bucketCount];
        bucketArray[0] = firstBucket = new PriorityQueue<Alignment>(5, lengthComparator);
        firstBucket.add(firstAlignment);
        int totalCount = 1;
        while (iter.hasNext()) {
            Alignment alignment = (Alignment)iter.next();
            if (!alignment.isMapped()) continue;
            int bucketNumber = Math.max(0, alignment.getStart() - start);
            if (bucketNumber < bucketCount) {
                PriorityQueue<Alignment> bucket = bucketArray[bucketNumber];
                if (bucket == null) {
                    bucketArray[bucketNumber] = bucket = new PriorityQueue<Alignment>(5, lengthComparator);
                }
                bucket.add(alignment);
                ++totalCount;
                continue;
            }
            log.debug("Alignment out of bounds: " + alignment.getStart() + " (> " + end);
        }
        long t0 = System.currentTimeMillis();
        int allocatedCount = 0;
        int nextStart = start;
        AlignmentInterval.Row currentRow = new AlignmentInterval.Row();
        while (allocatedCount < totalCount) {
            while (nextStart <= end) {
                AbstractQueue bucket = null;
                while (bucket == null && nextStart <= end) {
                    int bucketNumber = nextStart - start;
                    bucket = bucketArray[bucketNumber];
                    if (bucket != null) continue;
                    ++nextStart;
                }
                if (bucket == null) continue;
                Alignment alignment = (Alignment)bucket.remove();
                if (bucket.isEmpty()) {
                    bucketArray[nextStart - start] = null;
                }
                currentRow.addAlignment(alignment);
                nextStart = currentRow.getLastEnd() + 5;
                ++allocatedCount;
            }
            if (currentRow.alignments.size() > 0) {
                alignmentRows.add(currentRow);
            }
            currentRow = new AlignmentInterval.Row();
            nextStart = start;
        }
        if (log.isDebugEnabled()) {
            long dt = System.currentTimeMillis() - t0;
            log.debug("Packed alignments in " + dt);
        }
        if (currentRow.alignments.size() > 0) {
            alignmentRows.add(currentRow);
        }
        return alignmentRows;
    }
}

