/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.SeekableStreamFactory;

public class BAMHttpQueryReader
implements AlignmentQueryReader {
    static Logger log = Logger.getLogger(BAMHttpQueryReader.class);
    static Properties cachedEtags;
    URL url;
    SAMFileHeader header;
    File indexFile;
    SAMFileReader reader;
    static File cacheDirectory;
    static Properties tagCache;
    static Properties indexLookup;

    public BAMHttpQueryReader(URL url, boolean requireIndex) {
        this.url = url;
        if (requireIndex) {
            this.indexFile = this.getIndexFile(url);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public SAMFileHeader getHeader() {
        if (this.header == null) {
            this.loadHeader();
        }
        return this.header;
    }

    @Override
    public boolean hasIndex() {
        return this.indexFile != null && this.indexFile.exists();
    }

    @Override
    public Set<String> getSequenceNames() {
        SAMFileHeader header = this.getHeader();
        if (header == null) {
            return null;
        }
        HashSet<String> seqNames = new HashSet<String>();
        List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                seqNames.add(chr);
            }
        }
        return seqNames;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        try {
            if (this.reader == null) {
                InputStream is = this.url.openStream();
                this.reader = new SAMFileReader(new BufferedInputStream(is));
            }
            return new WrappedIterator(this.reader.iterator());
        }
        catch (IOException e2) {
            log.error("Error creating iterator", e2);
            throw new RuntimeException(e2);
        }
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        if (this.reader == null) {
            this.reader = new SAMFileReader(this.url, this.indexFile, false);
        }
        log.debug("Query " + sequence + ":" + start + "-" + end);
        SAMRecordIterator iter = this.reader.query(sequence, start, end, contained);
        return new WrappedIterator(iter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeader() {
        InputStream is = null;
        SAMFileReader reader = null;
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            String byteRange = "bytes=0-1000000";
            props.put("Range", byteRange);
            is = SeekableStreamFactory.getStreamFor(this.url.toString());
            BufferedInputStream bis = new BufferedInputStream(is);
            reader = new SAMFileReader(bis);
            this.header = reader.getFileHeader();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    File getIndexFile(URL bamURL) {
        String bamURLString = bamURL.toString();
        String idxFilename = this.getCachedIndexFilename(bamURLString);
        this.indexFile = new File(this.getCacheDirectory(), idxFilename);
        if (!this.indexFile.exists()) {
            this.loadIndexFile(bamURL.toString(), this.indexFile);
            this.indexFile.deleteOnExit();
        }
        return this.indexFile;
    }

    private String getCachedIndexFilename(String bamURL) {
        Properties lookup = BAMHttpQueryReader.getIndexCache();
        String indexName = lookup.getProperty(bamURL);
        if (indexName == null) {
            int tmp = bamURL.lastIndexOf("/");
            String prefix = tmp > 0 ? bamURL.substring(tmp + 1) : "index_";
            indexName = prefix + System.currentTimeMillis() + ".bai";
            lookup.put(bamURL, indexName);
            BAMHttpQueryReader.writeCachedProperties(lookup, "index");
        }
        return indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndexFile(String bamURL, File indexFile) {
        InputStream is = null;
        OutputStream os = null;
        try {
            int bytesRead;
            URL indexURL = new URL(bamURL + ".bai");
            os = new FileOutputStream(indexFile);
            try {
                is = IGVHttpUtils.openConnectionStream(indexURL);
            }
            catch (FileNotFoundException e2) {
                String baseName = bamURL.substring(0, bamURL.length() - 4);
                indexURL = new URL(baseName + ".bai");
                try {
                    is = IGVHttpUtils.openConnectionStream(indexURL);
                }
                catch (FileNotFoundException e1) {
                    MessageUtils.showMessage("Index file not found for file: " + bamURL);
                    throw new DataLoadException("Index file not found for file: " + bamURL, bamURL);
                }
            }
            byte[] buf = new byte[512000];
            while ((bytesRead = is.read(buf)) != -1) {
                os.write(buf, 0, bytesRead);
            }
        }
        catch (IOException e3) {
            MessageUtils.showMessage("Error loading index file: " + indexFile.getAbsolutePath());
            log.error("Error downloading index file ", e3);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
            }
        }
    }

    static synchronized File getCacheDirectory() {
        File defaultDir;
        if (cacheDirectory == null && (defaultDir = UIConstants.getIgvDirectory()).exists() && !(cacheDirectory = new File(defaultDir, "bam")).exists()) {
            cacheDirectory.mkdir();
        }
        return cacheDirectory;
    }

    static synchronized Properties getTagCache() {
        if (tagCache == null) {
            tagCache = BAMHttpQueryReader.loadCachedProperties("etags");
        }
        return tagCache;
    }

    static synchronized Properties getIndexCache() {
        if (indexLookup == null) {
            indexLookup = BAMHttpQueryReader.loadCachedProperties("index");
        }
        return indexLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadCachedProperties(String name) {
        File propFile = new File(BAMHttpQueryReader.getCacheDirectory(), name);
        Properties props = new Properties();
        if (propFile.exists()) {
            FileInputStream reader = null;
            try {
                reader = new FileInputStream(propFile);
                props.load(reader);
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        ((InputStream)reader).close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCachedProperties(Properties props, String name) {
        OutputStream os = null;
        try {
            File propFile = new File(BAMHttpQueryReader.getCacheDirectory(), name);
            os = new FileOutputStream(propFile);
            props.store(os, null);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    static {
        cacheDirectory = null;
        tagCache = null;
        indexLookup = null;
    }
}

