/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.AsciiLineReader;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.SamAlignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ResourceLocator;

public class BAMRemoteQueryReader
implements AlignmentQueryReader {
    Logger log = Logger.getLogger(BAMRemoteQueryReader.class);
    String serverURL;
    String file;
    SAMFileHeader header;

    public BAMRemoteQueryReader(ResourceLocator locator) {
        this.serverURL = locator.getServerURL();
        this.file = locator.getPath();
        this.loadHeader();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public CloseableIterator<Alignment> query(String chr, int start, int end, boolean contained) {
        try {
            URL url = new URL(this.serverURL + "?method=samQuery&samFile=" + this.file + "&chr=" + chr + "&start=" + start + "&end=" + end + "&contained=" + contained);
            InputStream is = IGVHttpUtils.openConnectionStream(url);
            return new RemoteQueryIterator(new GZIPInputStream(is, 8192));
        }
        catch (IOException ex) {
            this.log.error("Error opening file", ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public SAMFileHeader getHeader() {
        if (this.header == null) {
            this.loadHeader();
        }
        return this.header;
    }

    @Override
    public Set<String> getSequenceNames() {
        SAMFileHeader header = this.getHeader();
        if (header == null) {
            return null;
        }
        HashSet<String> seqNames = new HashSet<String>();
        List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            boolean ensembleChrConventions = true;
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                seqNames.add(chr);
            }
        }
        return seqNames;
    }

    private void loadHeader() {
        InputStream is = null;
        try {
            URL url = new URL(this.serverURL + "?method=samHeader&samFile=" + this.file);
            is = IGVHttpUtils.openConnectionStream(url);
            AsciiLineReader reader = new AsciiLineReader(is);
            SAMTextHeaderCodec code = new SAMTextHeaderCodec();
            this.header = code.decode(reader, null);
        }
        catch (IOException ex) {
            this.log.error("Error opening file", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.log.error("Error closing url stream", ex);
                }
            }
        }
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class RemoteQueryIterator
    implements CloseableIterator<Alignment> {
        InputStream inputStream;
        SAMRecord nextRecord;
        BAMRecordCodec codec;

        public RemoteQueryIterator(InputStream is) {
            this.inputStream = is;
            this.codec = new BAMRecordCodec(BAMRemoteQueryReader.this.header);
            this.codec.setInputStream(is);
            this.advance();
        }

        private void advance() {
            this.nextRecord = this.codec.decode();
        }

        @Override
        public void close() {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException ex) {
                    BAMRemoteQueryReader.this.log.error("Error closing sam record stream", ex);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public SamAlignment next() {
            SamAlignment ret = new SamAlignment(this.nextRecord);
            this.advance();
            return ret;
        }

        @Override
        public void remove() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }
}

