/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.awt.Frame;
import java.io.File;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.util.StringUtil;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.SamIndexCreatorDialog;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.util.FileUtils;

public class SamUtils {
    private static int DEFAULT_TILE_WIDTH = 100000;
    private static final byte ZERO_BYTE = "0".getBytes()[0];
    private static final byte NINE_BYTE = "9".getBytes()[0];

    public static FeatureIndex getIndexFor(String samPath) {
        String idxPath = samPath + ".sai";
        if (FileUtils.resourceExists(idxPath)) {
            return new FeatureIndex(idxPath);
        }
        if (!FileUtils.isRemote(idxPath)) {
            File idxFile = new File(idxPath);
            File samFile = new File(samPath);
            if (!idxFile.exists()) {
                idxFile = SamUtils.getUserIdxFile(samFile);
            }
            if (idxFile.exists() && idxFile.lastModified() > samFile.lastModified()) {
                return new FeatureIndex(idxFile);
            }
            return SamUtils.createIndexFor(samFile);
        }
        return null;
    }

    private static FeatureIndex createIndexFor(File samFile) {
        File newIdxFile = new File(samFile.getAbsolutePath() + ".sai");
        if (!FileUtils.canWriteTo(newIdxFile)) {
            newIdxFile = SamUtils.getUserIdxFile(samFile);
        }
        SamIndexCreatorDialog dialog = new SamIndexCreatorDialog((Frame)IGVMainFrame.getInstance(), true, samFile, newIdxFile);
        dialog.setLocationRelativeTo(IGVMainFrame.getInstance());
        dialog.setVisible(true);
        return dialog.getIndex();
    }

    private static File getUserIdxFile(File samFile) {
        File samDir = new File(UIConstants.getIgvDirectory(), "sam");
        File idxFile = new File(samDir, samFile.getName() + "_" + samFile.getParent().hashCode() + ".sai");
        return idxFile;
    }

    public static int getPaddedReferenceLength(String cigarString) {
        return SamUtils.decodeCigar(cigarString).getPaddedReferenceLength();
    }

    static Cigar decodeCigar(String textCigar) {
        if ("*".equals(textCigar)) {
            return new Cigar();
        }
        Cigar ret = new Cigar();
        byte[] cigarBytes = StringUtil.stringToBytes(textCigar);
        for (int i2 = 0; i2 < cigarBytes.length; ++i2) {
            if (!SamUtils.isDigit(cigarBytes[i2])) {
                throw new IllegalArgumentException("Malformed CIGAR string: " + textCigar);
            }
            int length = cigarBytes[i2] - ZERO_BYTE;
            ++i2;
            while (SamUtils.isDigit(cigarBytes[i2])) {
                length = length * 10 + cigarBytes[i2] - ZERO_BYTE;
                ++i2;
            }
            CigarOperator operator = CigarOperator.characterToEnum(cigarBytes[i2]);
            ret.add(new CigarElement(length, operator));
        }
        return ret;
    }

    private static boolean isDigit(byte c2) {
        return c2 >= ZERO_BYTE && c2 <= NINE_BYTE;
    }
}

