/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.session.ViewContext;
import org.broad.igv.tdf.Bin;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.LRUCache;

public class TDFDataSource
implements DataSource {
    private static Logger log = Logger.getLogger(TDFDataSource.class);
    int maxZoom = 6;
    TDFReader reader;
    private int trackNumber = 0;
    String trackName;
    LRUCache<String, List<LocusScore>> summaryScoreCache = new LRUCache(this, 10);
    Genome genome;
    Interval currentInterval;
    WindowFunction windowFunction = WindowFunction.mean;
    List<WindowFunction> availableFunctions;
    private boolean aggregateLikeBins = true;
    float normalizationFactor = 1.0f;

    public TDFDataSource(TDFReader reader, int trackNumber, String trackName) {
        boolean normalizeCounts = PreferenceManager.getInstance().getBooleanPreference("NORMALIZE_COVERAGE", false);
        this.trackNumber = trackNumber;
        this.trackName = trackName;
        this.reader = reader;
        this.availableFunctions = reader.getWindowFunctions();
        TDFGroup rootGroup = reader.getGroup("/");
        try {
            this.maxZoom = Integer.parseInt(rootGroup.getAttribute("maxZoom"));
        }
        catch (Exception e2) {
            log.error("Error reading attribute 'maxZoom'", e2);
        }
        try {
            String dataGenome = rootGroup.getAttribute("genome");
            this.genome = ViewContext.getInstance().getGenome();
        }
        catch (Exception e3) {
            log.error("Unknown genome " + rootGroup.getAttribute("genome"));
            throw new RuntimeException("Unknown genome " + rootGroup.getAttribute("genome"));
        }
        try {
            String totalCountString;
            if (normalizeCounts && (totalCountString = rootGroup.getAttribute("totalCount")) != null) {
                int totalCount = Integer.parseInt(totalCountString);
                this.normalizationFactor = 1000000.0f / (float)totalCount;
            }
        }
        catch (Exception e4) {
            log.error("Error reading attribute 'maxZoom'", e4);
        }
    }

    public String getPath() {
        return this.reader == null ? null : this.reader.getPath();
    }

    public String getTrackName() {
        return this.trackName;
    }

    @Override
    public double getDataMax() {
        return this.reader.getUpperLimit() * (double)this.normalizationFactor;
    }

    @Override
    public double getDataMin() {
        return this.reader.getLowerLimit() * (double)this.normalizationFactor;
    }

    public void setAggregateLikeBins(boolean aggregateLikeBins) {
        this.aggregateLikeBins = aggregateLikeBins;
    }

    private List<LocusScore> getSummaryScores(String chr, int zoom, int tileNumber, double tileWidth) {
        String key = chr + "_" + zoom + "_" + tileNumber + "_" + (Object)((Object)this.windowFunction);
        List<LocusScore> scores = this.summaryScoreCache.get(key);
        if (scores == null) {
            int startLocation = (int)((double)tileNumber * tileWidth);
            int endLocation = (int)((double)(tileNumber + 1) * tileWidth);
            if (zoom <= this.maxZoom) {
                List<TDFTile> tiles;
                scores = new ArrayList<LocusScore>(1000);
                TDFDataset ds = this.reader.getDataset(chr, zoom, this.windowFunction);
                if (ds != null && (tiles = ds.getTiles(startLocation, endLocation)).size() > 0) {
                    for (TDFTile tile : tiles) {
                        if (tile.getSize() <= 0) continue;
                        for (int i2 = 0; i2 < tile.getSize(); ++i2) {
                            float v = tile.getValue(this.trackNumber, i2);
                            if (Float.isNaN(v)) continue;
                            scores.add(new BasicScore(chr, tile.getStartPosition(i2), tile.getEndPosition(i2), v *= this.normalizationFactor));
                        }
                    }
                }
            } else {
                scores = this.computeSummaryScores(chr, startLocation, endLocation, zoom);
            }
            this.summaryScoreCache.put(key, scores);
        }
        return scores;
    }

    private List<LocusScore> computeSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        ArrayList<LocusScore> scores = new ArrayList<LocusScore>(1000);
        String dsName = "/" + chr + "/raw";
        TDFDataset rawDataset = this.reader.getDataset(dsName);
        if (rawDataset != null) {
            int nBins = Math.min(700, endLocation - startLocation);
            double binSize = (double)(endLocation - startLocation) / (double)nBins;
            Bin[] bins = new Bin[nBins];
            List<TDFTile> rawTiles = rawDataset.getTiles(startLocation, endLocation);
            if (rawTiles.size() > 0) {
                block0: for (TDFTile rawTile : rawTiles) {
                    if (rawTile == null || rawTile.getSize() <= 0) continue;
                    for (int i2 = 0; i2 < rawTile.getSize(); ++i2) {
                        int s = rawTile.getStartPosition(i2);
                        int e2 = Math.max(s, rawTile.getEndPosition(i2) - 1);
                        if (e2 < startLocation) continue;
                        if (s > endLocation) continue block0;
                        String probeName = rawTile.getName(i2);
                        float v = rawTile.getValue(this.trackNumber, i2);
                        if (Float.isNaN(v)) continue;
                        v *= this.normalizationFactor;
                        int startBin = (int)Math.max(0.0, (double)(s - startLocation) / binSize);
                        int endBin = (int)Math.min((double)(bins.length - 1), (double)(e2 - startLocation) / binSize);
                        for (int b2 = startBin; b2 <= endBin; ++b2) {
                            Bin bin = bins[b2];
                            if (bin == null) {
                                int start = (int)((double)startLocation + (double)b2 * binSize);
                                int end = (int)((double)startLocation + (double)(b2 + 1) * binSize);
                                bins[b2] = new Bin(start, end, probeName, v, this.windowFunction);
                                continue;
                            }
                            bin.addValue(probeName, v);
                        }
                    }
                }
            }
            Bin currentBin = null;
            for (int b3 = 0; b3 < bins.length; ++b3) {
                if (bins[b3] == null) continue;
                if (currentBin == null) {
                    currentBin = bins[b3];
                    continue;
                }
                if (this.aggregateLikeBins && currentBin.isExtension(bins[b3])) {
                    currentBin.setEnd(bins[b3].getEnd());
                    continue;
                }
                scores.add(currentBin);
                currentBin = bins[b3];
            }
            if (currentBin != null) {
                scores.add(currentBin);
            }
        }
        return scores;
    }

    @Override
    public synchronized List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        ArrayList<LocusScore> scores = new ArrayList<LocusScore>();
        Chromosome chromosome = this.genome.getChromosome(chr);
        double tileWidth = 0.0;
        if (chr.equals("All")) {
            tileWidth = (double)this.genome.getLength() / 1000.0;
        } else if (chromosome != null) {
            tileWidth = chromosome.getLength() / (int)Math.pow(2.0, zoom);
        }
        if (tileWidth == 0.0) {
            return null;
        }
        int startTile = (int)((double)startLocation / tileWidth);
        int endTile = (int)((double)endLocation / tileWidth);
        block0: for (int t = startTile; t <= endTile; ++t) {
            List<LocusScore> cachedScores = this.getSummaryScores(chr, zoom, t, tileWidth);
            if (cachedScores == null) continue;
            for (LocusScore s : cachedScores) {
                if (s.getEnd() >= startLocation) {
                    scores.add(s);
                    continue;
                }
                if (s.getStart() <= endLocation) continue;
                continue block0;
            }
        }
        return scores;
    }

    @Override
    public TrackType getTrackType() {
        return this.reader.getTrackType();
    }

    @Override
    public void setWindowFunction(WindowFunction wf) {
        this.windowFunction = wf;
    }

    @Override
    public boolean isLogNormalized() {
        return this.getDataMin() < 0.0;
    }

    @Override
    public void refreshData(long timestamp) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.availableFunctions;
    }

    class Interval {
        String chr;
        private int start;
        private int end;
        private int zoom;
        private List<LocusScore> scores;

        public Interval(String chr, int start, int end, int zoom, List<LocusScore> scores) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.zoom = zoom;
            this.scores = scores;
        }

        public boolean contains(String chr, int s, int e2, int zoom) {
            return chr.equals(this.chr) && zoom == this.zoom && s >= this.getStart() && e2 <= this.getEnd();
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<LocusScore> getScores() {
            return this.scores;
        }
    }
}

