/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.util.AsciiLineReader;
import org.broad.igv.util.IGVHttpUtils;

public class TestFileGenerator {
    static String[] chromosome = new String[]{"chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY", "chrM"};
    static int[] chromSize = new int[]{247249719, 242951149, 199501827, 191273063, 180857866, 170899992, 158821424, 146274826, 140273252, 135374737, 134452384, 132349534, 114142980, 106368585, 100338915, 88827254, 78774742, 76117153, 63811651, 62435964, 46944323, 49691432, 154913754, 57772954, 16571};

    public static void main(String[] args) {
        TestFileGenerator.generateTestFile("/Users/jrobinso/IGV/test_25thousand.gct", true, 25000, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateTestFile(String outputFile, boolean sorted, int nRows, int nSamples) {
        int rowsPerChr = Math.max(1, nRows / chromosome.length);
        PrintWriter pw = null;
        FileType type = null;
        if (outputFile.endsWith(".cn")) {
            type = FileType.CN;
        } else if (outputFile.endsWith(".igv")) {
            type = FileType.IGV;
        } else if (outputFile.endsWith(".gct")) {
            type = FileType.GCT;
        } else if (outputFile.endsWith(".wig")) {
            type = FileType.WIG;
        } else {
            System.out.println("Unsupported file type: " + outputFile);
        }
        try {
            pw = new PrintWriter(new FileWriter(outputFile));
            TestFileGenerator.writeHeader(pw, nSamples, type);
            Random rand = new Random();
            ArrayList probes = type == FileType.GCT ? TestFileGenerator.getExpressionProbes() : new ArrayList();
            int n2 = 0;
            for (int i2 = 0; i2 < chromosome.length; ++i2) {
                String chr = chromosome[i2];
                int len = chromSize[i2];
                double delta = (double)len / (double)rowsPerChr;
                double center = -3.0;
                int lastStart = 0;
                if (type == FileType.WIG) {
                    int step = (int)delta;
                    pw.println("fixedStep chrom=" + chr + " start=" + 1 + " step=" + step + " span=" + (step - 1));
                }
                for (int r = 0; r <= rowsPerChr; ++r) {
                    int start = TestFileGenerator.getStart(len, lastStart, r, delta, rand, sorted);
                    lastStart = start + 1;
                    center = 3.0 * ((double)start / (double)len);
                    if (type == FileType.WIG) {
                        pw.println(center + rand.nextGaussian());
                        continue;
                    }
                    switch (type) {
                        case CN: {
                            pw.print("Snp_" + r + "\t" + chr + "\t" + start);
                            break;
                        }
                        case IGV: {
                            int end = Math.max(start + 1, (int)((double)start + Math.random() * 1000.0));
                            pw.print(chr + "\t" + start + "\t" + end + "\tProbe_" + r);
                            break;
                        }
                        case GCT: {
                            String probe = (String)probes.get(n2);
                            pw.print(probe + "\tdesc_" + n2);
                        }
                    }
                    for (int s = 0; s < nSamples; ++s) {
                        double v = center + rand.nextGaussian();
                        pw.print("\t" + v);
                    }
                    pw.println();
                    if (++n2 < probes.size()) continue;
                    n2 = 0;
                }
            }
        }
        catch (IOException e2) {
            System.out.println("Error: " + e2.getMessage());
        }
        finally {
            pw.close();
        }
    }

    public static int getChromosomeIndex(int i2, boolean sorted) {
        if (sorted) {
            return i2;
        }
        return (int)(Math.random() * 24.0);
    }

    public static int getStart(int len, int lastStart, int r, double delta, Random rand, boolean sorted) {
        if (sorted) {
            return Math.min(len, Math.max(lastStart, (int)((double)r * (delta - 1.0) - rand.nextGaussian() * delta)));
        }
        return (int)(Math.random() * (double)len);
    }

    public static void writeHeader(PrintWriter pw, int nSamples, FileType type) {
        if (type == FileType.CN) {
            pw.print("Snp\tChr\tPos");
            for (int s = 0; s < nSamples; ++s) {
                pw.print("\tSample_" + s);
            }
            pw.println();
        } else if (type == FileType.IGV) {
            pw.print("Chr\tStart\tEnd\tProbe");
            for (int s = 0; s < nSamples; ++s) {
                pw.print("\tSample_" + s);
            }
            pw.println();
        } else if (type == FileType.GCT) {
            pw.println("ignored");
            pw.println("ignored");
            pw.print("Probe\tdesc");
            for (int s = 0; s < nSamples; ++s) {
                pw.print("\tSample_" + s);
            }
            pw.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> getExpressionProbes() {
        String urlString = "http://www.broadinstitute.org/igv/resources/probes/affy/affy_human_mappings.txt.gz";
        AsciiLineReader bufReader = null;
        ArrayList<String> probes = new ArrayList<String>(60000);
        try {
            InputStream is = null;
            if (urlString.startsWith("http:") || urlString.startsWith("https:") || urlString.startsWith("ftp:") || urlString.startsWith("file")) {
                URL url = new URL(urlString);
                HttpURLConnection connection = IGVHttpUtils.openConnection(url);
                is = connection.getInputStream();
            } else {
                is = new FileInputStream(urlString);
            }
            if (urlString.endsWith("gz")) {
                is = new GZIPInputStream(is);
            }
            bufReader = new AsciiLineReader(is);
            String nextLine = "";
            while ((nextLine = bufReader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                probes.add(tokens[0]);
            }
            ArrayList<String> arrayList = probes;
            return arrayList;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            if (bufReader != null) {
                bufReader.close();
            }
        }
    }

    static enum FileType {
        CN,
        IGV,
        GCT,
        WIG;

    }
}

