/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.parsers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Locus;
import org.broad.igv.tools.parsers.GeneToLocusHelper;

public class GCTtoIGVConverter {
    private static Logger log = Logger.getLogger(GCTtoIGVConverter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File inputFile, File outputFile, String probeResource, String genome) throws IOException {
        GeneToLocusHelper locusHelper = new GeneToLocusHelper(probeResource, genome);
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(inputFile));
            writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            writer.println("#type=GENE_EXPRESSION");
            reader.readLine();
            reader.readLine();
            String headerLine = reader.readLine();
            String[] tokens = headerLine.split("\t");
            writer.print("Chr\tStart\tEnd\tProbe");
            for (int i2 = 2; i2 < tokens.length; ++i2) {
                writer.print("\t" + tokens[i2]);
            }
            writer.println();
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                DataRow row = new DataRow(nextLine);
                String probe = row.getProbe();
                List<Locus> loci = locusHelper.getLoci(probe, row.getDescription());
                if (loci == null || loci.isEmpty()) {
                    System.out.println("No locus found for: " + probe + "  " + row.getDescription());
                    continue;
                }
                for (Locus locus : loci) {
                    writer.print(locus.getChr() + "\t" + locus.getStart() + "\t" + locus.getEnd() + "\t" + probe);
                    writer.println(row.getData());
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    static class DataRow {
        private String probe;
        private String description;
        private String data;

        DataRow(String string) {
            int firstTab = string.indexOf(9);
            int secondTab = string.indexOf(9, firstTab + 1);
            this.probe = string.substring(0, firstTab);
            this.description = string.substring(firstTab, secondTab);
            this.data = string.substring(secondTab);
        }

        private String getProbe() {
            return this.probe;
        }

        public String getDescription() {
            return this.description;
        }

        public String getData() {
            return this.data;
        }
    }
}

