/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.parsers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.BEDFileParser;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.GeneManager;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.ProbeToGeneMap;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class GeneToLocusHelper {
    static String LOCUS_START_DELIMITER = "|@";
    static String LOCUS_END_DELIMITER = "|";
    Map<String, Feature> probeLocusMap;
    GeneManager geneManager = null;

    public GeneToLocusHelper(String probeResource, String genome) throws IOException {
        if (genome != null) {
            this.geneManager = GeneManager.getGeneManager(genome);
        }
        if (probeResource != null && probeResource.trim().length() > 0) {
            BEDFileParser parser = new BEDFileParser();
            ResourceLocator rl = new ResourceLocator(probeResource);
            AsciiLineReader reader = ParsingUtils.openAsciiReader(rl);
            List<Feature> features = parser.loadFeatures(reader);
            reader.close();
            this.probeLocusMap = new HashMap<String, Feature>(features.size() * 2);
            for (Feature f2 : features) {
                this.probeLocusMap.put(f2.getName(), f2);
            }
        }
    }

    public List<Locus> getLoci(String probeId, String description) {
        String[] genes;
        if (description != null && description.length() > 3) {
            String[] locusStrings = this.getExplicitLocusStrings(description);
            if (locusStrings != null) {
                ArrayList<Locus> loci = new ArrayList<Locus>(locusStrings.length);
                for (String ls : locusStrings) {
                    Locus locus = this.getLocus(ls = ls.trim());
                    if (locus == null || !locus.isValid()) continue;
                    loci.add(locus);
                }
                return loci;
            }
            Locus locus = this.getLocus(probeId);
            if (locus != null && locus.isValid()) {
                return Arrays.asList(locus);
            }
        }
        if ((genes = ProbeToGeneMap.getInstance().getGenesForProbe(probeId)) != null) {
            ArrayList<Locus> loci = new ArrayList<Locus>(genes.length);
            for (String g2 : genes) {
                Locus locus = this.getLocus(g2);
                if (locus == null) continue;
                loci.add(locus);
            }
            return loci;
        }
        return null;
    }

    private String[] getExplicitLocusStrings(String description) {
        int startIndex = description.indexOf(LOCUS_START_DELIMITER);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = description.indexOf(LOCUS_END_DELIMITER, (startIndex += 2) + 1);
        if (endIndex < 0) {
            endIndex = description.length();
        }
        if (endIndex > startIndex + 3) {
            String locusString = description.substring(startIndex, endIndex);
            if (locusString.contains(",")) {
                return locusString.split(",");
            }
            return new String[]{locusString};
        }
        return null;
    }

    Locus getLocus(String geneOrLocusString) {
        Feature gene;
        Locus locus = new Locus(geneOrLocusString);
        if (locus.isValid()) {
            return locus;
        }
        if (this.probeLocusMap != null) {
            Feature f2 = this.probeLocusMap.get(geneOrLocusString);
            if (f2 == null) {
                return null;
            }
            return new Locus(f2.getChr(), f2.getStart(), f2.getEnd());
        }
        if (this.geneManager != null && (gene = FeatureDB.getFeature(geneOrLocusString)) != null) {
            return new Locus(gene.getChr(), gene.getStart(), gene.getEnd());
        }
        return null;
    }
}

