/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import java.io.File;
import java.io.PrintWriter;
import net.sf.samtools.util.AsciiLineReader;
import org.broad.igv.tools.sort.Parser;
import org.broad.igv.tools.sort.Sorter;

public class CNSorter
extends Sorter {
    public CNSorter(File inputFile, File outputFile) {
        super(inputFile, outputFile);
    }

    @Override
    String writeHeader(AsciiLineReader reader, PrintWriter writer) {
        String nextLine = reader.readLine();
        while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
            writer.println(nextLine);
            nextLine = reader.readLine();
        }
        writer.println(nextLine);
        return null;
    }

    @Override
    Parser getParser() {
        String fn;
        String tmp = this.inputFile.getName();
        String string = fn = tmp.endsWith(".txt") ? tmp.substring(0, tmp.length() - 4) : tmp;
        if (fn.endsWith(".cn") || fn.endsWith(".xcn") || fn.endsWith(".snp")) {
            return new Parser(1, 2);
        }
        if (fn.endsWith(".igv")) {
            return new Parser(0, 1);
        }
        throw new RuntimeException("Unrecognized copy number extension: " + fn);
    }
}

