/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import net.sf.samtools.util.AsciiLineReader;
import org.broad.igv.tools.sort.SortableRecord;
import org.broad.igv.util.ParsingUtils;

public class Parser {
    private int chrCol;
    private int startCol;
    private String[] fields;

    public Parser(int chrCol, int startCol) {
        this.chrCol = chrCol;
        this.startCol = startCol;
        this.fields = new String[this.startCol + 1];
    }

    public SortableRecord readNextRecord(AsciiLineReader reader) {
        String nextLine = reader.readLine();
        if (nextLine == null) {
            return null;
        }
        return this.createRecord(nextLine);
    }

    public SortableRecord createRecord(String nextLine) {
        int start;
        int nTokens = ParsingUtils.split(nextLine, this.fields, '\t');
        String chr = this.fields[this.chrCol];
        try {
            start = Integer.parseInt(this.fields[this.startCol].trim());
        }
        catch (NumberFormatException e2) {
            start = Integer.MAX_VALUE;
        }
        String text = nextLine;
        return new SortableRecord(chr, start, text);
    }
}

