/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;

public class AttributeManager {
    private static Logger log = Logger.getLogger(AttributeManager.class);
    private static AttributeManager singleton;
    public static final String ATTRIBUTES_LOADED_PROPERTY = "ATTRIBUTES_LOADED_PROPERTY";
    public static final String ATTRIBUTES_NARROWED_PROPERTY = "ATTRIBUTES_NARROWED_PROPERTY";
    private PropertyChangeSupport propertyChangeSupport;
    Set<ResourceLocator> loadedResources = new HashSet<ResourceLocator>();
    LinkedHashMap<String, Map<String, String>> attributeMap = new LinkedHashMap();
    List<String> attributeKeys = new ArrayList<String>();
    Set<String> hiddenAttributes = new HashSet<String>();
    Map<String, Set<String>> uniqueAttributeValues;

    private AttributeManager() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.uniqueAttributeValues = new HashMap<String, Set<String>>();
    }

    public static synchronized AttributeManager getInstance() {
        if (singleton == null) {
            singleton = new AttributeManager();
        }
        return singleton;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected String getAttribute(String trackName, String attributeKey) {
        Map<String, String> attributes = this.attributeMap.get(trackName);
        return attributes == null ? null : attributes.get(attributeKey);
    }

    public List<String> getAttributeKeys() {
        return new ArrayList<String>(this.attributeKeys);
    }

    public Set<String> getHiddenAttributes() {
        return this.hiddenAttributes;
    }

    public void setHiddenAttributes(Set<String> attributes) {
        if (attributes == null) {
            this.hiddenAttributes.clear();
        } else {
            this.hiddenAttributes = attributes;
        }
    }

    public void clearAllAttributes() {
        this.attributeMap.clear();
        this.attributeKeys.clear();
        this.uniqueAttributeValues.clear();
        this.hiddenAttributes.clear();
        this.loadedResources = new HashSet<ResourceLocator>();
    }

    private void addAttribute(String trackIdentifier, String attributeKey, String attributeValue) {
        this.addAttributeKey(attributeKey);
        Set<String> uniqueSet = this.uniqueAttributeValues.get(attributeKey);
        if (uniqueSet == null) {
            uniqueSet = new HashSet<String>();
            this.uniqueAttributeValues.put(attributeKey, uniqueSet);
        }
        uniqueSet.add(attributeValue);
        Map<String, String> attributes = this.attributeMap.get(trackIdentifier);
        if (attributes == null) {
            attributes = new LinkedHashMap<String, String>();
            this.attributeMap.put(trackIdentifier, attributes);
        }
        attributes.put(attributeKey, attributeValue);
    }

    public void addAttributeKey(String key) {
        if (!this.attributeKeys.contains(key) && !key.startsWith("#")) {
            this.attributeKeys.add(key);
        }
    }

    public void loadSampleInfo(ResourceLocator locator) {
        AsciiLineReader reader = null;
        String nextLine = null;
        try {
            reader = ParsingUtils.openAsciiReader(locator);
            nextLine = reader.readLine();
            if (nextLine.toLowerCase().startsWith("#sampletable")) {
                this.loadSampleTable(reader, nextLine, locator.getPath());
            } else {
                this.loadOldSamapleInfo(reader, nextLine, locator.getPath());
            }
            this.loadedResources.add(locator);
            IGVMainFrame.getInstance().getTrackManager().resetOverlayTracks();
            IGVMainFrame.getInstance().doRefresh();
        }
        catch (IOException ex) {
            log.error("Error loading attribute file", ex);
            throw new DataLoadException("Error reading attribute file", locator.getPath());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            this.firePropertyChange(this, ATTRIBUTES_LOADED_PROPERTY, null, null);
        }
    }

    private String loadOldSamapleInfo(AsciiLineReader reader, String nextLine, String path) throws IOException {
        boolean foundAttributes = false;
        String[] colHeadings = nextLine.split("\t");
        int nLines = 0;
        int lineLimit = 100000;
        while ((nextLine = reader.readLine()) != null && nLines++ <= lineLimit) {
            String[] values = nextLine.split("\t");
            if (values.length < 2) continue;
            String arrayName = values[0].trim();
            for (int i2 = 0; i2 < colHeadings.length; ++i2) {
                String attributeName = colHeadings[i2].trim();
                String attributeValue = i2 < values.length ? values[i2].trim() : "";
                this.addAttribute(arrayName, attributeName, attributeValue);
                foundAttributes = true;
            }
        }
        if (!foundAttributes) {
            throw new DataLoadException("Could not determine file type.  Does file have proper extension? ", path);
        }
        return nextLine;
    }

    private void loadSampleTable(AsciiLineReader reader, String nextLine, String path) throws IOException {
        String sample;
        nextLine = reader.readLine();
        String[] colHeadings = nextLine.split("\t");
        HashMap sampleTable = new HashMap();
        boolean foundAttributes = false;
        int nLines = 0;
        int lineLimit = 100000;
        while ((nextLine = reader.readLine()) != null && nLines++ <= lineLimit && !nextLine.toLowerCase().startsWith("#samplemapping")) {
            String[] values = nextLine.split("\t");
            if (values.length < 2) continue;
            String sampleName = values[0].trim();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(colHeadings.length);
            for (int i2 = 0; i2 < colHeadings.length; ++i2) {
                String attributeName = colHeadings[i2].trim();
                String attributeValue = i2 < values.length ? values[i2].trim() : "";
                attributes.add(new Attribute(attributeName, attributeValue));
                foundAttributes = true;
            }
            sampleTable.put(sampleName, attributes);
        }
        if (!foundAttributes) {
            throw new DataLoadException("Could not determine file type.  Does file have proper extension? ", path);
        }
        if (nextLine.toLowerCase().startsWith("#samplemapping")) {
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                if (tokens.length < 2) continue;
                String array = tokens[0];
                sample = tokens[1];
                List attributes = (List)sampleTable.get(sample);
                if (attributes == null) {
                    log.info("Warning: sample in mapping section:  " + sample + " in sample table file " + path);
                    continue;
                }
                for (Attribute att : attributes) {
                    this.addAttribute(array, att.getKey(), att.getValue());
                }
            }
        } else {
            for (Map.Entry entry : sampleTable.entrySet()) {
                sample = (String)entry.getKey();
                for (Attribute att : (List)entry.getValue()) {
                    this.addAttribute(sample, att.getKey(), att.getValue());
                }
            }
        }
    }

    public void firePropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
        this.propertyChangeSupport.firePropertyChange(event);
    }

    public Comparator getAttributeComparator() {
        return Utilities.getNumericStringComparator();
    }

    public Set<ResourceLocator> getLoadedResources() {
        return this.loadedResources;
    }

    private static class Attribute {
        private String key;
        private String value;

        public Attribute(String key, String value) {
            this.key = key.toUpperCase();
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

