/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;

public class FeatureCollectionSource
implements FeatureSource {
    private TrackType type;
    private TrackProperties properties;
    private Map<String, List<Feature>> featureMap;
    CoverageDataSource coverageData;

    public FeatureCollectionSource(List<Feature> allFeatures) {
        this.initFeatures(allFeatures);
        this.coverageData = new CoverageDataSource();
        this.coverageData.computeGenomeCoverage();
        this.sampleGenomeFeatures();
    }

    public FeatureCollectionSource(Map<String, List<Feature>> features) {
        this.featureMap = features;
        this.coverageData = new CoverageDataSource();
        this.coverageData.computeGenomeCoverage();
        this.sampleGenomeFeatures();
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int startLocation, int endLocation, int zoom) {
        return this.coverageData == null ? Collections.emptyList() : this.coverageData.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
    }

    public DataSource getCoverageSource() {
        return this.coverageData;
    }

    @Override
    public Iterator<Feature> getFeatures(String chr, int start, int end) {
        return this.featureMap.containsKey(chr) ? this.featureMap.get(chr).iterator() : null;
    }

    public List<Feature> getFeatures(String chr) {
        return this.featureMap.get(chr);
    }

    @Override
    public int getBinSize() {
        return 0;
    }

    @Override
    public void setBinSize(int size) {
    }

    private void initFeatures(List<Feature> allFeatures) {
        this.featureMap = new HashMap<String, List<Feature>>();
        for (Feature feature : allFeatures) {
            List<Feature> fList = this.featureMap.get(feature.getChr());
            if (fList == null) {
                fList = new ArrayList<Feature>();
                this.featureMap.put(feature.getChr(), fList);
            }
            fList.add(feature);
        }
        for (List list : this.featureMap.values()) {
            FeatureUtils.sortFeatureList(list);
        }
        if (this.featureMap.size() < 100) {
            this.sampleGenomeFeatures();
        }
    }

    private void setFeatures(String chr, List<Feature> features) {
        FeatureUtils.sortFeatureList(features);
        this.featureMap.put(chr, features);
    }

    public TrackType getType() {
        return this.type;
    }

    public void setType(TrackType type) {
        this.type = type;
    }

    protected void sampleGenomeFeatures() {
        ArrayList<Feature> chrAllFeatures = new ArrayList<Feature>(1000);
        Genome currentGenome = ViewContext.getInstance().getGenome();
        int sampleLength = (int)((double)currentGenome.getLength() / 700000.0);
        int lastFeaturePosition = -1;
        for (String chr : currentGenome.getChromosomeNames()) {
            List<Feature> features = this.getFeatures(chr);
            if (features == null) continue;
            long offset = currentGenome.getCumulativeOffset(chr);
            for (Feature f2 : features) {
                int genStart = (int)((offset + (long)f2.getStart()) / 1000L);
                int genEnd = (int)((offset + (long)f2.getEnd()) / 1000L);
                if (genEnd <= lastFeaturePosition + sampleLength) continue;
                Feature f22 = (Feature)f2.copy();
                f22.setChr("All");
                f22.setStart(genStart);
                f22.setEnd(genEnd);
                if (f22 instanceof BasicFeature) {
                    BasicFeature bf = (BasicFeature)f2;
                    BasicFeature bf2 = (BasicFeature)f22;
                    bf2.setThickEnd((int)((offset + (long)bf.getThickEnd()) / 1000L));
                    bf2.setThickStart((int)((offset + (long)bf.getThickStart()) / 1000L));
                }
                f22.setName(f2.getName());
                chrAllFeatures.add(f22);
                lastFeaturePosition = genEnd;
            }
        }
        this.setFeatures("All", chrAllFeatures);
    }

    class CoverageDataSource
    extends AbstractDataSource {
        int windowSize = 1000;
        double dataMin = 0.0;
        double dataMax = 0.0;
        Map<String, DataTile> dataCache = new HashMap<String, DataTile>();

        CoverageDataSource() {
        }

        @Override
        protected int getNumZoomLevels(String chr) {
            return 0;
        }

        @Override
        protected DataTile getRawData(String chr, int startLocation, int endLocation) {
            DataTile coverageData = this.dataCache.get(chr);
            if (coverageData == null) {
                coverageData = this.computeCoverage(chr, startLocation, endLocation);
                this.dataCache.put(chr, coverageData);
            }
            return coverageData;
        }

        @Override
        public int getLongestFeature(String chr) {
            return this.windowSize;
        }

        @Override
        public double getDataMax() {
            return this.dataMax;
        }

        @Override
        public double getDataMin() {
            return this.dataMin;
        }

        @Override
        public TrackType getTrackType() {
            return TrackType.OTHER;
        }

        private DataTile computeCoverage(String chr, int start, int end) {
            int nBins = (end - start) / this.windowSize + 1;
            int[] starts = new int[nBins];
            int[] ends = new int[nBins];
            for (int i2 = 0; i2 < nBins; ++i2) {
                starts[i2] = start + i2 * this.windowSize;
                ends[i2] = starts[i2] + this.windowSize;
            }
            float[] values = new float[nBins];
            Iterator features = ((List)FeatureCollectionSource.this.featureMap.get(chr)).iterator();
            if (features != null) {
                while (features.hasNext()) {
                    Feature f2 = (Feature)features.next();
                    int startBin = f2.getStart() / this.windowSize;
                    int endBin = f2.getEnd() / this.windowSize;
                    for (int i3 = startBin; i3 < endBin; ++i3) {
                        values[i3] = values[i3] + 1.0f;
                        this.dataMax = Math.max(this.dataMax, (double)values[i3]);
                    }
                }
            }
            return new DataTile(starts, ends, values, null);
        }

        public String getValueString(String chr, double position) {
            int zoom = Math.max(0, ViewContext.getInstance().getZoom());
            List<LocusScore> scores = this.getSummaryScoresForRange(chr, (int)position - 10, (int)position + 10, zoom);
            double bpPerPixel = ViewContext.getInstance().getScale();
            double minWidth = 2.0 * bpPerPixel;
            if (scores == null) {
                return "";
            }
            LocusScore score = FeatureUtils.getFeatureAt(position, minWidth, scores);
            return score == null ? "" : "Mean count: " + score.getScore();
        }

        protected void computeGenomeCoverage() {
            int nBins = 1000;
            int[] starts = new int[nBins];
            int[] ends = new int[nBins];
            float[] values = new float[nBins];
            Arrays.fill(values, 0.0f);
            Genome currentGenome = ViewContext.getInstance().getGenome();
            double step = (double)currentGenome.getLength() / 1000.0 / (double)nBins;
            for (int i2 = 0; i2 < nBins; ++i2) {
                starts[i2] = (int)((double)i2 * step);
                ends[i2] = (int)((double)(i2 + 1) * step);
            }
            for (String chr : currentGenome.getChromosomeNames()) {
                List features = (List)FeatureCollectionSource.this.featureMap.get(chr);
                if (features == null) continue;
                long offset = currentGenome.getCumulativeOffset(chr);
                for (Feature f2 : features) {
                    int genStart = (int)((offset + (long)f2.getStart()) / 1000L);
                    int genEnd = (int)((offset + (long)f2.getEnd()) / 1000L);
                    int binStart = Math.min(values.length - 1, (int)((double)genStart / step));
                    int binEnd = Math.min(values.length - 1, (int)((double)genEnd / step));
                    for (int i3 = binStart; i3 <= binEnd; ++i3) {
                        values[i3] = values[i3] + 1.0f;
                        this.dataMax = Math.max(this.dataMax, (double)values[i3]);
                    }
                }
            }
            this.dataCache.put("All", new DataTile(starts, ends, values, null));
        }
    }
}

