/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class RenderContext {
    private String genomeId;
    private String chr;
    private double startLocation;
    private double endLocation;
    private int zoom;
    private double scale;
    private Graphics2D graphics;
    private Map<Color, Graphics2D> graphicCacheByColor;
    Rectangle visibleRect;

    public RenderContext(String genomeId, String chr, double startLocation, double endLocation, int zoom, double scale, Rectangle visibleRect, Graphics2D graphics) {
        this.genomeId = genomeId;
        this.chr = chr;
        this.startLocation = startLocation;
        this.endLocation = endLocation;
        this.zoom = zoom;
        this.scale = scale;
        this.graphics = graphics;
        this.visibleRect = visibleRect;
        this.graphicCacheByColor = new HashMap<Color, Graphics2D>();
    }

    public Graphics2D getGraphic2DForColor(Color color) {
        Graphics2D g2 = this.graphicCacheByColor.get(color);
        if (g2 == null) {
            g2 = (Graphics2D)this.graphics.create();
            this.graphicCacheByColor.put(color, g2);
            g2.setColor(color);
        }
        return g2;
    }

    public String getChr() {
        return this.chr;
    }

    public double getOrigin() {
        return this.startLocation;
    }

    public double getEndLocation() {
        return this.endLocation;
    }

    public double getScale() {
        return this.scale;
    }

    public Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public int getZoom() {
        return this.zoom;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void dispose() {
        for (Graphics2D g2 : this.graphicCacheByColor.values()) {
            g2.dispose();
        }
        this.graphicCacheByColor.clear();
    }

    public String getGenomeId() {
        return this.genomeId;
    }

    public void setGenomeId(String genomeId) {
        this.genomeId = genomeId;
    }
}

