/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.GeneManager;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.renderer.BasicFeatureRenderer;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.GeneTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackLoader;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.DragEventManager;
import org.broad.igv.ui.panel.DragListener;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class TrackManager {
    private static Logger log = Logger.getLogger(TrackManager.class);
    IGVMainFrame mainFrame;
    private TrackLoader loader;
    private final Map<String, TrackPanelScrollPane> trackPanelScrollPanes = new Hashtable<String, TrackPanelScrollPane>();
    private String groupByAttribute = null;
    private Track geneTrack;
    private Map<String, List<Track>> overlayTracksMap = new HashMap<String, List<Track>>();
    private Set<TrackType> loadedTypes = new HashSet<TrackType>();
    public static final String DATA_PANEL_NAME = "DataPanel";
    public static final String FEATURE_PANEL_NAME = "FeaturePanel";

    public Track getGeneTrack() {
        return this.geneTrack;
    }

    public Set<TrackType> getLoadedTypes() {
        return this.loadedTypes;
    }

    public TrackManager(IGVMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.loader = new TrackLoader();
    }

    public void putScrollPane(String name, TrackPanelScrollPane sp) {
        this.trackPanelScrollPanes.put(name, sp);
    }

    public TrackPanelScrollPane getScrollPane(String name) {
        return this.trackPanelScrollPanes.get(name);
    }

    public Collection<TrackPanelScrollPane> getTrackPanelScrollPanes() {
        return this.trackPanelScrollPanes.values();
    }

    public void removeScrollPane(String name) {
        this.trackPanelScrollPanes.remove(name);
    }

    public void clearScrollPanes() {
        this.trackPanelScrollPanes.clear();
    }

    public void setGroupByAttribute(String attributeName) {
        this.groupByAttribute = attributeName;
        this.groupTracksByAttribute();
    }

    public void reset() {
        this.groupByAttribute = "";
        TrackPanelScrollPane tsp = this.trackPanelScrollPanes.get(DATA_PANEL_NAME);
        if (tsp != null) {
            tsp.getTrackPanel().reset();
        }
    }

    public void groupTracksByAttribute() {
        TrackPanelScrollPane tsp = this.trackPanelScrollPanes.get(DATA_PANEL_NAME);
        if (tsp != null) {
            tsp.getTrackPanel().groupTracksByAttribute(this.groupByAttribute);
        }
    }

    public void reloadSAMTracks() {
        for (Track t : this.getAllTracks(false)) {
            if (!(t instanceof AlignmentTrack)) continue;
            ((AlignmentTrack)t).reloadData();
        }
    }

    public void sortAlignmentTracks(AlignmentTrack.SortOption option) {
        for (Track t : this.getAllTracks(false)) {
            if (!(t instanceof AlignmentTrack)) continue;
            ((AlignmentTrack)t).sortRows(option);
        }
    }

    public void sortAlignmentTracks(AlignmentTrack.SortOption option, double location) {
        for (Track t : this.getAllTracks(false)) {
            if (!(t instanceof AlignmentTrack)) continue;
            ((AlignmentTrack)t).sortRows(option, location);
        }
    }

    public void packAlignmentTracks() {
        for (Track t : this.getAllTracks(false)) {
            if (!(t instanceof AlignmentTrack)) continue;
            ((AlignmentTrack)t).packAlignments();
        }
    }

    public void collapseTracks() {
        for (Track t : this.getAllTracks(true)) {
            t.setExpanded(false);
        }
    }

    public void expandTracks() {
        for (Track t : this.getAllTracks(true)) {
            t.setExpanded(true);
        }
    }

    public void collapseTrack(String trackName) {
        for (Track t : this.getAllTracks(true)) {
            if (!t.getName().equals(trackName)) continue;
            t.setExpanded(false);
        }
    }

    public void expandTrack(String trackName) {
        for (Track t : this.getAllTracks(true)) {
            if (!t.getName().equals(trackName)) continue;
            t.setExpanded(true);
        }
    }

    public boolean loadResources(Collection<ResourceLocator> locators) {
        boolean tracksWereLoaded = false;
        log.info("Loading" + locators.size() + " resources.");
        MessageCollection messages = new MessageCollection();
        for (ResourceLocator locator : locators) {
            File trackSetFile;
            if (locator.isLocal() && !(trackSetFile = new File(locator.getPath())).exists()) {
                messages.append("File not found: " + locator.getPath() + "\n");
                continue;
            }
            TrackPanel group = this.getPanelFor(locator);
            try {
                List<Track> tracks = this.load(locator);
                group.addTracks(tracks);
                tracksWereLoaded = tracks.size() > 0;
            }
            catch (Throwable e2) {
                log.error("Error loading tracks", e2);
                messages.append(e2.getMessage());
            }
        }
        this.groupTracksByAttribute();
        this.resetOverlayTracks();
        if (!messages.isEmpty()) {
            for (String message : messages.getMessages()) {
                MessageUtils.showMessage(message);
            }
        }
        return tracksWereLoaded;
    }

    public List<Track> load(ResourceLocator locator) {
        try {
            List<Track> newTracks = this.loader.load(locator);
            if (newTracks.size() > 0) {
                for (Track track : newTracks) {
                    track.setSourceFile(locator.getPath());
                    if (locator.getUrl() != null) {
                        track.setUrl(locator.getUrl());
                    }
                    track.setAttributeValue("NAME", track.getName());
                    track.setAttributeValue("DATA FILE", locator.getPath());
                    track.setAttributeValue("DATA TYPE", track.getTrackType().toString());
                }
            }
            return newTracks;
        }
        catch (DataLoadException dle) {
            throw dle;
        }
        catch (Exception e2) {
            log.error(e2);
            throw new DataLoadException(e2.getMessage(), locator.getPath());
        }
    }

    public void addLoadedType(TrackType type) {
        this.loadedTypes.add(type);
    }

    public void load(File file, TrackPanel panel) {
        ResourceLocator locator = new ResourceLocator(file.getAbsolutePath());
        List<Track> tracks = this.load(locator);
        panel.addTracks(tracks);
    }

    public void resetOverlayTracks() {
        String overlayAttribute;
        this.overlayTracksMap.clear();
        if (PreferenceManager.getInstance().getOverlayTracks() && (overlayAttribute = IGVMainFrame.getInstance().getSession().getOverlayAttribute()) != null) {
            for (Track track : this.getAllTracks(false)) {
                String value;
                if (track == null || track.getTrackType() != UIConstants.overlayTrackType || (value = track.getAttributeValue(overlayAttribute)) == null) continue;
                List<Track> trackList = this.overlayTracksMap.get(value);
                if (trackList == null) {
                    trackList = new ArrayList<Track>();
                    this.overlayTracksMap.put(value, trackList);
                }
                trackList.add(track);
            }
        }
        boolean displayOverlays = IGVMainFrame.getInstance().getSession().getDisplayOverlayTracks();
        for (Track track : this.getAllTracks(false)) {
            if (track == null || track.getTrackType() != UIConstants.overlayTrackType) continue;
            track.setOverlayVisible(displayOverlays);
        }
    }

    public int getVisibleTrackCount() {
        int count = 0;
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel tsv = tsp.getTrackPanel();
            count += tsv.getVisibleTrackCount();
        }
        return count;
    }

    public List<Track> getAllTracks(boolean includeGeneTrack) {
        ArrayList<Track> allTracks = new ArrayList<Track>();
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel tsv = tsp.getTrackPanel();
            allTracks.addAll(tsv.getTracks());
        }
        if (this.geneTrack != null && !includeGeneTrack) {
            allTracks.remove(this.geneTrack);
        }
        return allTracks;
    }

    public void clearSelections() {
        for (Track t : this.getAllTracks(true)) {
            t.setSelected(false);
        }
    }

    public void setTrackSelections(Set<Track> selectedTracks) {
        for (Track t : this.getAllTracks(true)) {
            if (!selectedTracks.contains(t)) continue;
            t.setSelected(true);
        }
    }

    public void shiftSelectTracks(Track track) {
        int clickedTrackIndex;
        List<Track> allTracks = this.getAllTracks(true);
        int otherIndex = clickedTrackIndex = allTracks.indexOf(track);
        for (int i2 = 0; i2 < allTracks.size(); ++i2) {
            if (!allTracks.get(i2).isSelected() || i2 == clickedTrackIndex) continue;
            otherIndex = i2;
            break;
        }
        int left = Math.min(otherIndex, clickedTrackIndex);
        int right = Math.max(otherIndex, clickedTrackIndex);
        for (int i3 = left; i3 <= right; ++i3) {
            allTracks.get(i3).setSelected(true);
        }
    }

    public void toggleTrackSelections(Set<Track> selectedTracks) {
        for (Track t : this.getAllTracks(true)) {
            if (!selectedTracks.contains(t)) continue;
            t.setSelected(!t.isSelected());
        }
    }

    public Collection<Track> getSelectedTracks() {
        HashSet<Track> selectedTracks = new HashSet<Track>();
        for (Track t : this.getAllTracks(true)) {
            if (!t.isSelected()) continue;
            selectedTracks.add(t);
        }
        return selectedTracks;
    }

    public Set<ResourceLocator> getDataResourceLocators() {
        HashSet<ResourceLocator> locators = new HashSet<ResourceLocator>();
        for (Track track : this.getAllTracks(false)) {
            ResourceLocator locator = track.getResourceLocator();
            if (locator == null) continue;
            locators.add(locator);
        }
        return locators;
    }

    public void setAllTrackHeights(int newHeight) {
        for (Track track : this.getAllTracks(false)) {
            track.setHeight(newHeight);
        }
    }

    public void unloadTracks(Collection<ResourceLocator> locators) {
        ArrayList<Track> tracksToRemove = new ArrayList<Track>();
        HashSet<ResourceLocator> locatorSet = new HashSet<ResourceLocator>(locators);
        for (Track t : this.getAllTracks(true)) {
            if (!locatorSet.contains(t.getResourceLocator())) continue;
            tracksToRemove.add(t);
        }
        this.removeTracks(tracksToRemove);
    }

    public void removeTracks(Collection<Track> tracksToRemove) {
        HashSet<Track> tmp = new HashSet<Track>(tracksToRemove);
        for (Track t : tracksToRemove) {
            if (!(t instanceof AlignmentTrack)) continue;
            CoverageTrack ct = ((AlignmentTrack)t).getCoverageTrack();
            tmp.add(ct);
        }
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel tsv = tsp.getTrackPanel();
            tsv.removeTracks(tmp);
            if (tsv.hasTracks()) continue;
            this.mainFrame.removeDataPanel(tsp.getName());
        }
        for (Track t : tmp) {
            if (!(t instanceof DragListener)) continue;
            DragEventManager.getInstance().removeDragListener((DragListener)((Object)t));
        }
    }

    public void sortAllTracksByAttributes(String[] attributeNames, boolean[] ascending) {
        assert (attributeNames.length == ascending.length);
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel tsv = tsp.getTrackPanel();
            tsv.sortTracksByAttributes(attributeNames, ascending);
        }
    }

    public void sortAllTracksByPosition(List<String> trackIds) {
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel tsv = tsp.getTrackPanel();
            tsv.sortTracksByPosition(trackIds);
        }
    }

    public TrackPanel getPanelFor(ResourceLocator locator) {
        String path = locator.getPath().toLowerCase();
        if (PreferenceManager.getInstance().isShowSingleTrackPane()) {
            return this.mainFrame.getDataPanel(DATA_PANEL_NAME);
        }
        if (path.endsWith(".sam") || path.endsWith(".bam") || path.endsWith(".sam.list") || path.endsWith(".bam.list") || path.endsWith(".aligned") || path.endsWith(".sorted.txt")) {
            String newPanelName = "Panel" + System.currentTimeMillis();
            return this.mainFrame.addDataPanel(newPanelName).getTrackPanel();
        }
        return this.getDefaultPanel(locator);
    }

    private TrackPanel getDefaultPanel(ResourceLocator locator) {
        if (locator.getType() != null && locator.getType().equalsIgnoreCase("das")) {
            return this.mainFrame.getDataPanel(FEATURE_PANEL_NAME);
        }
        String filename = locator.getPath().toLowerCase();
        if (filename.endsWith(".txt") || filename.endsWith(".tab") || filename.endsWith(".xls") || filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.lastIndexOf("."));
        }
        if (filename.contains("refflat") || filename.contains("ucscgene") || filename.contains("genepred") || filename.contains("ensgene") || filename.contains("refgene") || filename.endsWith("gff") || filename.endsWith("gtf") || filename.endsWith("gff3") || filename.endsWith("embl") || filename.endsWith("bed") || filename.endsWith("gistic") || filename.endsWith("bedz") || filename.endsWith("repmask") || filename.contains("dranger")) {
            return this.mainFrame.getDataPanel(FEATURE_PANEL_NAME);
        }
        return this.mainFrame.getDataPanel(DATA_PANEL_NAME);
    }

    public void sortByRegionScore(RegionOfInterest region, RegionScoreType type) {
        if (region == null) {
            ViewContext vc = ViewContext.getInstance();
            String chr = vc.getChrName();
            int start = (int)vc.getOrigin();
            int end = (int)vc.getEnd() + 1;
            region = new RegionOfInterest(chr, start, end, "");
        }
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel tsv = tsp.getTrackPanel();
            tsv.sortByRegionsScore(region, type);
        }
    }

    public String getGroupByAttribute() {
        return this.groupByAttribute;
    }

    public List<Track> getOverlayTracks(Track track) {
        String overlayAttribute = IGVMainFrame.getInstance().getSession().getOverlayAttribute();
        String value = track.getAttributeValue(overlayAttribute);
        return this.overlayTracksMap.get(value);
    }

    public void loadGeneTrack(String genomeId) {
        GeneManager geneManager = GeneManager.getGeneManager(genomeId);
        Map<String, List<Feature>> featureMap = null;
        featureMap = geneManager != null ? geneManager.getChromsomeGeneMap() : new HashMap<String, List<Feature>>();
        FeatureTrack geneFeatureTrack = new FeatureTrack("Genes", (FeatureSource)new FeatureCollectionSource(featureMap));
        geneFeatureTrack.setMinimumHeight(30);
        geneFeatureTrack.setHeight(30);
        geneFeatureTrack.setRendererClass(BasicFeatureRenderer.class);
        geneFeatureTrack.setColor(Color.BLUE.darker());
        SequenceTrack seqTrack = new SequenceTrack("Reference");
        if (geneManager != null) {
            if (geneManager.getTrackProperties() != null) {
                geneFeatureTrack.setTrackProperties(geneManager.getTrackProperties());
            }
            String geneTrackName = geneManager.getGeneTrackName();
            GeneTrack gt = new GeneTrack(geneFeatureTrack, seqTrack);
            gt.setName(geneTrackName);
            gt.setHeight(45);
            Genome genome = GenomeManager.getInstance().getGenome(genomeId);
            if (genome != null && gt.getUrl() == null) {
                gt.setUrl(genome.getAnnotationURL());
            }
            this.setGeneTrack(gt);
        } else {
            this.setGeneTrack(seqTrack);
        }
    }

    private void setGeneTrack(Track newGeneTrack) {
        TrackPanelScrollPane tsp;
        TrackPanel tsv;
        boolean foundGeneTrack = false;
        Iterator<TrackPanelScrollPane> i$ = this.getTrackPanelScrollPanes().iterator();
        while (i$.hasNext() && !(foundGeneTrack = (tsv = (tsp = i$.next()).getTrackPanel()).setGeneTrack(this.geneTrack, newGeneTrack))) {
        }
        if (!foundGeneTrack) {
            if (PreferenceManager.getInstance().isShowSingleTrackPane()) {
                this.mainFrame.getDataPanel(DATA_PANEL_NAME).addTrack(newGeneTrack);
            } else {
                this.mainFrame.getDataPanel(FEATURE_PANEL_NAME).addTrack(newGeneTrack);
            }
        }
        this.geneTrack = newGeneTrack;
    }
}

