/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import com.jidesoft.swing.JidePopupMenu;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.LineplotRenderer;
import org.broad.igv.renderer.RNAiBarChartRenderer;
import org.broad.igv.renderer.ScatterplotRenderer;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.GeneTrack;
import org.broad.igv.track.HDFDataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.DataRangeDialog;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.HeatmapScaleDialog;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;

public class TrackMenuUtils {
    static Logger log = Logger.getLogger(TrackMenuUtils.class);
    static final String LEADING_HEADING_SPACER = "  ";

    public static JPopupMenu getPopupMenu(Collection<Track> tracks, String title, MouseEvent e2) {
        if (log.isDebugEnabled()) {
            log.debug("enter getPopupMenu");
        }
        JidePopupMenu menu = TrackMenuUtils.getEmptyPopup(title);
        TrackMenuUtils.addStandardItems(menu, tracks, e2);
        return menu;
    }

    public static JidePopupMenu getEmptyPopup(String title) {
        JidePopupMenu menu = new JidePopupMenu();
        JLabel popupTitle = new JLabel(LEADING_HEADING_SPACER + title, 0);
        Font newFont = FontManager.getScalableFont(1, 12);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            menu.add(popupTitle);
            menu.addSeparator();
        }
        return menu;
    }

    public static void addStandardItems(JPopupMenu menu, Collection<Track> tracks, MouseEvent e2) {
        boolean hasDataTracks = false;
        boolean hasFeatureTracks = false;
        for (Track track : tracks) {
            if (track instanceof DataTrack || track instanceof HDFDataTrack) {
                hasDataTracks = true;
            } else if (track instanceof FeatureTrack || track instanceof GeneTrack) {
                hasFeatureTracks = true;
            }
            if (!hasDataTracks || !hasFeatureTracks) continue;
            break;
        }
        if (hasDataTracks && hasFeatureTracks) {
            TrackMenuUtils.addSharedItems(menu, tracks);
        } else if (hasDataTracks) {
            TrackMenuUtils.addDataItems(menu, tracks);
        } else {
            TrackMenuUtils.addFeatureItems(menu, tracks, e2, hasFeatureTracks);
        }
    }

    private static void addDataItems(JPopupMenu menu, final Collection<Track> tracks) {
        if (log.isDebugEnabled()) {
            log.debug("enter getDataPopupMenu");
        }
        String[] labels = new String[]{"Heatmap", "Bar Chart", "Scatterplot", "Line Plot"};
        Class[] renderers = new Class[]{HeatmapRenderer.class, BarChartRenderer.class, ScatterplotRenderer.class, LineplotRenderer.class};
        Font newFont = FontManager.getScalableFont(1, 12);
        JLabel rendererHeading = new JLabel("  Type of Graph", 2);
        rendererHeading.setFont(newFont);
        menu.add(rendererHeading);
        HashSet currentRenderers = new HashSet();
        for (Track track : tracks) {
            if (track.getRenderer() == null) continue;
            currentRenderers.add(track.getRenderer().getClass());
        }
        for (int i2 = 0; i2 < labels.length; ++i2) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(labels[i2]);
            final Class rendererClass = renderers[i2];
            if (currentRenderers.contains(rendererClass)) {
                item.setSelected(true);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TrackMenuUtils.changeRenderer(tracks, rendererClass);
                    TrackMenuUtils.clearTrackSelections();
                }
            });
            menu.add(item);
        }
        menu.addSeparator();
        HashSet<WindowFunction> avaibleWindowFunctions = new HashSet<WindowFunction>();
        for (Track track : tracks) {
            avaibleWindowFunctions.addAll(track.getAvailableWindowFunctions());
        }
        WindowFunction[] orderedWindowFunctions = new WindowFunction[]{WindowFunction.min, WindowFunction.percentile2, WindowFunction.percentile10, WindowFunction.median, WindowFunction.mean, WindowFunction.percentile90, WindowFunction.percentile98, WindowFunction.max};
        HashSet<WindowFunction> currentWindowFunctions = new HashSet<WindowFunction>();
        for (Track track : tracks) {
            if (track.getWindowFunction() == null) continue;
            currentWindowFunctions.add(track.getWindowFunction());
        }
        if (!avaibleWindowFunctions.isEmpty() || !currentWindowFunctions.isEmpty()) {
            JLabel statisticsHeading = new JLabel("  Windowing Function", 2);
            statisticsHeading.setFont(newFont);
            menu.add(statisticsHeading);
            for (final WindowFunction wf : orderedWindowFunctions) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(wf.getDisplayName());
                if (!avaibleWindowFunctions.contains((Object)wf) && !currentWindowFunctions.contains((Object)wf)) continue;
                if (currentWindowFunctions.contains((Object)wf)) {
                    item.setSelected(true);
                }
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        TrackMenuUtils.changeStatType(wf.toString(), tracks);
                        TrackMenuUtils.clearTrackSelections();
                    }
                });
                menu.add(item);
            }
            menu.addSeparator();
        }
        JLabel scaleHeading = new JLabel("  Data Range", 2);
        scaleHeading.setFont(newFont);
        menu.add(scaleHeading);
        menu.add(TrackMenuUtils.getDataRangeItem(tracks));
        if (tracks.size() > 0) {
            menu.add(TrackMenuUtils.getLogScaleItem(tracks));
        }
        menu.add(TrackMenuUtils.getAutoscaleItem(tracks));
        menu.add(TrackMenuUtils.getHeatmapScaleItem(tracks));
        menu.add(TrackMenuUtils.getShowDataRangeItem(tracks));
        JLabel trackSettingsHeading = new JLabel("  Track Settings", 2);
        trackSettingsHeading.setFont(newFont);
        menu.add(trackSettingsHeading);
        menu.add(TrackMenuUtils.getTrackRenameItem(tracks));
        TrackMenuUtils.addTrackSettingsMenuItems(menu, false, tracks);
    }

    private static void addFeatureItems(JPopupMenu featurePopupMenu, Collection<Track> tracks, MouseEvent e2, boolean hasFeatureTracks) {
        Font newFont = featurePopupMenu.getFont().deriveFont(1, 12.0f);
        JLabel trackSettingsHeading = new JLabel("  Track Settings", 2);
        trackSettingsHeading.setFont(newFont);
        featurePopupMenu.add(trackSettingsHeading);
        featurePopupMenu.add(TrackMenuUtils.getTrackRenameItem(tracks));
        featurePopupMenu.add(TrackMenuUtils.getExpandCollapseItem(tracks));
        if (hasFeatureTracks) {
            Track t;
            Feature f2;
            featurePopupMenu.add(TrackMenuUtils.getChangeFontSizeItem(tracks));
            if (tracks.size() == 1 && (f2 = (t = tracks.iterator().next()).getFeatureAtMousePosition(e2)) != null) {
                featurePopupMenu.addSeparator();
                featurePopupMenu.add(TrackMenuUtils.getCopyDetailsItem(f2, e2.getX()));
                double position = ViewContext.getInstance().getChromosomePosition(e2.getX());
                List<Exon> exons = f2.getExons();
                if (exons != null) {
                    for (Exon exon : exons) {
                        if (!(position > (double)exon.getStart()) || !(position < (double)exon.getEnd())) continue;
                        f2 = exon;
                        break;
                    }
                }
                featurePopupMenu.add(TrackMenuUtils.getCopySequenceItem(f2));
                f2.getExons();
            }
            featurePopupMenu.addSeparator();
            featurePopupMenu.add(TrackMenuUtils.getChangeFeatureWindow(tracks));
            featurePopupMenu.addSeparator();
        }
        TrackMenuUtils.addTrackSettingsMenuItems(featurePopupMenu, true, tracks);
    }

    private static void addSharedItems(JPopupMenu menu, Collection<Track> tracks) {
        JLabel trackSettingsHeading = new JLabel("  Track Settings", 2);
        menu.add(trackSettingsHeading);
        TrackMenuUtils.addTrackSettingsMenuItems(menu, false, tracks);
    }

    private static void addTrackSettingsMenuItems(JPopupMenu menu, boolean featureTracksOnly, final Collection<Track> tracks) {
        String colorLabel = featureTracksOnly ? "Change Track Color" : "Change Track Color (Positive Values)";
        JMenuItem item = new JMenuItem(colorLabel);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TrackMenuUtils.changeTrackColor(tracks);
                TrackMenuUtils.clearTrackSelections();
            }
        });
        menu.add(item);
        if (!featureTracksOnly) {
            item = new JMenuItem("Change Track Color (Negative Values)");
            item.setToolTipText("Change the alternate track color.  This color is used when graphing negative values");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            TrackMenuUtils.changeAltTrackColor(tracks);
                            TrackMenuUtils.clearTrackSelections();
                        }
                    });
                }
            });
            menu.add(item);
        }
        menu.add(TrackMenuUtils.getChangeTrackHeightItem(tracks));
        menu.add(TrackMenuUtils.getRemoveMenuItem(tracks));
    }

    private static void changeStatType(String statType, Collection<Track> selectedTracks) {
        for (Track track : selectedTracks) {
            track.setStatType(WindowFunction.valueOf(statType));
        }
        TrackMenuUtils.clearTrackSelections();
        TrackMenuUtils.refresh();
    }

    public static JMenuItem getTrackRenameItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Rename Track");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        TrackMenuUtils.renameTrack(selectedTracks);
                        TrackMenuUtils.clearTrackSelections();
                    }
                });
            }
        });
        if (selectedTracks.size() > 1) {
            item.setEnabled(false);
        }
        return item;
    }

    private static JMenuItem getHeatmapScaleItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Heatmap Scale...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (selectedTracks.size() > 0) {
                    ContinuousColorScale colorScale = ((Track)selectedTracks.iterator().next()).getColorScale();
                    HeatmapScaleDialog dlg = new HeatmapScaleDialog((Frame)IGVMainFrame.getInstance(), colorScale);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        colorScale = dlg.getColorScale();
                        for (Track track : selectedTracks) {
                            track.setColorScale(colorScale);
                        }
                        IGVMainFrame.getInstance().repaint();
                    }
                }
                TrackMenuUtils.clearTrackSelections();
            }
        });
        return item;
    }

    public static JMenuItem getDataRangeItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Data Range...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (selectedTracks.size() > 0) {
                    float mid = 0.0f;
                    float min = Float.MAX_VALUE;
                    float max = Float.MIN_VALUE;
                    boolean drawBaseline = false;
                    for (Track t : selectedTracks) {
                        DataRange dr = t.getDataRange();
                        min = Math.min(min, dr.getMinimum());
                        max = Math.max(max, dr.getMaximum());
                        mid += dr.getBaseline();
                    }
                    if ((mid /= (float)selectedTracks.size()) < min) {
                        mid = min;
                    } else if (mid > max) {
                        min = max;
                    }
                    DataRange prevAxisDefinition = new DataRange(min, mid, max, drawBaseline);
                    DataRangeDialog dlg = new DataRangeDialog((Frame)IGVMainFrame.getInstance(), prevAxisDefinition);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        min = Math.min(dlg.getMax(), dlg.getMin());
                        max = Math.max(dlg.getMin(), dlg.getMax());
                        mid = dlg.getBase();
                        mid = Math.max(min, Math.min(mid, max));
                        DataRange axisDefinition = new DataRange(dlg.getMin(), dlg.getBase(), dlg.getMax());
                        for (Track track : selectedTracks) {
                            track.setDataRange(axisDefinition);
                            if (!(track instanceof DataTrack)) continue;
                            ((DataTrack)track).setAutoscale(false);
                        }
                        IGVMainFrame.getInstance().repaint();
                    }
                }
                TrackMenuUtils.clearTrackSelections();
            }
        });
        return item;
    }

    private static JMenuItem getLogScaleItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem logScaleItem = new JCheckBoxMenuItem("Log scale");
        boolean logScale = selectedTracks.iterator().next().getDataRange().isLog();
        logScaleItem.setSelected(logScale);
        logScaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DataRange.Type scaleType = logScaleItem.isSelected() ? DataRange.Type.LOG : DataRange.Type.LINEAR;
                for (Track t : selectedTracks) {
                    t.getDataRange().setType(scaleType);
                }
                TrackMenuUtils.clearTrackSelections();
                IGVMainFrame.getInstance().repaintDataPanels();
            }
        });
        return logScaleItem;
    }

    private static JMenuItem getAutoscaleItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        if (selectedTracks.size() == 0) {
            autoscaleItem.setEnabled(false);
        } else {
            boolean autoScale = false;
            for (Track t : selectedTracks) {
                if (!(t instanceof DataTrack) || !((DataTrack)t).isAutoscale()) continue;
                autoScale = true;
                break;
            }
            autoscaleItem.setSelected(autoScale);
            autoscaleItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    boolean autoScale = autoscaleItem.isSelected();
                    for (Track t : selectedTracks) {
                        if (!(t instanceof DataTrack)) continue;
                        ((DataTrack)t).setAutoscale(autoScale);
                    }
                    TrackMenuUtils.clearTrackSelections();
                    IGVMainFrame.getInstance().repaintDataPanels();
                }
            });
        }
        return autoscaleItem;
    }

    private static JMenuItem getShowDataRangeItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Data Range");
        if (selectedTracks.size() == 0) {
            item.setEnabled(false);
        } else {
            boolean showDataRange = true;
            for (Track t : selectedTracks) {
                if (t.isShowDataRange()) continue;
                showDataRange = false;
                break;
            }
            item.setSelected(showDataRange);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    boolean showDataRange = item.isSelected();
                    for (Track t : selectedTracks) {
                        if (!(t instanceof DataTrack)) continue;
                        ((DataTrack)t).setShowDataRange(showDataRange);
                    }
                    TrackMenuUtils.clearTrackSelections();
                    IGVMainFrame.getInstance().repaintDataPanels();
                }
            });
        }
        return item;
    }

    public static JMenuItem getExpandCollapseItem(final Collection<Track> tracks) {
        String text;
        boolean expanded = false;
        for (Track track : tracks) {
            if (!track.isExpanded()) continue;
            expanded = true;
            break;
        }
        String string = text = expanded ? "Collapse Track" : "Expand Track";
        if (tracks.size() > 1) {
            text = text + "s";
        }
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TrackMenuUtils.doToggleSelectedMultiTrackFeatures(tracks);
                TrackMenuUtils.clearTrackSelections();
            }
        });
        return item;
    }

    public static JMenuItem getRemoveMenuItem(final Collection<Track> selectedTracks) {
        boolean multiple = selectedTracks.size() > 1;
        JMenuItem item = new JMenuItem("Remove Track" + (multiple ? "s" : ""));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (selectedTracks.isEmpty()) {
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (Track track : selectedTracks) {
                    buffer.append("\n\t");
                    buffer.append(track.getName());
                }
                String deleteItems = buffer.toString();
                JTextArea textArea = new JTextArea();
                textArea.setEditable(false);
                JScrollPane scrollPane = new JScrollPane(textArea);
                textArea.setText(deleteItems);
                JOptionPane optionPane = new JOptionPane(scrollPane, -1, 0);
                optionPane.setPreferredSize(new Dimension(550, 500));
                JDialog dialog = optionPane.createDialog(IGVMainFrame.getInstance(), "Remove The Following Tracks");
                dialog.setVisible(true);
                Object choice = optionPane.getValue();
                if (choice != null && 0 == (Integer)choice) {
                    IGVMainFrame.getInstance().getTrackManager().removeTracks(selectedTracks);
                    IGVMainFrame.getInstance().doResizeTrackPanels();
                    IGVMainFrame.getInstance().doRefresh();
                }
                TrackMenuUtils.clearTrackSelections();
            }
        });
        return item;
    }

    public static void doToggleSelectedMultiTrackFeatures(Collection<Track> selectedTracks) {
        Iterator<Track> i$ = selectedTracks.iterator();
        while (i$.hasNext()) {
            Track track;
            boolean isMultiLevel = (track = i$.next()).isExpanded();
            track.setExpanded(!isMultiLevel);
        }
        IGVMainFrame.getInstance().doResizeTrackPanels();
    }

    public static void changeRenderer(Collection<Track> selectedTracks, Class rendererClass) {
        for (Track track : selectedTracks) {
            if (track.getTrackType() == TrackType.RNAI && rendererClass == BarChartRenderer.class) {
                rendererClass = RNAiBarChartRenderer.class;
            }
            track.setRendererClass(rendererClass);
        }
        TrackMenuUtils.clearTrackSelections();
        TrackMenuUtils.refresh();
    }

    public static void renameTrack(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Track t = selectedTracks.iterator().next();
        String newName = JOptionPane.showInputDialog(IGVMainFrame.getInstance(), "Enter new name: ", t.getName());
        if (newName == null || newName.trim() == "") {
            return;
        }
        t.setName(newName);
        TrackMenuUtils.refresh();
    }

    public static void changeTrackHeight(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        String parameter = "Track height";
        int value = TrackMenuUtils.getIntValue("Track height", TrackMenuUtils.getRepresentativeTrackHeight(selectedTracks));
        if (value == Integer.MIN_VALUE) {
            return;
        }
        value = Math.max(0, value);
        for (Track track : selectedTracks) {
            track.setHeight(value);
        }
        TrackMenuUtils.refresh();
    }

    public static void changeFeatureVisibilityWindow(Collection<Track> selectedTracks) {
        ArrayList<FeatureTrack> featureTracks = new ArrayList<FeatureTrack>(selectedTracks.size());
        for (Track t : selectedTracks) {
            if (!(t instanceof FeatureTrack)) continue;
            featureTracks.add((FeatureTrack)t);
        }
        if (featureTracks.isEmpty()) {
            return;
        }
        int origValue = ((FeatureTrack)featureTracks.iterator().next()).getVisibilityWindow();
        int origValueKB = Math.max(1, origValue / 1000);
        int value = TrackMenuUtils.getIntValue("Visibility window (kb)", origValueKB);
        if (value == Integer.MIN_VALUE) {
            return;
        }
        for (FeatureTrack track : featureTracks) {
            track.setVisibilityWindow(value * 1000);
        }
        TrackMenuUtils.refresh();
    }

    public static void changeFontSize(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        String parameter = "Font size";
        int defaultValue = selectedTracks.iterator().next().getFontSize();
        int value = TrackMenuUtils.getIntValue("Font size", defaultValue);
        if (value == Integer.MIN_VALUE) {
            return;
        }
        for (Track track : selectedTracks) {
            track.setFontSize(value);
        }
        TrackMenuUtils.refresh();
    }

    private static int getIntValue(String parameter, int value) {
        String height;
        while ((height = JOptionPane.showInputDialog(IGVMainFrame.getInstance(), parameter + ": ", String.valueOf(value))) != null && !height.trim().equals("")) {
            try {
                value = Integer.parseInt(height);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGVMainFrame.getInstance(), parameter + " must be an integer number.");
                continue;
            }
            break;
        }
        return Integer.MIN_VALUE;
    }

    public static void changeTrackColor(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Color currentSelection = selectedTracks.iterator().next().getColor();
        Color color = UIUtilities.showColorChooserDialog("Select Track Color (Positive Values)", currentSelection);
        if (color != null) {
            for (Track track : selectedTracks) {
                track.setColor(color);
            }
            TrackMenuUtils.clearTrackSelections();
            TrackMenuUtils.refresh();
        }
    }

    public static void changeAltTrackColor(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Color currentSelection = selectedTracks.iterator().next().getColor();
        Color color = UIUtilities.showColorChooserDialog("Select Track Color (Negative Values)", currentSelection);
        if (color == null) {
            return;
        }
        for (Track track : selectedTracks) {
            track.setAltColor(color);
        }
        TrackMenuUtils.clearTrackSelections();
        TrackMenuUtils.refresh();
    }

    public static JMenuItem getCopyDetailsItem(final Feature f2, final int mouseX) {
        JMenuItem item = new JMenuItem("Copy Details to Clipboard");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                double location = ViewContext.getInstance().getChromosomePosition(mouseX);
                String details = f2.getValueString(location, null);
                if (details != null) {
                    details = details.replace("<br>", System.getProperty("line.separator"));
                    details = details + System.getProperty("line.separator") + f2.getChr() + ":" + (f2.getStart() + 1) + "-" + f2.getEnd();
                    StringSelection stringSelection = new StringSelection(details);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        return item;
    }

    public static JMenuItem getCopySequenceItem(final Feature f2) {
        JMenuItem item = new JMenuItem("Copy Sequence to Clipboard");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int end;
                int start;
                String chr;
                String genomeId = ViewContext.getInstance().getGenomeId();
                byte[] seqBytes = SequenceManager.readSequence(genomeId, chr = f2.getChr(), start = f2.getStart(), end = f2.getEnd());
                if (seqBytes == null) {
                    MessageUtils.showMessage("Sequence not available");
                } else {
                    String sequence = new String(seqBytes);
                    StringSelection stringSelection = new StringSelection(sequence);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        return item;
    }

    public static int getRepresentativeTrackHeight(Collection<Track> tracks) {
        double[] heights = new double[tracks.size()];
        int i2 = 0;
        for (Track track : tracks) {
            heights[i2] = track.getHeight();
            ++i2;
        }
        int medianTrackHeight = (int)Math.round(StatUtils.percentile(heights, 50.0));
        if (medianTrackHeight > 0) {
            return medianTrackHeight;
        }
        return PreferenceManager.getInstance().getDefaultTrackHeight();
    }

    public static void refresh() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                IGVMainFrame.getInstance().showLoadedTrackCount();
                IGVMainFrame.getInstance().getContentPane().repaint();
            }
        });
    }

    public static JMenuItem getChangeTrackHeightItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Change Track Height...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TrackMenuUtils.changeTrackHeight(selectedTracks);
                TrackMenuUtils.clearTrackSelections();
            }
        });
        return item;
    }

    public static JMenuItem getChangeFeatureWindow(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Feature Visibility Window...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TrackMenuUtils.changeFeatureVisibilityWindow(selectedTracks);
                TrackMenuUtils.clearTrackSelections();
            }
        });
        return item;
    }

    public static JMenuItem getChangeFontSizeItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Change Font Size");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TrackMenuUtils.changeFontSize(selectedTracks);
                TrackMenuUtils.clearTrackSelections();
            }
        });
        return item;
    }

    public static void clearTrackSelections() {
        IGVMainFrame.getInstance().getTrackManager().clearSelections();
    }
}

