/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track.tribble;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.RuntimeUtils;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.util.CloseableTribbleIterator;

public class CachingFeatureReader
implements FeatureReader {
    private static Logger log = Logger.getLogger(CachingFeatureReader.class);
    String cachedChr = "";
    static int maxTileCount = 5;
    private static int defaultTileSize = 1000000;
    private int tileSize = defaultTileSize;
    FeatureReader reader;
    LRUCache<Integer, Tile> cache;

    public CachingFeatureReader(FeatureReader reader) {
        this(reader, defaultTileSize);
    }

    public CachingFeatureReader(FeatureReader reader, int tileSize) {
        this.reader = reader;
        this.cache = new LRUCache(this, maxTileCount);
        this.tileSize = tileSize;
    }

    public void setTileSize(int tileSize) {
        this.cache.clear();
        this.tileSize = tileSize;
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public CloseableTribbleIterator iterator() throws IOException {
        return this.reader.iterator();
    }

    @Override
    public void close() throws IOException {
        this.cache.clear();
        this.reader.close();
    }

    public CloseableTribbleIterator query(String chr, int start, int end) throws IOException {
        return this.query(chr, start, end, false);
    }

    public CloseableTribbleIterator query(String chr, int start, int end, boolean contained) throws IOException {
        List<Tile> tiles;
        int startTile = 0;
        int endTile = 0;
        if (this.tileSize > 0) {
            startTile = start / this.tileSize;
            endTile = end / this.tileSize;
        }
        if ((tiles = this.getTiles(chr, startTile, endTile)).size() == 0) {
            return null;
        }
        int recordCount = tiles.get(0).getOverlappingRecords().size();
        for (Tile t : tiles) {
            recordCount += t.getContainedRecords().size();
        }
        ArrayList<Feature> alignments = new ArrayList<Feature>(recordCount);
        alignments.addAll(tiles.get(0).getOverlappingRecords());
        for (Tile t : tiles) {
            alignments.addAll(t.getContainedRecords());
        }
        return new TiledIterator(start, end, alignments);
    }

    private List<Tile> getTiles(String seq, int startTile, int endTile) {
        if (!seq.equals(this.cachedChr)) {
            this.cache.clear();
            this.cachedChr = seq;
        }
        ArrayList<Tile> tiles = new ArrayList<Tile>(endTile - startTile + 1);
        ArrayList<Tile> tilesToLoad = new ArrayList<Tile>(endTile - startTile + 1);
        for (int t = startTile; t <= endTile; ++t) {
            Tile tile = this.cache.get(t);
            if (tile == null) {
                int start = t * this.tileSize;
                int end = start + this.tileSize;
                tile = new Tile(t, start, end);
                this.cache.put(t, tile);
            }
            tiles.add(tile);
            if (tile.isLoaded()) {
                if (tilesToLoad.size() > 0 && !this.loadTiles(seq, tilesToLoad)) {
                    return tiles;
                }
                tilesToLoad.clear();
                continue;
            }
            tilesToLoad.add(tile);
        }
        if (tilesToLoad.size() > 0) {
            this.loadTiles(seq, tilesToLoad);
        }
        return tiles;
    }

    private boolean loadTiles(String seq, List<Tile> tiles) {
        int end;
        assert (tiles.size() > 0);
        if (log.isDebugEnabled()) {
            int first = tiles.get(0).getTileNumber();
            end = tiles.get(tiles.size() - 1).getTileNumber();
            log.debug("Loading tiles: " + first + "-" + end);
        }
        int start = tiles.get(0).start;
        end = tiles.get(tiles.size() - 1).end;
        CloseableTribbleIterator iter = null;
        try {
            iter = this.reader.query(seq, start, end);
            while (iter != null && iter.hasNext()) {
                Feature record = (Feature)iter.next();
                int aStart = record.getStart();
                int aEnd = record.getEnd();
                int idx0 = 0;
                int idx1 = 0;
                if (this.tileSize > 0) {
                    idx0 = Math.max(0, (aStart - start) / this.tileSize);
                    idx1 = Math.min(tiles.size() - 1, (aEnd - start) / this.tileSize);
                }
                for (int i2 = idx0; i2 <= idx1; ++i2) {
                    Tile t = tiles.get(i2);
                    if (t.end <= 0) {
                        t.containedRecords.add(record);
                        continue;
                    }
                    if (aStart >= t.start && aStart < t.end) {
                        t.containedRecords.add(record);
                        continue;
                    }
                    if (aEnd < t.start || aStart >= t.start) continue;
                    t.overlappingRecords.add(record);
                }
            }
            for (Tile t : tiles) {
                t.setLoaded(true);
            }
            boolean i$ = true;
            return i$;
        }
        catch (Exception e2) {
            log.error("Error loading alignment data", e2);
            throw new DataLoadException("", "Error: " + e2.toString());
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    private boolean checkMemory() {
        if (RuntimeUtils.getAvailableMemory() < 50000000L) {
            LRUCache.clearCaches();
            if (RuntimeUtils.getAvailableMemory() < 50000000L) {
                String msg = "Memory is low, reading terminating.";
                MessageUtils.showMessage(msg);
                return false;
            }
        }
        return true;
    }

    public class TiledIterator
    implements CloseableTribbleIterator {
        Iterator<Feature> currentSamIterator;
        int end;
        Feature nextRecord;
        int start;
        List<Feature> alignments;

        TiledIterator(int start, int end, List<Feature> alignments) {
            this.alignments = alignments;
            this.start = start;
            this.end = end;
            this.currentSamIterator = alignments.iterator();
            this.advanceToFirstRecord();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Feature next() {
            Feature ret = this.nextRecord;
            this.advanceToNextRecord();
            return ret;
        }

        @Override
        public void remove() {
        }

        private void advanceToFirstRecord() {
            this.advanceToNextRecord();
        }

        private void advanceToNextRecord() {
            this.advance();
            while (this.nextRecord != null && this.nextRecord.getEnd() < this.start) {
                this.advance();
            }
        }

        private void advance() {
            if (this.currentSamIterator.hasNext()) {
                this.nextRecord = this.currentSamIterator.next();
                if (this.nextRecord.getStart() > this.end) {
                    this.nextRecord = null;
                }
            } else {
                this.nextRecord = null;
            }
        }

        @Override
        public Iterator iterator() {
            return this;
        }
    }

    static class Tile {
        private boolean loaded = false;
        private int start;
        private int end;
        private int tileNumber;
        private List<Feature> containedRecords;
        private List<Feature> overlappingRecords;

        Tile(int tileNumber, int start, int end) {
            this.tileNumber = tileNumber;
            this.start = start;
            this.end = end;
            this.containedRecords = new ArrayList<Feature>(1000);
            this.overlappingRecords = new ArrayList<Feature>(100);
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public List<Feature> getContainedRecords() {
            return this.containedRecords;
        }

        public List<Feature> getOverlappingRecords() {
            return this.overlappingRecords;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }
    }
}

