/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JPanel;
import org.broad.igv.ui.GenomeBuilderPane;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.util.OkCancelDialog;

public class GenomeBuilderDialog
extends OkCancelDialog {
    private GenomeBuilderPane builderPane = new GenomeBuilderPane();
    private File genomeArchiveFile = null;

    public GenomeBuilderDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Import Genome");
        JPanel contentPane = this.getDialogPanel();
        contentPane.add(this.builderPane);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        this.setOkButtonText(" Save ");
    }

    public String getCytobandFileName() {
        return this.builderPane.getCytobandFileName();
    }

    public String getFastaFileName() {
        return this.builderPane.getFastaFileName();
    }

    public String getGenomeId() {
        return this.builderPane.getGenomeId();
    }

    public String getGenomeDisplayName() {
        return this.builderPane.getGenomeDisplayName();
    }

    public String getRefFlatFileName() {
        return this.builderPane.getRefFlatFileName();
    }

    public String getGenomeArchiveLocation() {
        return this.builderPane.getGenomeArchiveLocation();
    }

    public String getArchiveFileName() {
        return this.builderPane.getArchiveFileName();
    }

    public String getSequenceLocation() {
        String name = this.getFastaFileName();
        if (name != null && !name.trim().equals("")) {
            if (this.genomeArchiveFile != null) {
                return "/" + this.genomeArchiveFile.getName() + "_seq/";
            }
            return "/" + this.getGenomeId() + "_seq/";
        }
        return null;
    }

    @Override
    public boolean cancelButtonClicked(ActionEvent event) {
        return true;
    }

    @Override
    public boolean okButtonClicked(ActionEvent event) {
        boolean isOk = this.builderPane.validateSelection();
        if (isOk) {
            this.genomeArchiveFile = UIConstants.IS_MAC ? this.builderPane.showGenomeArchiveDirectoryChooser() : this.builderPane.showGenomeArchiveDirectoryChooser();
            if (this.genomeArchiveFile == null) {
                isOk = false;
            }
        }
        return isOk;
    }
}

