/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.GeneManager;
import org.broad.igv.feature.GenomeImporter;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.MacCompatibleFileChooser;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.util.FileChooser;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.AsciiLineReader;
import org.jdesktop.layout.GroupLayout;

public class GenomeBuilderPane
extends JPanel {
    private static Logger logger = Logger.getLogger(GenomeBuilderPane.class);
    private String genomeArchiveLocation;
    private String genomeFilename;
    GenomeImporter importer;
    private JButton cytobandFileButton;
    private JLabel cytobandFileLabel;
    private JTextField cytobandFileTextField;
    private JButton fastaFileButton;
    private JLabel fastaFileLabel;
    private JTextField fastaFileTextField;
    private JLabel genomeDisplayNameLabel;
    private JTextField genomeDisplayNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JButton refFlatFileButton;
    private JLabel refFlatFileLabel;
    private JTextField refFlatFileTextField;

    public GenomeBuilderPane() {
        this.initComponents();
        this.importer = new GenomeImporter();
    }

    public String getCytobandFileName() {
        String cytobandFile = this.cytobandFileTextField.getText();
        if (cytobandFile != null && cytobandFile.trim().equals("")) {
            cytobandFile = null;
        }
        return cytobandFile;
    }

    public String getRefFlatFileName() {
        String refFlatFile = this.refFlatFileTextField.getText();
        if (refFlatFile != null && refFlatFile.trim().equals("")) {
            refFlatFile = null;
        }
        return refFlatFile;
    }

    public String getFastaFileName() {
        String fastaFile = this.fastaFileTextField.getText();
        if (fastaFile != null && fastaFile.trim().equals("")) {
            fastaFile = null;
        }
        return fastaFile;
    }

    public String getGenomeId() {
        String genomeName = this.getGenomeDisplayName();
        GenomeManager.getInstance();
        String name = GenomeManager.generateGenomeKeyFromText(genomeName);
        return name;
    }

    public String getGenomeDisplayName() {
        String name = this.genomeDisplayNameTextField.getText();
        name = name != null && name.trim().equals("") ? null : name.trim();
        return name;
    }

    public String getGenomeArchiveLocation() {
        if (this.genomeArchiveLocation != null && this.genomeArchiveLocation.trim().equals("")) {
            this.genomeArchiveLocation = null;
        }
        return this.genomeArchiveLocation;
    }

    public String getArchiveFileName() {
        if (this.genomeFilename == null) {
            this.genomeFilename = this.getGenomeId() + ".genome";
        }
        return this.genomeFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCytobandFileChooser() {
        FileFilter[] fileFilters = null;
        final FileChooser cytobandFileChooser = UIUtilities.getFileChooser(null, null, fileFilters, 2);
        cytobandFileChooser.setFileSelectionMode(0);
        cytobandFileChooser.setDialogTitle("Choose Cytoband File");
        File directory = PreferenceManager.getInstance().getDefineGenomeInputDirectory();
        cytobandFileChooser.setCurrentDirectory(directory);
        cytobandFileChooser.setSelectedFile(null);
        cytobandFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                File oldFile = null;
                String property = e2.getPropertyName();
                if ("SelectedFileChangedProperty".equals(property)) {
                    oldFile = (File)e2.getOldValue();
                    cytobandFileChooser.setPreviousFile(oldFile);
                }
            }
        });
        cytobandFileChooser.showOpenDialog(this);
        File file = cytobandFileChooser.getSelectedFile();
        if (file == null) {
            this.cytobandFileTextField.setText(null);
        } else {
            PreferenceManager.getInstance().setDefineGenomeInputDirectory(file.getParentFile());
            String errorText = file.getAbsolutePath() + " is not a valid Cytoband file - " + "Please choose another file!";
            AsciiLineReader reader = null;
            try {
                reader = new AsciiLineReader(new FileInputStream(file));
                boolean isValid = CytoBandFileParser.isValid(reader, file.getName());
                if (isValid) {
                    this.cytobandFileTextField.setText(file.getAbsolutePath());
                } else {
                    this.cytobandFileTextField.setText(null);
                    JOptionPane.showMessageDialog(this, errorText);
                }
            }
            catch (FileNotFoundException e2) {
                this.cytobandFileTextField.setText(null);
                JOptionPane.showMessageDialog(this, errorText);
                logger.error(errorText, e2);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showGeneFileChooser() {
        FileFilter[] fileFilters = null;
        final FileChooser refFlatFileChooser = UIUtilities.getFileChooser(null, null, fileFilters, 2);
        refFlatFileChooser.setFileSelectionMode(0);
        refFlatFileChooser.setDialogTitle("Choose Gene File");
        File directory = PreferenceManager.getInstance().getDefineGenomeInputDirectory();
        refFlatFileChooser.setCurrentDirectory(directory);
        refFlatFileChooser.setSelectedFile(null);
        refFlatFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                File oldFile = null;
                String property = e2.getPropertyName();
                if ("SelectedFileChangedProperty".equals(property)) {
                    oldFile = (File)e2.getOldValue();
                    refFlatFileChooser.setPreviousFile(oldFile);
                }
            }
        });
        refFlatFileChooser.showOpenDialog(this);
        File file = refFlatFileChooser.getSelectedFile();
        if (file == null) {
            this.refFlatFileTextField.setText(null);
        } else {
            PreferenceManager.getInstance().setDefineGenomeInputDirectory(file.getParentFile());
            String errorText = file.getAbsolutePath() + " is not a valid Gene file - " + "Please choose another file!";
            AsciiLineReader reader = null;
            try {
                reader = new AsciiLineReader(new FileInputStream(file));
                boolean isValid = GeneManager.isValid(reader, file.getName());
                if (isValid) {
                    this.refFlatFileTextField.setText(file.getAbsolutePath());
                } else {
                    this.refFlatFileTextField.setText(null);
                    JOptionPane.showMessageDialog(this, errorText);
                }
            }
            catch (FileNotFoundException e2) {
                this.refFlatFileTextField.setText(null);
                JOptionPane.showMessageDialog(this, errorText);
                logger.error(errorText, e2);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e3) {
                        logger.error("Error closing Gene stream", e3);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showFastaFileChooser() {
        WaitCursorManager.CursorToken token = null;
        try {
            FileFilter[] fileFilters = null;
            final FileChooser fastaFileChooser = UIUtilities.getFileChooser(null, null, fileFilters, 2);
            fastaFileChooser.setFileSelectionMode(2);
            fastaFileChooser.setDialogTitle("Choose Sequence File or Directory");
            File directory = PreferenceManager.getInstance().getDefineGenomeInputDirectory();
            fastaFileChooser.setCurrentDirectory(directory);
            fastaFileChooser.setSelectedFile(null);
            fastaFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e2) {
                    File oldFile = null;
                    String property = e2.getPropertyName();
                    if ("SelectedFileChangedProperty".equals(property)) {
                        oldFile = (File)e2.getOldValue();
                        fastaFileChooser.setPreviousFile(oldFile);
                    }
                }
            });
            fastaFileChooser.showOpenDialog(this);
            token = WaitCursorManager.showWaitCursor();
            File file = fastaFileChooser.getSelectedFile();
            if (file == null) {
                this.fastaFileTextField.setText(null);
            } else {
                PreferenceManager.getInstance().setDefineGenomeInputDirectory(file.getParentFile());
                this.fastaFileTextField.setText(file.getAbsolutePath());
            }
            if (token == null) return;
        }
        catch (Throwable throwable) {
            if (token == null) throw throwable;
            WaitCursorManager.removeWaitCursor(token);
            throw throwable;
        }
        WaitCursorManager.removeWaitCursor(token);
    }

    protected File showGenomeArchiveDirectoryChooser() {
        File directory = PreferenceManager.getInstance().getLastGenomeImportDirectory();
        directory = PreferenceManager.getInstance().getLastGenomeImportDirectory();
        File newArchiveFile = new File(directory, this.getArchiveFileName());
        String[] extensions = new String[]{".genome"};
        File file = null;
        boolean isOk = false;
        if (!isOk) {
            file = MacCompatibleFileChooser.showSaveDialog(IGVMainFrame.getInstance(), directory, newArchiveFile, extensions, "Genome Archive");
            if (file == null) {
                isOk = false;
            } else {
                this.genomeFilename = file.getName();
                if (this.genomeFilename != null) {
                    if (!this.genomeFilename.endsWith(".genome")) {
                        this.genomeFilename = this.genomeFilename + ".genome";
                    }
                    this.genomeArchiveLocation = file.getParentFile().getAbsolutePath();
                    isOk = true;
                }
            }
        }
        return file;
    }

    public boolean validateSelection() {
        try {
            Boolean isNameValid = this.isGenomeDisplayNameValid();
            if (isNameValid != null && !isNameValid.booleanValue()) {
                this.genomeDisplayNameTextField.setText(null);
                return false;
            }
            Boolean isFastaValid = this.isFASTAFileValid();
            if (isFastaValid == null) {
                JOptionPane.showMessageDialog(this, "A Sequence file is required!");
                return false;
            }
        }
        catch (Exception e2) {
            logger.error("Error during Genome Builder validation!", e2);
            return false;
        }
        return true;
    }

    private Boolean isFASTAFileValid() {
        String file = this.fastaFileTextField.getText();
        if (file == null) {
            return null;
        }
        if (file.trim().equals("")) {
            return null;
        }
        return true;
    }

    private Boolean isGenomeDisplayNameValid() {
        String displayName = this.getGenomeDisplayName();
        if (displayName == null) {
            JOptionPane.showMessageDialog(this, "No display name supplied!");
            return false;
        }
        if ((displayName = displayName.trim()).equals("")) {
            JOptionPane.showMessageDialog(this, "No display name supplied!");
            return false;
        }
        Collection<String> inUseDisplayNames = IGVMainFrame.getInstance().getGenomeDisplayNames();
        if (inUseDisplayNames.contains(displayName)) {
            JOptionPane.showMessageDialog(this, "The selected genome name is already in use - please select another!");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.cytobandFileTextField = new JTextField();
        this.cytobandFileButton = new JButton();
        this.refFlatFileLabel = new JLabel();
        this.refFlatFileButton = new JButton();
        this.genomeDisplayNameTextField = new JTextField();
        this.fastaFileLabel = new JLabel();
        this.fastaFileButton = new JButton();
        this.cytobandFileLabel = new JLabel();
        this.fastaFileTextField = new JTextField();
        this.refFlatFileTextField = new JTextField();
        this.genomeDisplayNameLabel = new JLabel();
        this.setToolTipText("Used to completely define all the items associated with a genome");
        this.setFont(new Font("Tahoma", 2, 12));
        this.setMaximumSize(new Dimension(700, 500));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(600, 400));
        this.jLabel1.setFont(new Font("Lucida Sans Unicode", 2, 12));
        this.jLabel1.setText("<html>The sequence file (required) can be a FASTA file, a directory of FASTA files, or a zip of FASTA files. Optionally, specify a cytoband file to display the chromosome ideogram and an annotation file to display the gene track. See the documentation for descriptions of supported annotation formats.</html>");
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel2.setText("* Required");
        this.cytobandFileTextField.setToolTipText("A cytoband data file");
        this.cytobandFileTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeBuilderPane.this.cytobandFileTextFieldActionPerformed(evt);
            }
        });
        this.cytobandFileButton.setLabel("...");
        this.cytobandFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeBuilderPane.this.cytobandFileButtonActionPerformed(evt);
            }
        });
        this.cytobandFileButton.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent evt) {
                GenomeBuilderPane.this.cytobandFileButtonAncestorMoved(evt);
            }

            @Override
            public void ancestorResized(HierarchyEvent evt) {
            }
        });
        this.refFlatFileLabel.setText("Gene File");
        this.refFlatFileButton.setLabel("...");
        this.refFlatFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeBuilderPane.this.refFlatFileButtonActionPerformed(evt);
            }
        });
        this.genomeDisplayNameTextField.setToolTipText("The user-readable name of the genome");
        this.genomeDisplayNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeBuilderPane.this.genomeDisplayNameTextFieldActionPerformed(evt);
            }
        });
        this.fastaFileLabel.setText("Sequence File *");
        this.fastaFileButton.setLabel("...");
        this.fastaFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeBuilderPane.this.fastaFileButtonActionPerformed(evt);
            }
        });
        this.cytobandFileLabel.setText("Cytoband File");
        this.fastaFileTextField.setToolTipText("A FASTA data file");
        this.refFlatFileTextField.setToolTipText("A refFlat gene file");
        this.refFlatFileTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeBuilderPane.this.refFlatFileTextFieldActionPerformed(evt);
            }
        });
        this.genomeDisplayNameLabel.setText("Name");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(1, 1, 1).add(jPanel1Layout.createParallelGroup(2).add(this.fastaFileLabel).add(this.genomeDisplayNameLabel))).add(jPanel1Layout.createParallelGroup(2).add(this.cytobandFileLabel).add(this.refFlatFileLabel))).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.refFlatFileTextField, -1, 295, Short.MAX_VALUE).add(this.cytobandFileTextField, -1, 295, Short.MAX_VALUE).add(this.fastaFileTextField, -1, 295, Short.MAX_VALUE).add(this.genomeDisplayNameTextField, -1, 295, Short.MAX_VALUE)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.cytobandFileButton, -2, 35, -2).add(this.refFlatFileButton, -2, 35, -2).add(this.fastaFileButton, -2, 35, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.genomeDisplayNameLabel).add(this.genomeDisplayNameTextField, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.fastaFileLabel).add(this.fastaFileTextField, -2, -1, -2).add(this.fastaFileButton)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.cytobandFileLabel, -2, 14, -2).add(this.cytobandFileTextField, -2, -1, -2).add(this.cytobandFileButton)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.refFlatFileLabel).add(this.refFlatFileTextField, -2, -1, -2).add(this.refFlatFileButton)).add(29, 29, 29)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(51, 51, 51).add(this.jLabel2, -2, 82, -2)).add(layout.createSequentialGroup().add(25, 25, 25).add(this.jLabel1, -2, 371, -2)).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2))).addContainerGap(51, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(38, 38, 38).add(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add(this.jLabel2).add(18, 18, 18).add(this.jLabel1, -2, 123, -2).addContainerGap()));
    }

    private void cytobandFileTextFieldActionPerformed(ActionEvent evt) {
    }

    private void cytobandFileButtonActionPerformed(ActionEvent evt) {
        this.showCytobandFileChooser();
    }

    private void cytobandFileButtonAncestorMoved(HierarchyEvent evt) {
    }

    private void refFlatFileButtonActionPerformed(ActionEvent evt) {
        this.showGeneFileChooser();
    }

    private void fastaFileButtonActionPerformed(ActionEvent evt) {
        this.showFastaFileChooser();
    }

    private void refFlatFileTextFieldActionPerformed(ActionEvent evt) {
    }

    private void genomeDisplayNameTextFieldActionPerformed(ActionEvent evt) {
    }
}

