/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.status.StatusBar;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.SwingWorker;
import jargs.gnu.CmdLineParser;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.RepaintManager;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicBorders;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.IGVDatasetParser;
import org.broad.igv.event.StatusChangeEvent;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeDescriptor;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.feature.MaximumContigGenomeException;
import org.broad.igv.listener.StatusListener;
import org.broad.igv.main.BatchRunner;
import org.broad.igv.main.CommandListener;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionReader;
import org.broad.igv.session.ViewContext;
import org.broad.igv.tools.IgvToolsGui;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.AboutDialog;
import org.broad.igv.ui.DefaultExceptionHandler;
import org.broad.igv.ui.GenomeBuilderDialog;
import org.broad.igv.ui.IGVCommandBar;
import org.broad.igv.ui.MiscStuff;
import org.broad.igv.ui.PreferencesEditor;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.RegionOfInterestTool;
import org.broad.igv.ui.ShutdownThread;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.action.ClearRegionsMenuAction;
import org.broad.igv.ui.action.ExportRegionsMenuAction;
import org.broad.igv.ui.action.FilterTracksMenuAction;
import org.broad.igv.ui.action.FitDataToWindowMenuAction;
import org.broad.igv.ui.action.GroupTracksMenuAction;
import org.broad.igv.ui.action.ImportRegionsMenuAction;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.LoadFromScriptMenuAction;
import org.broad.igv.ui.action.LoadFromServerAction;
import org.broad.igv.ui.action.LoadFromURLMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.action.NewSessionMenuAction;
import org.broad.igv.ui.action.OpenSessionMenuAction;
import org.broad.igv.ui.action.RemoveUserDefinedGenomeMenuAction;
import org.broad.igv.ui.action.ResetPreferencesAction;
import org.broad.igv.ui.action.SaveSessionMenuAction;
import org.broad.igv.ui.action.SetTrackHeightMenuAction;
import org.broad.igv.ui.action.SortTracksMenuAction;
import org.broad.igv.ui.dnd.GhostGlassPane;
import org.broad.igv.ui.event.GlobalKeyDispatcher;
import org.broad.igv.ui.legend.LegendDialog;
import org.broad.igv.ui.panel.AttributeHeaderPanel;
import org.broad.igv.ui.panel.CytobandPanel;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.HeaderPanel;
import org.broad.igv.ui.panel.IGVPanel;
import org.broad.igv.ui.panel.NameHeaderPanel;
import org.broad.igv.ui.panel.RegionOfInterestPanel;
import org.broad.igv.ui.panel.RulerPanel;
import org.broad.igv.ui.panel.TrackNamePanel;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.ApplicationStatusBar;
import org.broad.igv.ui.util.CheckListDialog;
import org.broad.igv.ui.util.FileChooser;
import org.broad.igv.ui.util.FileChooserDialog;
import org.broad.igv.ui.util.GenericUtilities;
import org.broad.igv.ui.util.HistoryMenu;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.IndefiniteProgressMonitor;
import org.broad.igv.ui.util.MenuAndToolbarUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class IGVMainFrame
extends JFrame {
    private static Logger log = Logger.getLogger(IGVMainFrame.class);
    private static IGVMainFrame theInstance;
    public static Cursor handCursor;
    public static Cursor fistCursor;
    public static Cursor zoomInCursor;
    public static Cursor zoomOutCursor;
    public static Cursor dragNDropCursor;
    static final String ROI_BUTTON_TEXT = "Define a region of interest";
    Session session;
    private TrackManager trackManager;
    private JMenu extrasMenu;
    private IGVCommandBar igvCommandBar;
    private JPanel applicationHeaderView;
    private JPanel attributeHeaderPanel;
    private JPanel centerPanel;
    private JPanel cytobandPanel;
    private TrackPanelScrollPane dataTrackScrollPane;
    private TrackPanelScrollPane featureTrackScrollPane;
    private JPanel headerPanel;
    private JScrollPane headerScrollPane;
    private JPanel nameHeaderPanel;
    private RegionOfInterestPanel regionOfInterestPane;
    private JPanel rulerPanel;
    private StatusBar statusBar;
    private JideSplitPane centerSplitPane;
    public String currentSessionFilePath;
    private final LinkedList<String> recentSessionList = new LinkedList();
    private FileChooserDialog trackFileChooser;
    private FileChooser snapshotFileChooser;
    private FileChooser genomeImportFileChooser;
    private boolean showRegionsOfInterestBarsOn = true;
    FilterTracksMenuAction filterTracksAction;
    private JCheckBoxMenuItem menuItem;
    private boolean isExportingSnapshot = false;
    private boolean areResourceNodesCheckable = false;
    private boolean igvInitialized = false;
    RemoveUserDefinedGenomeMenuAction removeImportedGenomeAction;
    Component glassPane;
    GhostGlassPane dNdGlassPane;

    public static IGVMainFrame getInstance() {
        if (theInstance == null) {
            if (Globals.isHeadless()) {
                System.err.println("Attempt to create IGVMainFrame in headless mode.");
            } else {
                theInstance = new IGVMainFrame();
            }
        }
        return theInstance;
    }

    public static boolean hasInstance() {
        return theInstance != null;
    }

    private IGVMainFrame() {
        this.session = new Session(null);
        this.trackManager = new TrackManager(this);
        this.createHandCursor();
        this.createZoomCursors();
        this.createDragAndDropCursor();
        this.setupIGV();
        this.igvInitialized = true;
        this.glassPane = this.getGlassPane();
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.dNdGlassPane = new GhostGlassPane();
        IGVDatasetParser.addListener(new MyStatusListener());
    }

    public GhostGlassPane getDnDGlassPane() {
        return this.dNdGlassPane;
    }

    public void startDnD() {
        this.setGlassPane(this.dNdGlassPane);
        this.getGlassPane().setVisible(true);
    }

    public void endDnD() {
        this.setGlassPane(this.glassPane);
        this.getGlassPane().setVisible(false);
    }

    public boolean isIGVIntialized() {
        return this.igvInitialized;
    }

    private void setupIGV() {
        theInstance = this;
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        if (PreferenceManager.getInstance().isPortEnabled()) {
            CommandListener.start();
        }
        this.disableGraphicAccelerators();
        this.centerSplitPane = new JideSplitPane(){

            @Override
            public Insets getInsets(Insets insets) {
                return new Insets(0, 0, 0, 0);
            }
        };
        this.igvCommandBar = new IGVCommandBar(this);
        this.igvCommandBar.setMinimumSize(new Dimension(250, 33));
        this.initializeDefaultUserDirectory();
        this.setTitle("IGV");
        this.initComponents();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.trackManager.putScrollPane("DataPanel", this.dataTrackScrollPane);
        if (!PreferenceManager.getInstance().isShowSingleTrackPane()) {
            this.trackManager.putScrollPane("FeaturePanel", this.featureTrackScrollPane);
        }
        DataPanel dp = this.dataTrackScrollPane.getDataPanel();
        this.session.getViewContext().setDataPanel(dp);
        this.pack();
        this.configureContentPane();
        this.initializeSnapshot();
        this.initializeDialogs();
        this.createMenuAndToolbar();
        if (UIConstants.IS_MAC) {
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            System.setProperty("apple.awt.rendering", "speed");
            RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                IGVMainFrame.this.doExitApplication();
            }
        });
        this.packViews();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e2) {
                IGVMainFrame.this.adjustSplitPaneDivider();
            }
        });
        Rectangle applicationBounds = PreferenceManager.getInstance().getApplicationFrameBounds();
        Dimension screenBounds = Toolkit.getDefaultToolkit().getScreenSize();
        if (applicationBounds != null && applicationBounds.getMaxX() < screenBounds.getWidth() && applicationBounds.getMaxY() < screenBounds.getHeight()) {
            this.setBounds(applicationBounds);
        }
    }

    public ViewContext getViewContext() {
        return this.session.getViewContext();
    }

    public RegionOfInterest getSelectedRegion() {
        return this.regionOfInterestPane.getSelectedRegion();
    }

    public void setSelectedRegion(RegionOfInterest region) {
        if (region != this.regionOfInterestPane.getSelectedRegion()) {
            this.regionOfInterestPane.setSelectedRegion(region);
            this.repaintDataPanels();
        }
    }

    public void setCheckingSelectedResourceNodesAllowed(boolean value) {
        this.areResourceNodesCheckable = value;
    }

    public boolean isCheckingSelectedResourceNodesAllowed() {
        return this.areResourceNodesCheckable;
    }

    static void clearAllPreferences() {
        try {
            PreferenceManager.getInstance().clear();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            String message = "Failed to clear all preferences!";
            MessageUtils.showAndLogErrorMessage(theInstance, message, log, e2);
        }
    }

    private void adjustSplitPaneDivider() {
        boolean isShowSingleTrackPane = PreferenceManager.getInstance().getShowSingleTrackPane();
        if (isShowSingleTrackPane) {
            // empty if block
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return UIConstants.preferredSize;
    }

    private void initializeDefaultUserDirectory() {
        boolean wasSuccessful;
        boolean exists;
        File defaultUserDirectory = UIConstants.getIgvDirectory();
        if (!(defaultUserDirectory.exists() || (exists = defaultUserDirectory.exists()) || (wasSuccessful = defaultUserDirectory.mkdir()))) {
            log.error("Failed to create user directory!");
        }
    }

    private void initializeDialogs() {
        this.trackFileChooser = new FileChooserDialog((Frame)this, true);
    }

    public FileChooserDialog getTrackFileChooser() {
        return this.trackFileChooser;
    }

    private void initializeSnapshot() {
        boolean wasSuccessful;
        boolean exists;
        File snapshotDirectory = PreferenceManager.getInstance().getLastSnapshotDirectory();
        if (!(snapshotDirectory == null || snapshotDirectory.exists() || (exists = snapshotDirectory.exists()) || (wasSuccessful = snapshotDirectory.mkdir()))) {
            log.error("Failed to create snapshot directory!");
        }
        FileFilter[] fileFilters = GenericUtilities.getAllSnapshotFileFilters();
        this.snapshotFileChooser = UIUtilities.getFileChooser(snapshotDirectory, null, fileFilters);
        this.snapshotFileChooser.setDialogTitle("Snapshot File");
        this.snapshotFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                File oldFile = null;
                String property = e2.getPropertyName();
                if ("SelectedFileChangedProperty".equals(property)) {
                    oldFile = (File)e2.getOldValue();
                    IGVMainFrame.this.snapshotFileChooser.setPreviousFile(oldFile);
                } else if ("fileFilterChanged".equals(property) && e2.getOldValue() instanceof GenericUtilities.SnapshotFileFilter && e2.getNewValue() instanceof GenericUtilities.SnapshotFileFilter) {
                    GenericUtilities.SnapshotFileFilter newFilter = (GenericUtilities.SnapshotFileFilter)e2.getNewValue();
                    File currentDirectory = IGVMainFrame.this.snapshotFileChooser.getCurrentDirectory();
                    File previousFile = IGVMainFrame.this.snapshotFileChooser.getPreviousFile();
                    if (previousFile != null) {
                        File file = null;
                        file = currentDirectory != null ? new File(currentDirectory, previousFile.getName()) : previousFile;
                        final File selectedFile = Utilities.changeFileExtension(file, newFilter.getExtension());
                        UIUtilities.invokeOnEventThread(new Runnable(){

                            @Override
                            public void run() {
                                IGVMainFrame.this.snapshotFileChooser.setSelectedFile(selectedFile);
                                IGVMainFrame.this.snapshotFileChooser.validate();
                            }
                        });
                    }
                }
            }
        });
    }

    public void addRegionOfInterest(RegionOfInterest roi) {
        this.session.addRegionOfInterestWithNoListeners(roi);
        this.regionOfInterestPane.setSelectedRegion(roi);
        this.regionOfInterestPane.repaint();
    }

    void beginROI(JButton button) {
        for (TrackPanelScrollPane tsv : this.trackManager.getTrackPanelScrollPanes()) {
            DataPanel dp = tsv.getDataPanel();
            RegionOfInterestTool regionOfInterestTool = new RegionOfInterestTool((Component)dp, button);
            dp.setCurrentTool(regionOfInterestTool);
        }
    }

    void endROI() {
        for (TrackPanelScrollPane tsv : this.trackManager.getTrackPanelScrollPanes()) {
            DataPanel dp = tsv.getDataPanel();
            dp.setCurrentTool(null);
        }
    }

    public void setShowRegionsOfInterestBarsOn(boolean enabled) {
        this.showRegionsOfInterestBarsOn = enabled;
    }

    public boolean isShowRegionsOfInterestBarsOn() {
        return this.showRegionsOfInterestBarsOn;
    }

    public void chromosomeChangeEvent() {
        this.chromosomeChangeEvent(true);
    }

    public void chromosomeChangeEvent(boolean updateCommandBar) {
        this.igvCommandBar.chromosomeChanged();
        if (this.getViewContext().getChrName().equals("All")) {
            this.cytobandPanel.setCursor(Cursor.getDefaultCursor());
            this.cytobandPanel.setToolTipText("");
        } else {
            this.cytobandPanel.setToolTipText("<html>Click anywhere on the cytoband <p>to center view at that location.");
            this.cytobandPanel.setCursor(Cursor.getPredefinedCursor(12));
        }
        ((NameHeaderPanel)this.nameHeaderPanel).updateHelpText();
        this.repaintDataAndHeaderPanels(updateCommandBar);
    }

    public void repaintDataAndHeaderPanels() {
        this.repaintDataAndHeaderPanels(true);
    }

    public void repaintDataAndHeaderPanels(boolean updateCommandBar) {
        this.repaintDataPanels();
        this.headerPanel.repaint();
        if (updateCommandBar) {
            this.igvCommandBar.updateCurrentCoordinates();
        }
    }

    public void repaintDataPanels() {
        for (TrackPanelScrollPane tsv : this.trackManager.getTrackPanelScrollPanes()) {
            tsv.getDataPanel().repaint();
        }
    }

    public void repaintNamePanels() {
        for (TrackPanelScrollPane tsv : this.trackManager.getTrackPanelScrollPanes()) {
            tsv.getNamePanel().repaint();
        }
    }

    public void repaintStatusAndZoomSlider() {
        this.igvCommandBar.repaint();
    }

    public void repaintCytobandPanel() {
        this.headerPanel.repaint();
    }

    public void selectGenomeFromList(String genome) {
        try {
            this.igvCommandBar.selectGenomeFromList(genome);
        }
        catch (FileNotFoundException e2) {
            log.error("File not found while intializing genome!", e2);
        }
        catch (NoRouteToHostException e3) {
            log.error("Error while intializing genome!", e3);
        }
    }

    private void configureContentPane() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        IGVMainFrame.this.doRefresh();
                    }
                });
            }
        });
        this.centerSplitPane.setDividerSize(3);
        this.centerSplitPane.setOrientation(0);
        this.centerSplitPane.add((Component)this.dataTrackScrollPane, "top");
        if (!PreferenceManager.getInstance().isShowSingleTrackPane()) {
            this.centerSplitPane.add((Component)this.featureTrackScrollPane, "bottom");
        }
        this.centerPanel.add((Component)this.headerScrollPane, "North");
        this.centerPanel.add((Component)this.centerSplitPane, "Center");
    }

    private void createMenuAndToolbar() {
        this.setJMenuBar(MenuAndToolbarUtils.createMenuBar(this.createMenus()));
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        this.getContentPane().add((Component)toolbarPanel, "North");
        toolbarPanel.setLayout(new JideBoxLayout(toolbarPanel));
        toolbarPanel.add((Component)this.igvCommandBar, "vary");
    }

    public void doDefineGenome() {
        this.doDefineGenome(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDefineGenome(ProgressMonitor monitor) {
        ProgressBar bar = null;
        File archiveFile = null;
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            GenomeBuilderDialog genomeBuilderDialog = new GenomeBuilderDialog((Frame)this, true);
            genomeBuilderDialog.setVisible(true);
            if (genomeBuilderDialog.isCanceled()) {
                return;
            }
            if (this.isIGVIntialized() && monitor != null) {
                bar = ProgressBar.showProgressDialog(IGVMainFrame.getInstance(), "Defining Genome...", monitor, false);
            }
            String genomeZipLocation = genomeBuilderDialog.getGenomeArchiveLocation();
            String cytobandFileName = genomeBuilderDialog.getCytobandFileName();
            String refFlatFileName = genomeBuilderDialog.getRefFlatFileName();
            String fastaFileName = genomeBuilderDialog.getFastaFileName();
            String relativeSequenceLocation = genomeBuilderDialog.getSequenceLocation();
            String genomeDisplayName = genomeBuilderDialog.getGenomeDisplayName();
            String genomeId = genomeBuilderDialog.getGenomeId();
            String genomeFileName = genomeBuilderDialog.getArchiveFileName();
            GenomeManager.GenomeListItem genomeListItem = GenomeManager.getInstance().defineGenome(genomeZipLocation, cytobandFileName, refFlatFileName, fastaFileName, relativeSequenceLocation, genomeDisplayName, genomeId, genomeFileName, monitor, null);
            this.enableRemoveGenomes();
            this.igvCommandBar.addToUserDefinedGenomeItemList(genomeListItem);
            this.igvCommandBar.selectGenomeFromListWithNoImport(genomeListItem.getId());
            if (this.isIGVIntialized() && monitor != null) {
                monitor.fireProgressChange(100);
            }
        }
        catch (MaximumContigGenomeException e2) {
            String genomePath = "";
            if (archiveFile != null) {
                genomePath = archiveFile.getAbsolutePath();
            }
            log.error("Failed to define genome: " + genomePath, e2);
            JOptionPane.showMessageDialog(this, "Failed to define the current genome " + genomePath + "\n" + e2.getMessage());
        }
        catch (Exception e3) {
            String genomePath = "";
            if (archiveFile != null) {
                genomePath = archiveFile.getAbsolutePath();
            }
            log.error("Failed to define genome: " + genomePath, e3);
            MessageUtils.showMessage("Unexpected while importing a genome: " + e3.getMessage());
        }
        finally {
            if (bar != null) {
                bar.close();
            }
            WaitCursorManager.removeWaitCursor(token);
        }
    }

    public GenomeManager.GenomeListItem getGenomeSelectedInDropdown() {
        return this.igvCommandBar.getGenomeSelectedInDropdown();
    }

    public Collection<String> getGenomeDisplayNames() {
        return this.igvCommandBar.getGenomeDisplayNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenomeManager.GenomeListItem doLoadGenome(ProgressMonitor monitor) {
        ProgressBar bar = null;
        GenomeManager.GenomeListItem genomeListItem = null;
        boolean doImport = true;
        while (doImport) {
            doImport = false;
            File file = null;
            WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
            try {
                File directory;
                File importDirectory = PreferenceManager.getInstance().getLastGenomeImportDirectory();
                if (importDirectory == null) {
                    PreferenceManager.getInstance().setLastGenomeImportDirectory(UIConstants.getUserDirectory());
                }
                FileFilter[] fileFilters = new FileFilter[]{new GenericUtilities.GenomeArchiveFileFilter()};
                this.genomeImportFileChooser = UIUtilities.getFileChooser(importDirectory, null, fileFilters);
                this.genomeImportFileChooser.setDialogTitle("Load Genome");
                this.genomeImportFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e2) {
                        File oldFile = null;
                        String property = e2.getPropertyName();
                        if ("SelectedFileChangedProperty".equals(property)) {
                            oldFile = (File)e2.getOldValue();
                            IGVMainFrame.this.genomeImportFileChooser.setPreviousFile(oldFile);
                        } else if ("fileFilterChanged".equals(property) && e2.getOldValue() instanceof GenericUtilities.GenomeArchiveFileFilter && e2.getNewValue() instanceof GenericUtilities.GenomeArchiveFileFilter) {
                            GenericUtilities.GenomeArchiveFileFilter newFilter = (GenericUtilities.GenomeArchiveFileFilter)e2.getNewValue();
                            File currentDirectory = IGVMainFrame.this.genomeImportFileChooser.getCurrentDirectory();
                            File previousFile = IGVMainFrame.this.genomeImportFileChooser.getPreviousFile();
                            if (previousFile != null) {
                                File file = null;
                                file = currentDirectory != null ? new File(currentDirectory, previousFile.getName()) : previousFile;
                                final File selectedFile = Utilities.changeFileExtension(file, newFilter.getExtension());
                                UIUtilities.invokeOnEventThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        IGVMainFrame.this.genomeImportFileChooser.setSelectedFile(selectedFile);
                                        IGVMainFrame.this.genomeImportFileChooser.validate();
                                    }
                                });
                            }
                        }
                    }
                });
                this.genomeImportFileChooser.showOpenDialog(this);
                file = this.genomeImportFileChooser.getSelectedFile();
                if (file == null) continue;
                if (this.isIGVIntialized() && monitor != null) {
                    bar = ProgressBar.showProgressDialog(IGVMainFrame.getInstance(), "Loading Genome...", monitor, false);
                }
                if ((directory = this.genomeImportFileChooser.getCurrentDirectory()) != null) {
                    PreferenceManager.getInstance().setLastGenomeImportDirectory(directory);
                }
                try {
                    if (this.isIGVIntialized() && monitor != null) {
                        monitor.fireProgressChange(50);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Call loadGenome");
                    }
                    genomeListItem = GenomeManager.getInstance().loadGenome(file.getAbsolutePath(), true, monitor);
                    this.igvCommandBar.addToUserDefinedGenomeItemList(genomeListItem);
                    this.igvCommandBar.selectGenomeFromListWithNoImport(genomeListItem.getId());
                    if (this.isIGVIntialized() && monitor != null) {
                        monitor.fireProgressChange(100);
                    }
                    if (bar == null) continue;
                    bar.close();
                }
                catch (Exception e2) {
                    log.fatal("Could not import genome!", e2);
                }
            }
            catch (Exception e3) {
                String genomePath = "";
                if (file != null) {
                    genomePath = file.getAbsolutePath();
                }
                log.error("Failed to load genome: " + genomePath, e3);
                int option = JOptionPane.showConfirmDialog(this, "Failed to load the current genome " + genomePath + "\n" + "Would you like to load another?", "Load Genome Failure", 2);
                if (option != 0) continue;
                doImport = true;
            }
            finally {
                WaitCursorManager.removeWaitCursor(token);
            }
        }
        return genomeListItem;
    }

    private List<AbstractButton> createMenus() {
        ArrayList<AbstractButton> menus = new ArrayList<AbstractButton>();
        menus.add(this.createFileMenu());
        menus.add(this.createViewMenu());
        menus.add(this.createTracksMenu());
        this.extrasMenu = this.createExtrasMenu();
        this.extrasMenu.setVisible(false);
        menus.add(this.extrasMenu);
        menus.add(this.createHelpMenu());
        return menus;
    }

    public void enableExtrasMenu() {
        this.extrasMenu.setVisible(true);
    }

    public void loadTracks(Collection<ResourceLocator> locators) {
        this.loadTracks(locators, false);
    }

    public void unloadTracks(Collection<ResourceLocator> locators) {
        this.trackManager.unloadTracks(locators);
        this.doRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTracks(Collection<ResourceLocator> locators, boolean doInBackground) {
        ((ApplicationStatusBar)this.statusBar).setMessage("Loading ...");
        log.debug("Run loadTracks");
        boolean tracksWereLoaded = false;
        WaitCursorManager.CursorToken token = null;
        try {
            token = WaitCursorManager.showWaitCursor();
            if (locators != null && !locators.isEmpty()) {
                HashMap<TrackPanelScrollPane, Integer> trackCountMap = new HashMap<TrackPanelScrollPane, Integer>();
                HashMap<TrackPanelScrollPane, Integer> panelSizeMap = new HashMap<TrackPanelScrollPane, Integer>();
                for (TrackPanelScrollPane sp : this.trackManager.getTrackPanelScrollPanes()) {
                    trackCountMap.put(sp, sp.getDataPanel().getAllTracks().size());
                    panelSizeMap.put(sp, sp.getDataPanel().getHeight());
                }
                tracksWereLoaded = this.getTrackManager().loadResources(locators);
                if (tracksWereLoaded) {
                    for (TrackPanelScrollPane sp : this.trackManager.getTrackPanelScrollPanes()) {
                        int prevTrackCount;
                        if (!trackCountMap.containsKey(sp) || (prevTrackCount = ((Integer)trackCountMap.get(sp)).intValue()) == sp.getDataPanel().getAllTracks().size()) continue;
                        sp.getDataPanel().doResize();
                        int scrollPosition = (Integer)panelSizeMap.get(sp);
                        if (prevTrackCount == 0 || !sp.getVerticalScrollBar().isShowing()) continue;
                        sp.getVerticalScrollBar().setMaximum(sp.getDataPanel().getHeight());
                        sp.getVerticalScrollBar().setValue(scrollPosition);
                    }
                    TrackPanelScrollPane dsp = this.trackManager.getScrollPane("DataPanel");
                    if (dsp.getDataPanel().getAllTracks().size() > 0 && this.centerSplitPane.getDividerLocation(0) < 10) {
                        this.centerSplitPane.setDividerLocation(0, 40);
                    }
                    this.doRefresh();
                }
            }
        }
        catch (Exception e2) {
            if (!(e2 instanceof ConcurrentModificationException)) {
                if (e2.getMessage() != null && e2.getMessage().length() > 8) {
                    MessageUtils.showMessage(e2.getMessage());
                } else {
                    log.error(e2);
                    MessageUtils.showMessage("An error occurred while loading tracks. Please check the logs for details.");
                }
            }
        }
        finally {
            this.showLoadedTrackCount();
            if (token != null) {
                WaitCursorManager.removeWaitCursor(token);
            }
        }
        log.debug("Finish loadTracks");
    }

    private JMenu createFileMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuItems.add(new JSeparator());
        menuAction = new LoadFilesMenuAction("Load from File...", 76, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load from URL...", 85, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromServerAction("Load from Server...", 83, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load from DAS...", 68, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new NewSessionMenuAction("New Session...", 78, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new OpenSessionMenuAction("Open Session...", 79, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SaveSessionMenuAction("Save Session...", 86, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Import Genome...", null, 68){

            @Override
            public void actionPerformed(ActionEvent event) {
                SwingWorker worker = new SwingWorker(){

                    public Object doInBackground() {
                        ProgressMonitor monitor = null;
                        if (IGVMainFrame.this.isIGVIntialized()) {
                            monitor = new ProgressMonitor();
                        }
                        IGVMainFrame.this.doDefineGenome(monitor);
                        return null;
                    }
                };
                worker.execute();
            }
        };
        menuAction.setToolTipText("Create a user-defined genome and makes it available for use in the application");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        boolean hasImportedGenomes = true;
        try {
            hasImportedGenomes = !GenomeManager.getInstance().getUserDefinedGenomeArchiveList().isEmpty();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.removeImportedGenomeAction = new RemoveUserDefinedGenomeMenuAction("Remove Imported Genomes...", 82);
        this.removeImportedGenomeAction.setEnabled(hasImportedGenomes);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(this.removeImportedGenomeAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Save Image ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.this.doApplicationSnapshot(IGVMainFrame.this.centerPanel);
            }
        };
        menuAction.setToolTipText("Capture and save an image");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new ExportRegionsMenuAction("Export Regions...", 69, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ImportRegionsMenuAction("Import Regions...", 73, this);
        menuAction.setToolTipText("Allows previously exported regions to be reloaded");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ClearRegionsMenuAction("Clear Regions...", this);
        menuAction.setToolTipText("Allows previously exported regions to be reloaded");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new LoadFromScriptMenuAction("Run Batch Script...", 88, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new SortTracksMenuAction("Run igvtools...", 84, this){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IgvToolsGui.launch(false, IGVMainFrame.this.session.getViewContext().getGenomeId());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Exit", null, 88){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.this.doExitApplication();
            }
        };
        menuAction.setToolTipText("Exit the application");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        this.recentSessionList.clear();
        String recentSessions = PreferenceManager.getInstance().getRecentSessions();
        if (recentSessions != null) {
            String[] sessions;
            for (String sessionPath : sessions = recentSessions.split(";")) {
                if (this.recentSessionList.contains(sessionPath)) continue;
                this.recentSessionList.add(sessionPath);
            }
        }
        if (!this.recentSessionList.isEmpty()) {
            menuItems.add(new JSeparator());
            for (String session : this.recentSessionList) {
                OpenSessionMenuAction osMenuAction = new OpenSessionMenuAction(session, new File(session), this);
                menuItems.add(MenuAndToolbarUtils.createMenuItem(osMenuAction));
            }
        }
        MenuAction fileMenuAction = new MenuAction("File", null, 70);
        return MenuAndToolbarUtils.createMenu(menuItems, fileMenuAction);
    }

    private JMenu createTracksMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new SortTracksMenuAction("Sort Tracks ...", 83, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new GroupTracksMenuAction("Group Tracks  ... ", 71, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        this.filterTracksAction = new FilterTracksMenuAction("Filter Tracks ...", 70, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(this.filterTracksAction));
        menuItems.add(new JSeparator());
        menuAction = new FitDataToWindowMenuAction("Fit Data to Window", 87, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SetTrackHeightMenuAction("Set Track Height...", 72, this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction dataMenuAction = new MenuAction("Tracks", null, 75);
        return MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
    }

    private JMenu createViewMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("Preferences...", null, 80){

            @Override
            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        IGVMainFrame.this.doViewPreferences();
                    }
                });
            }
        };
        menuAction.setToolTipText("Set user specific preferences");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Color Legends ...", null, 72){

            @Override
            public void actionPerformed(ActionEvent e2) {
                new LegendDialog((Frame)IGVMainFrame.this, false).setVisible(true);
            }
        };
        menuAction.setToolTipText("IGVPanel or edit color legends and scales");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        boolean isShow = PreferenceManager.getInstance().getShowAttributeView();
        this.doShowAttributeDisplay(isShow);
        menuAction = new MenuAction("Show Attribute Display", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e2.getSource();
                IGVMainFrame.this.doShowAttributeDisplay(menuItem.getState());
            }
        };
        menuAction.setToolTipText("Show or hide the attribute display");
        this.menuItem = MenuAndToolbarUtils.createMenuItem(menuAction, isShow);
        menuItems.add(this.menuItem);
        menuAction = new MenuAction("Select Attributes to Show...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.this.doSelectDisplayableAttribute();
            }
        };
        menuAction.setToolTipText("Customize attribute display to show only checked attributes");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Show Region Bars", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e2.getSource();
                PreferenceManager.getInstance().setShowRegionBars(menuItem.isSelected());
                IGVMainFrame.this.repaintDataPanels();
            }
        };
        this.menuItem = MenuAndToolbarUtils.createMenuItem(menuAction, PreferenceManager.getInstance().isShowRegionBars());
        menuItems.add(this.menuItem);
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Refresh", null, 82){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.this.doRefresh();
            }
        };
        menuAction.setToolTipText("Refresh the application's display");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new HistoryMenu("Go to"));
        MenuAction dataMenuAction = new MenuAction("View", null, 86);
        return MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
    }

    private JMenu createToolsMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        SortTracksMenuAction menuAction = null;
        menuAction = new SortTracksMenuAction("Launch Tools...", 84, this){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IgvToolsGui.launch(false, IGVMainFrame.this.session.getViewContext().getGenomeId());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction toolsMenuAction = new MenuAction("Tools", null, 84);
        return MenuAndToolbarUtils.createMenu(menuItems, toolsMenuAction);
    }

    private JMenu createExtrasMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new ResetPreferencesAction("Reset Preferences", this);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Use Linked Sorting", null, 67){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e2.getSource();
                boolean isSelected = menuItem.getState();
                PreferenceManager.getInstance().setLinkedSortingEnabled(isSelected);
            }
        };
        boolean linkedSorting = PreferenceManager.getInstance().isLinkedSortingEnabled();
        menuAction.setToolTipText("Enable linked sorting");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction, linkedSorting));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Load Genome...", null, 73){

            @Override
            public void actionPerformed(ActionEvent event) {
                SwingWorker worker = new SwingWorker(){

                    public Object doInBackground() {
                        ProgressMonitor monitor = null;
                        if (IGVMainFrame.this.isIGVIntialized()) {
                            monitor = new ProgressMonitor();
                        }
                        IGVMainFrame.this.doLoadGenome(monitor);
                        return null;
                    }
                };
                worker.execute();
            }
        };
        menuAction.setToolTipText("Make an externally defined genome available for use in the application");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Set window dimensions", null, 67){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String value = JOptionPane.showInputDialog("Enter dimensions, e.g. 800x400");
                String[] vals = value.split("x");
                if (vals.length == 2) {
                    int w = Integer.parseInt(vals[0]);
                    int h2 = Integer.parseInt(vals[1]);
                    IGVMainFrame.getInstance().setSize(w, h2);
                }
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Save Screenshot ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGVMainFrame.this.doApplicationSnapshot(IGVMainFrame.this.getContentPane());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction extrasMenuAction = new MenuAction("Extras");
        JMenu menu = MenuAndToolbarUtils.createMenu(menuItems, extrasMenuAction);
        menu.setVisible(false);
        return menu;
    }

    private JMenu createHelpMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("Help ... "){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    BrowserLauncher.openURL("http://www.broadinstitute.org/igv/UserGuide");
                }
                catch (IOException ex) {
                    log.error("Error opening browser", ex);
                }
            }
        };
        menuAction.setToolTipText("Open web help page");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Tutorial ... "){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    BrowserLauncher.openURL("http://www.broadinstitute.org/igv/QuickStart");
                }
                catch (IOException ex) {
                    log.error("Error opening browser", ex);
                }
            }
        };
        menuAction.setToolTipText("Open tutorial web page");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("About IGV "){

            @Override
            public void actionPerformed(ActionEvent e2) {
                new AboutDialog((Frame)IGVMainFrame.this, true).setVisible(true);
            }
        };
        menuAction.setToolTipText("Display application information");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction toolMenuAction = new MenuAction("Help");
        return MenuAndToolbarUtils.createMenu(menuItems, toolMenuAction);
    }

    public void enableRemoveGenomes() {
        if (this.removeImportedGenomeAction != null) {
            this.removeImportedGenomeAction.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doChooseGenome(GenomeDescriptor genomeType) {
        WaitCursorManager.CursorToken token = null;
        try {
            token = WaitCursorManager.showWaitCursor();
            if (genomeType != null) {
                String genomeId = genomeType.getId();
                String currentGenomeId = this.session.getViewContext().getGenomeId();
                if (currentGenomeId != null && genomeId.equalsIgnoreCase(currentGenomeId)) {
                    return;
                }
                this.setGenomeId(genomeId);
                PreferenceManager.getInstance().setDefaultGenome(genomeId);
                IGVMainFrame.getInstance().getTrackManager().reloadSAMTracks();
            }
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
        }
    }

    public final void doViewPreferences() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean originalSingleTrackValue = PreferenceManager.getInstance().getShowSingleTrackPane();
                boolean originalShowAttributeValue = PreferenceManager.getInstance().getShowAttributeView();
                PreferencesEditor dialog = new PreferencesEditor((Frame)IGVMainFrame.this, true);
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    IGVMainFrame.this.resetStatusMessage();
                    return;
                }
                try {
                    boolean value = PreferenceManager.getInstance().getShowMissingData();
                    MiscStuff.setShowMissingDataEnabled(value);
                    boolean singlePanel = PreferenceManager.getInstance().getShowSingleTrackPane();
                    if (originalSingleTrackValue != singlePanel) {
                        JOptionPane.showMessageDialog(IGVMainFrame.this, "Panel option change will take affect after restart.");
                    }
                    if (originalShowAttributeValue != PreferenceManager.getInstance().getShowAttributeView()) {
                        IGVMainFrame.this.packViews();
                    }
                }
                finally {
                    IGVMainFrame.this.updateTrackState();
                    IGVMainFrame.this.resetStatusMessage();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doExitApplication() {
        try {
            ((ApplicationStatusBar)this.statusBar).setMessage("Exiting...");
            if (!this.recentSessionList.isEmpty()) {
                int size = this.recentSessionList.size();
                if (size > 3) {
                    size = 3;
                }
                String recentSessions = "";
                for (int i2 = 0; i2 < size; ++i2) {
                    recentSessions = recentSessions + this.recentSessionList.get(i2);
                    if (i2 >= size - 1) continue;
                    recentSessions = recentSessions + ";";
                }
                PreferenceManager.getInstance().remove("IGVMainFrame.Session.recent.sessions");
                PreferenceManager.getInstance().setRecentSessions(recentSessions);
            }
            PreferenceManager.getInstance().setApplicationFrameBounds(this.getBounds());
            this.setVisible(false);
        }
        finally {
            System.exit(0);
        }
    }

    public final void doShowAttributeDisplay(boolean enableAttributeView) {
        boolean oldState = PreferenceManager.getInstance().getShowAttributeView();
        PreferenceManager.getInstance().setShowAttributeView(enableAttributeView);
        if (oldState != enableAttributeView) {
            this.doRefresh();
        }
    }

    public final void doRefresh() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IGVMainFrame.this.doResizeTrackPanels();
                    IGVMainFrame.this.packViews();
                    IGVMainFrame.this.getContentPane().validate();
                    IGVMainFrame.this.getContentPane().repaint();
                }
                finally {
                    IGVMainFrame.this.resetStatusMessage();
                }
            }
        });
    }

    public final void refreshCommandBar() {
        this.igvCommandBar.updateCurrentCoordinates();
    }

    public final void refreshFeatureTrackView() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IGVMainFrame.this.packViews();
                    for (TrackPanelScrollPane sp : IGVMainFrame.this.trackManager.getTrackPanelScrollPanes()) {
                        sp.getTrackPanel().validate();
                    }
                }
                finally {
                    IGVMainFrame.this.resetStatusMessage();
                }
            }
        });
    }

    public final void doResizeTrackPanels() {
        for (TrackPanelScrollPane tsp : this.trackManager.getTrackPanelScrollPanes()) {
            DataPanel dp = tsp.getDataPanel();
            dp.doResize();
            dp.validate();
            dp.repaint();
        }
    }

    public final void doSelectDisplayableAttribute() {
        List<String> allAttributes = AttributeManager.getInstance().getAttributeKeys();
        Set<String> hiddenAttributes = AttributeManager.getInstance().getHiddenAttributes();
        CheckListDialog dlg = new CheckListDialog((Frame)this, allAttributes, hiddenAttributes, false);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            AttributeManager.getInstance().setHiddenAttributes(dlg.getNonSelections());
            this.doRefresh();
            this.getContentPane().repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doApplicationSnapshot(Component target) {
        ((ApplicationStatusBar)this.statusBar).setMessage("Creating snapshot...");
        File defaultFile = new File("igv_snapshot.png");
        try {
            this.createSnapshot(target, defaultFile);
        }
        catch (Exception e2) {
            log.error("Error exporting  image ", e2);
            MessageUtils.showMessage("Error encountered while exporting image: " + e2.getMessage());
        }
        finally {
            this.resetStatusMessage();
        }
    }

    public boolean isExportingSnapshot() {
        return this.isExportingSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSnapshot(Component target, File defaultFile) {
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            ((ApplicationStatusBar)this.statusBar).setMessage("Exporting image: " + defaultFile.getAbsolutePath());
            File file = this.selectSnapshotFile(defaultFile);
            if (file == null) {
                return;
            }
            this.isExportingSnapshot = true;
            this.createSnapshotNonInteractive(target, file);
        }
        catch (Exception e2) {
            log.error("Error creating exporting image ", e2);
            MessageUtils.showMessage("Error creating the image file: " + defaultFile + "<br> " + e2.getMessage());
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
            this.resetStatusMessage();
            this.isExportingSnapshot = false;
        }
    }

    public void createSnapshotNonInteractive(File file) {
        this.createSnapshotNonInteractive(this.centerPanel, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSnapshotNonInteractive(Component target, File file) {
        GenericUtilities.SnapshotFileType type;
        log.debug("Creating snapshot: " + file.getName());
        String extension = GenericUtilities.getFileExtension(file.getAbsolutePath());
        if (extension == null) {
            FileFilter filter = this.snapshotFileChooser.getFileFilter();
            extension = !(filter instanceof GenericUtilities.SnapshotFileFilter) ? GenericUtilities.SnapshotFileType.PNG.getExtension() : ((GenericUtilities.SnapshotFileFilter)filter).getExtension();
            file = new File(file.getAbsolutePath() + extension);
        }
        if ((type = GenericUtilities.getSnapshotFileType(extension)) != GenericUtilities.SnapshotFileType.NULL) {
            boolean doubleBuffered = RepaintManager.currentManager(this.getContentPane()).isDoubleBufferingEnabled();
            try {
                this.isExportingSnapshot = true;
                RepaintManager.currentManager(this.getContentPane()).setDoubleBufferingEnabled(false);
                GenericUtilities.doComponentSnapshot(target, file, type);
            }
            finally {
                RepaintManager.currentManager(this.getContentPane()).setDoubleBufferingEnabled(doubleBuffered);
                this.isExportingSnapshot = false;
            }
        }
        log.debug("Finished creating snapshot: " + file.getName());
    }

    public File selectSnapshotFile(File defaultFile) {
        File directory;
        GenericUtilities.SnapshotFileFilter snapshotFileFilter = null;
        if (defaultFile != null) {
            String fileExtension = GenericUtilities.getFileExtension(defaultFile.getAbsolutePath());
            snapshotFileFilter = GenericUtilities.getSnapshotFileFilterForType(GenericUtilities.getSnapshotFileType(fileExtension));
        }
        this.snapshotFileChooser.setFileFilter(snapshotFileFilter);
        this.snapshotFileChooser.setSelectedFile(defaultFile);
        this.snapshotFileChooser.showSaveDialog(this);
        this.resetStatusMessage();
        File file = this.snapshotFileChooser.getSelectedFile();
        if (file != null && (directory = this.snapshotFileChooser.getCurrentDirectory()) != null) {
            PreferenceManager.getInstance().setLastSnapshotDirectory(directory);
        }
        return file;
    }

    public void setGenomeId(String id) {
        String currentGenomeId;
        if (log.isDebugEnabled()) {
            log.debug("Setting current genome id");
        }
        if ((currentGenomeId = this.session.getViewContext().getGenomeId()) != null && id.equalsIgnoreCase(currentGenomeId)) {
            return;
        }
        String gid = this.getViewContext().setGenomeId(id);
        FeatureDB.clearFeatures();
        IGVMainFrame.getInstance().getTrackManager().loadGeneTrack(gid);
        if (this.igvCommandBar != null) {
            this.igvCommandBar.updateChromosomeDropdown();
        }
        PreferenceManager.getInstance().setDefaultGenome(gid);
    }

    private void createZoomCursors() throws HeadlessException, IndexOutOfBoundsException {
        if (zoomInCursor == null || zoomOutCursor == null) {
            Image zoomInImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_IN).getImage();
            Image zoomOutImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_OUT).getImage();
            Point hotspot = new Point(10, 10);
            zoomInCursor = this.getToolkit().createCustomCursor(zoomInImage, hotspot, "Zoom in");
            zoomOutCursor = this.getToolkit().createCustomCursor(zoomOutImage, hotspot, "Zoom out");
        }
    }

    private void createHandCursor() throws HeadlessException, IndexOutOfBoundsException {
        Rectangle2D.Double rect;
        Graphics2D g2;
        BufferedImage handImage;
        if (handCursor == null) {
            handImage = new BufferedImage(32, 32, 2);
            g2 = handImage.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
            rect = new Rectangle2D.Double(0.0, 0.0, 32.0, 32.0);
            g2.fill(rect);
            g2 = handImage.createGraphics();
            g2.drawImage(IconFactory.getInstance().getIcon(IconFactory.IconID.OPEN_HAND).getImage(), 0, 0, null);
            handCursor = this.getToolkit().createCustomCursor(handImage, new Point(8, 6), "Move");
        }
        if (fistCursor == null) {
            handImage = new BufferedImage(32, 32, 2);
            g2 = handImage.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
            rect = new Rectangle2D.Double(0.0, 0.0, 32.0, 32.0);
            g2.fill(rect);
            g2 = handImage.createGraphics();
            g2.drawImage(IconFactory.getInstance().getIcon(IconFactory.IconID.FIST).getImage(), 0, 0, null);
            fistCursor = this.getToolkit().createCustomCursor(handImage, new Point(8, 6), "Move");
        }
    }

    private void createDragAndDropCursor() throws HeadlessException, IndexOutOfBoundsException {
        if (dragNDropCursor == null) {
            ImageIcon icon = IconFactory.getInstance().getIcon(IconFactory.IconID.DRAG_AND_DROP);
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            BufferedImage dragNDropImage = new BufferedImage(width, height, 2);
            Graphics2D g2 = dragNDropImage.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
            g2.fill(rect);
            g2 = dragNDropImage.createGraphics();
            Image image = icon.getImage();
            g2.drawImage(image, 0, 0, null);
            dragNDropCursor = this.getToolkit().createCustomCursor(dragNDropImage, new Point(0, 0), "Drag and Drop");
        }
    }

    public void packViews() {
        ((IGVPanel)this.applicationHeaderView).packView();
        for (TrackPanelScrollPane tsv : this.trackManager.getTrackPanelScrollPanes()) {
            tsv.getTrackPanel().packView();
        }
    }

    public void createNewSession(String sessionName) {
        LRUCache.clearCaches();
        AttributeManager.getInstance().clearAllAttributes();
        this.setTitle("IGV");
        if (this.filterTracksAction != null) {
            this.filterTracksAction.resetTrackFilter();
        }
        AttributeManager.getInstance().clearAllAttributes();
        this.session = new Session(sessionName);
        for (TrackPanelScrollPane tsp : this.trackManager.getTrackPanelScrollPanes()) {
            tsp.getTrackPanel().clearTracks();
            if (tsp == this.dataTrackScrollPane || tsp == this.featureTrackScrollPane) continue;
            this.centerSplitPane.remove(tsp);
            TrackNamePanel.removeDropListenerFor(tsp.getNamePanel());
        }
        this.trackManager.reset();
        this.trackManager.clearScrollPanes();
        this.trackManager.putScrollPane("DataPanel", this.dataTrackScrollPane);
        Track geneTrack = this.trackManager.getGeneTrack();
        if (PreferenceManager.getInstance().isShowSingleTrackPane()) {
            if (geneTrack != null) {
                this.dataTrackScrollPane.getTrackPanel().addTrack(geneTrack);
            }
        } else {
            this.trackManager.putScrollPane("FeaturePanel", this.featureTrackScrollPane);
            if (geneTrack != null) {
                this.featureTrackScrollPane.getTrackPanel().addTrack(geneTrack);
            }
        }
        this.doResizeTrackPanels();
        this.doRefresh();
    }

    public void setStatusBarMessage(String message) {
        if (message.equals("Done.")) {
            this.resetStatusMessage();
        }
        ((ApplicationStatusBar)this.statusBar).setMessage(message);
    }

    public void resetToFactorySettings() {
        try {
            PreferenceManager.getInstance().clear();
            boolean isShow = PreferenceManager.getInstance().getShowAttributeView();
            this.doShowAttributeDisplay(isShow);
            this.doRefresh();
        }
        catch (Exception e2) {
            String message = "Failure while resetting preferences!";
            MessageUtils.showAndLogErrorMessage(theInstance, message, log, e2);
        }
    }

    public void updateTrackState() {
        for (TrackPanelScrollPane sp : this.trackManager.getTrackPanelScrollPanes()) {
            sp.getDataPanel().doResize();
        }
        this.doRefresh();
    }

    public void updateTrackFilter() {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.updateTrackFilter();
            this.updateTrackState();
        }
    }

    public void setFilterMatchAll(boolean value) {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.setFilterMatchAll(value);
        }
    }

    public boolean isFilterMatchAll() {
        if (this.filterTracksAction != null) {
            return this.filterTracksAction.isFilterMatchAll();
        }
        return false;
    }

    public void setFilterShowAllTracks(boolean value) {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.setFilterShowAllTracks(value);
        }
    }

    public boolean isFilterShowAllTracks() {
        if (this.filterTracksAction != null) {
            return this.filterTracksAction.getShowAllTracksFilterCheckBox().isSelected();
        }
        return false;
    }

    public void setCurrentLocus(String locusString) {
        if (locusString == null || locusString.trim().length() < 1) {
            return;
        }
        this.igvCommandBar.searchByLocus(locusString);
    }

    public TrackPanelScrollPane addDataPanel(String name) {
        TrackPanel trackPanel = new TrackPanel(name);
        final TrackPanelScrollPane sp = new TrackPanelScrollPane();
        sp.setViewportView(trackPanel);
        for (TrackPanelScrollPane tsp : this.trackManager.getTrackPanelScrollPanes()) {
            tsp.minimizeHeight();
        }
        this.trackManager.putScrollPane(name, sp);
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                int featurePaneIdx = IGVMainFrame.this.centerSplitPane.indexOfPane(IGVMainFrame.this.featureTrackScrollPane);
                if (featurePaneIdx > 0) {
                    IGVMainFrame.this.centerSplitPane.insertPane(sp, featurePaneIdx);
                } else {
                    IGVMainFrame.this.centerSplitPane.add(sp);
                }
                if (!PreferenceManager.getInstance().isShowSingleTrackPane() && sp.getTrackPanel().getTracks().size() == 0) {
                    IGVMainFrame.this.centerSplitPane.setDividerLocation(0, 3);
                }
                IGVMainFrame.this.packViews();
            }
        });
        return sp;
    }

    public List<TrackPanel> getTrackPanels() {
        ArrayList<TrackPanel> panels = new ArrayList<TrackPanel>();
        for (Component c2 : this.centerSplitPane.getComponents()) {
            if (!(c2 instanceof TrackPanelScrollPane)) continue;
            panels.add(((TrackPanelScrollPane)c2).getTrackPanel());
        }
        return panels;
    }

    public void tweakPanelDivider() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                int h2 = IGVMainFrame.this.centerSplitPane.getHeight();
                int nPanes = IGVMainFrame.this.centerSplitPane.getPaneCount();
                double prefHeight = 0.0;
                for (int i2 = 0; i2 < nPanes; ++i2) {
                    prefHeight += IGVMainFrame.this.centerSplitPane.getPaneAt(i2).getPreferredSize().getHeight();
                }
                double ratio = (double)h2 / prefHeight;
                int pos = 0;
                for (int i3 = 0; i3 < nPanes - 1; ++i3) {
                    IGVMainFrame.this.centerSplitPane.setDividerLocation(i3, pos += (int)(ratio * IGVMainFrame.this.centerSplitPane.getPaneAt(i3).getPreferredSize().getHeight()));
                }
                IGVMainFrame.this.packViews();
            }
        });
    }

    public void removeDataPanel(String name) {
        TrackPanelScrollPane sp = this.trackManager.getScrollPane(name);
        if (sp == this.dataTrackScrollPane || sp == this.featureTrackScrollPane) {
            return;
        }
        if (sp != null) {
            this.centerSplitPane.remove(sp);
            this.trackManager.removeScrollPane(name);
            TrackNamePanel.removeDropListenerFor(sp.getNamePanel());
        }
    }

    public TrackPanel getDataPanel(String name) {
        TrackPanelScrollPane sp = this.trackManager.getScrollPane(name);
        if (sp == null) {
            sp = this.addDataPanel(name);
            this.trackManager.putScrollPane(name, sp);
        }
        return sp.getTrackPanel();
    }

    public boolean scrollToTrack(String trackName) {
        for (TrackPanelScrollPane sp : this.trackManager.getTrackPanelScrollPanes()) {
            if (!sp.getNamePanel().scrollTo(trackName)) continue;
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.nameHeaderPanel = new NameHeaderPanel();
        this.attributeHeaderPanel = new AttributeHeaderPanel();
        this.cytobandPanel = new CytobandPanel();
        this.rulerPanel = new RulerPanel();
        this.regionOfInterestPane = new RegionOfInterestPanel();
        this.headerPanel = new HeaderPanel();
        this.headerPanel.setBackground(new Color(255, 255, 255));
        this.headerPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.headerPanel.setDebugGraphicsOptions(-1);
        this.headerPanel.setMinimumSize(new Dimension(700, 0));
        this.headerPanel.setPreferredSize(new Dimension(0, 0));
        this.headerPanel.setLayout(new BorderLayout());
        this.headerScrollPane = new JideScrollPane();
        this.headerScrollPane.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204), 2));
        this.headerScrollPane.setForeground(new Color(102, 102, 102));
        this.headerScrollPane.setHorizontalScrollBarPolicy(31);
        this.headerScrollPane.setVerticalScrollBarPolicy(22);
        this.headerScrollPane.setDoubleBuffered(true);
        this.headerScrollPane.setMinimumSize(new Dimension(0, 0));
        this.headerScrollPane.setPreferredSize(new Dimension(1019, 130));
        this.cytobandPanel.setBackground(new Color(255, 255, 255));
        this.cytobandPanel.setAlignmentX(0.0f);
        this.cytobandPanel.setAlignmentY(0.0f);
        this.cytobandPanel.setDebugGraphicsOptions(-1);
        this.cytobandPanel.setOpaque(false);
        this.cytobandPanel.setPreferredSize(new Dimension(0, 50));
        this.cytobandPanel.setRequestFocusEnabled(false);
        this.cytobandPanel.setLayout(null);
        this.headerPanel.add((Component)this.cytobandPanel, "North");
        this.rulerPanel.setBackground(new Color(255, 255, 255));
        this.rulerPanel.setDebugGraphicsOptions(-1);
        this.rulerPanel.setMinimumSize(new Dimension(100, 500));
        this.rulerPanel.setOpaque(false);
        this.rulerPanel.setPreferredSize(new Dimension(100, 500));
        this.rulerPanel.setLayout(null);
        this.headerPanel.add((Component)this.rulerPanel, "Center");
        this.applicationHeaderView = new IGVPanel();
        this.applicationHeaderView.setDebugGraphicsOptions(-1);
        this.applicationHeaderView.setMaximumSize(new Dimension(Integer.MAX_VALUE, 110));
        this.applicationHeaderView.setMinimumSize(new Dimension(1000, 135));
        this.applicationHeaderView.setPreferredSize(new Dimension(1000, 110));
        this.applicationHeaderView.setLayout(new AbsoluteLayout());
        this.attributeHeaderPanel.setBackground(new Color(255, 255, 255));
        this.attributeHeaderPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.attributeHeaderPanel.setDebugGraphicsOptions(-1);
        this.attributeHeaderPanel.setMinimumSize(new Dimension(0, 0));
        this.attributeHeaderPanel.setPreferredSize(new Dimension(0, 0));
        this.attributeHeaderPanel.setLayout(new GridLayout(1, 3));
        this.nameHeaderPanel.setBackground(new Color(255, 255, 255));
        this.nameHeaderPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.nameHeaderPanel.setDebugGraphicsOptions(-1);
        this.nameHeaderPanel.setMinimumSize(new Dimension(0, 0));
        this.nameHeaderPanel.setPreferredSize(new Dimension(0, 0));
        this.nameHeaderPanel.setLayout(null);
        this.applicationHeaderView.add((Component)this.nameHeaderPanel, new AbsoluteConstraints(0, 0, 150, 125));
        this.applicationHeaderView.add((Component)this.attributeHeaderPanel, new AbsoluteConstraints(160, 0, 120, 125));
        this.regionOfInterestPane.setBackground(new Color(255, 255, 255));
        this.regionOfInterestPane.setDebugGraphicsOptions(-1);
        this.regionOfInterestPane.setMinimumSize(new Dimension(0, 13));
        this.regionOfInterestPane.setOpaque(false);
        this.headerPanel.add((Component)this.regionOfInterestPane, "South");
        this.applicationHeaderView.add((Component)this.headerPanel, new AbsoluteConstraints(290, 0, 710, 125));
        this.headerScrollPane.setViewportView(this.applicationHeaderView);
        this.centerPanel = new JPanel();
        this.centerPanel.setBackground(new Color(204, 204, 204));
        this.centerPanel.setPreferredSize(new Dimension(1021, 510));
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.headerScrollPane, "North");
        this.dataTrackScrollPane = new TrackPanelScrollPane();
        TrackPanel dataTrackView = new TrackPanel("DataPanel");
        this.dataTrackScrollPane.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.dataTrackScrollPane.setForeground(new Color(153, 153, 153));
        this.dataTrackScrollPane.setHorizontalScrollBarPolicy(31);
        this.dataTrackScrollPane.setVerticalScrollBarPolicy(22);
        this.dataTrackScrollPane.setDebugGraphicsOptions(-1);
        this.dataTrackScrollPane.setDoubleBuffered(true);
        this.dataTrackScrollPane.setMinimumSize(new Dimension(0, 0));
        this.dataTrackScrollPane.setPreferredSize(new Dimension(1021, 349));
        dataTrackView.setMinimumSize(new Dimension(1000, 0));
        dataTrackView.setPreferredSize(new Dimension(1000, 345));
        this.dataTrackScrollPane.setViewportView(dataTrackView);
        this.centerPanel.add((Component)this.dataTrackScrollPane, "Center");
        if (!PreferenceManager.getInstance().isShowSingleTrackPane()) {
            this.featureTrackScrollPane = new TrackPanelScrollPane();
            TrackPanel featureTrackView = new TrackPanel("FeaturePanel");
            this.featureTrackScrollPane.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
            this.featureTrackScrollPane.setHorizontalScrollBarPolicy(31);
            this.featureTrackScrollPane.setVerticalScrollBarPolicy(22);
            this.featureTrackScrollPane.setDebugGraphicsOptions(-1);
            this.featureTrackScrollPane.setDoubleBuffered(true);
            this.featureTrackScrollPane.setFocusTraversalPolicyProvider(true);
            this.featureTrackScrollPane.setMinimumSize(new Dimension(0, 0));
            this.featureTrackScrollPane.setOpaque(false);
            this.featureTrackScrollPane.setPreferredSize(new Dimension(1021, 50));
            featureTrackView.setDebugGraphicsOptions(-1);
            featureTrackView.setMinimumSize(new Dimension(1000, 0));
            featureTrackView.setPreferredSize(new Dimension(1000, 115));
            this.featureTrackScrollPane.setViewportView(featureTrackView);
            this.centerPanel.add((Component)this.featureTrackScrollPane, "South");
        }
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.statusBar = new ApplicationStatusBar();
        this.statusBar.setDebugGraphicsOptions(-1);
        this.getContentPane().add((Component)this.statusBar, "South");
        this.pack();
    }

    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRestoreSession(File sessionFile, String locus) {
        String filePath = "";
        if (sessionFile != null) {
            log.debug("Run doRestoreSession");
            BufferedInputStream inputStream = null;
            WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
            try {
                inputStream = new BufferedInputStream(new FileInputStream(sessionFile));
                this.doRestoreSession(inputStream, sessionFile.getAbsolutePath(), locus, false);
                String sessionFilePath = sessionFile.getAbsolutePath();
                if (!this.recentSessionList.contains(sessionFilePath)) {
                    this.recentSessionList.addFirst(sessionFilePath);
                }
            }
            catch (Exception e2) {
                String message = "Failed to load session! : " + sessionFile.getAbsolutePath();
                MessageUtils.showAndLogErrorMessage(this, message, log, e2);
            }
            finally {
                WaitCursorManager.removeWaitCursor(token);
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {
                        log.error("Error closing session stream", iOException);
                    }
                }
            }
            log.debug("Finish doRestoreSession");
        } else {
            String message = "Session file does not exist! : " + filePath;
            MessageUtils.showAndLogErrorMessage(this, message, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRestoreSession(URL sessionURL, String locus) {
        if (log.isDebugEnabled()) {
            log.debug("Enter doRestoreSession: " + sessionURL + " " + locus);
        }
        if (sessionURL != null) {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(sessionURL.openStream());
                this.doRestoreSession(inputStream, sessionURL.toString(), locus, false);
            }
            catch (Exception e2) {
                String message = "Failed to load session! : " + sessionURL;
                MessageUtils.showAndLogErrorMessage(this, message, log, e2);
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {
                        log.error("Error closing session stream", iOException);
                    }
                }
            }
        } else {
            String message = "Session file does not exist! : ";
            try {
                message = message + URLDecoder.decode(sessionURL.getFile(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                message = message + sessionURL.getFile();
            }
            MessageUtils.showAndLogErrorMessage(this, message, log);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit doRestoreSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRestoreSession(InputStream inputStream, String sessionPath, String locus, boolean merge) {
        try {
            String searchText;
            this.setStatusBarMessage("Opening session...");
            if (!merge) {
                this.createNewSession(sessionPath);
            }
            new SessionReader().loadSession(inputStream, this.session, sessionPath);
            String string = searchText = locus == null ? this.session.getLocus() : locus;
            if (searchText != null && !searchText.equals("All") && searchText.trim().length() > 0) {
                this.igvCommandBar.searchByLocus(searchText);
            }
            this.setTitle("IGV - Session: " + sessionPath);
            LRUCache.clearCaches();
            this.doRefresh();
        }
        catch (Exception e2) {
            String message = "Failed to load session! : " + sessionPath;
            MessageUtils.showAndLogErrorMessage(this, message, log, e2);
        }
        finally {
            this.resetStatusMessage();
        }
    }

    public void resetStatusMessage() {
        ((ApplicationStatusBar)this.statusBar).setMessage("" + IGVMainFrame.getInstance().getTrackManager().getVisibleTrackCount() + " tracks loaded");
    }

    public String getDisplayedLocusString() {
        return this.igvCommandBar.getSearchText();
    }

    public void rebuildGenomeDropdownList(Set excludedArchivesUrls) {
        this.igvCommandBar.rebuildGenomeItemList(excludedArchivesUrls);
    }

    public void showLoadedTrackCount() {
        ((ApplicationStatusBar)this.statusBar).setMessage("" + IGVMainFrame.getInstance().getTrackManager().getVisibleTrackCount() + " track(s) currently loaded");
    }

    private void disableGraphicAccelerators() {
        if (UIConstants.IS_MAC) {
            System.setProperty("apple.awt.graphics.UseQuartz", "false");
        } else {
            System.setProperty("sun.java2d.noddraw", "true");
        }
    }

    private void closeWindow(final ProgressBar progressBar) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                progressBar.close();
            }
        });
    }

    public void goToLocus(String locus) {
        this.igvCommandBar.searchByLocus(locus);
    }

    public TrackManager getTrackManager() {
        return this.trackManager;
    }

    public static void main(final String[] args) {
        log.info(Globals.applicationString());
        System.setProperty("http.agent", Globals.applicationString());
        FileUtils.addRollingAppenderToRootLogger();
        log.info("Default User Directory: " + UIConstants.getUserDirectory());
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Lm.verifyLicense("The Broad Institute, MIT", "Gene Pattern", "D.DQSR7z9m6fxL1IqWZ6svQFmE6vj3Q");
                if (UIConstants.IS_LINUX) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        UIManager.put("JideSplitPane.dividerSize", 5);
                        UIManager.put("JideSplitPaneDivider.background", Color.darkGray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    LookAndFeelFactory.installDefaultLookAndFeel();
                }
                LookAndFeelFactory.installJideExtension();
                IGVMainFrame frame = null;
                Window splashScreen = null;
                try {
                    frame = new IGVMainFrame();
                    IGVHttpUtils.updateProxySettings();
                    frame.startUp(args);
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new GlobalKeyDispatcher());
                }
                catch (Exception e2) {
                    log.error("Fatal application error!", e2);
                    System.exit(-1);
                }
                finally {
                    if (splashScreen != null) {
                        splashScreen.setVisible(false);
                    }
                }
            }
        });
    }

    private void startUp(String[] args) {
        if (log.isDebugEnabled()) {
            log.debug("startUp");
        }
        IGVArgs igvArgs = new IGVArgs(args);
        StartupWorker worker = new StartupWorker(igvArgs);
        worker.execute();
    }

    public class StartupWorker
    extends SwingWorker {
        IGVArgs igvArgs;

        StartupWorker(IGVArgs args) {
            this.igvArgs = args;
        }

        protected Object doInBackground() throws Exception {
            ProgressMonitor monitor = new ProgressMonitor();
            ProgressBar progressBar = ProgressBar.showProgressDialog(IGVMainFrame.this, "Initializing Genome...", monitor, false);
            monitor.fireProgressChange(10);
            String genomeId = PreferenceManager.getInstance().getDefaultGenome();
            if (genomeId == null) {
                genomeId = GenomeManager.getInstance().getTopGenomeListItem().getId();
            }
            IGVMainFrame.this.setGenomeId(genomeId);
            monitor.fireProgressChange(50);
            genomeId = IGVMainFrame.this.getViewContext().getGenomeId();
            try {
                IGVMainFrame.this.igvCommandBar.initializeGenomeList(monitor);
                IGVMainFrame.this.igvCommandBar.selectGenomeFromListWithNoImport(genomeId);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(IGVMainFrame.this, "Error initializing genome list: " + ex.getMessage());
                log.error("Error initializing genome list: ", ex);
            }
            catch (NoRouteToHostException ex) {
                JOptionPane.showMessageDialog(IGVMainFrame.this, "Network error initializing genome list: " + ex.getMessage());
                log.error("Network error initializing genome list: ", ex);
            }
            IGVMainFrame.this.closeWindow(progressBar);
            if (this.igvArgs.propertyFile != null) {
                // empty if block
            }
            if (this.igvArgs.sessionFile != null || this.igvArgs.dataFileString != null) {
                System.out.println("Session file = " + this.igvArgs.sessionFile);
                System.out.println("Locus = " + this.igvArgs.locusString);
                if (log.isDebugEnabled()) {
                    log.debug("Loadding session data");
                }
                IndefiniteProgressMonitor indefMonitor = new IndefiniteProgressMonitor(60);
                ProgressBar bar2 = ProgressBar.showProgressDialog(IGVMainFrame.this, "Loading session data", indefMonitor, false);
                boolean idx = false;
                indefMonitor.start();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Calling restore session");
                    }
                    if (this.igvArgs.genomeId != null) {
                        IGVMainFrame.this.selectGenomeFromList(this.igvArgs.genomeId);
                    }
                    if (this.igvArgs.sessionFile != null) {
                        log.info("Loading session " + this.igvArgs.sessionFile);
                        if (this.igvArgs.sessionFile.startsWith("http:") || this.igvArgs.sessionFile.startsWith("https:") || this.igvArgs.sessionFile.startsWith("file:")) {
                            URL url = new URL(this.igvArgs.sessionFile);
                            IGVMainFrame.this.doRestoreSession(url, this.igvArgs.locusString);
                        } else {
                            File sf = new File(this.igvArgs.sessionFile);
                            if (sf.exists()) {
                                IGVMainFrame.this.doRestoreSession(sf, this.igvArgs.locusString);
                            }
                        }
                        IGVMainFrame.this.doRefresh();
                    } else if (this.igvArgs.dataFileString != null) {
                        log.info("Loading session " + this.igvArgs.dataFileString);
                        String[] tokens = this.igvArgs.dataFileString.split(",");
                        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
                        for (String p2 : tokens) {
                            locators.add(new ResourceLocator(p2));
                        }
                        IGVMainFrame.this.getTrackManager().loadResources(locators);
                        IGVMainFrame.this.doRefresh();
                    }
                    if (this.igvArgs.locusString != null) {
                        log.info("Goto " + this.igvArgs.locusString);
                        IGVMainFrame.this.goToLocus(this.igvArgs.locusString);
                    }
                }
                catch (Exception ex) {
                    String tmp = this.igvArgs.sessionFile != null ? this.igvArgs.sessionFile : this.igvArgs.dataFileString;
                    JOptionPane.showMessageDialog(IGVMainFrame.this, "<html>Error loading session: " + tmp + "<br>" + ex.toString());
                    log.error("Error loading session: " + tmp, ex);
                }
                indefMonitor.stop();
                IGVMainFrame.this.closeWindow(bar2);
            } else {
                String chrName = PreferenceManager.getInstance().getLastChromosomeViewed();
                Genome genome = ViewContext.getInstance().getGenome();
                if (genome != null) {
                    if (genome.getChromosome(chrName) != null) {
                        IGVMainFrame.this.goToLocus(chrName);
                    } else {
                        IGVMainFrame.this.goToLocus(genome.getHomeChromosome());
                    }
                }
            }
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    IGVMainFrame.this.setVisible(true);
                }
            });
            return null;
        }

        @Override
        protected void done() {
            if (this.igvArgs.batchFile != null) {
                LongRunningTask.submit(new BatchRunner(this.igvArgs.batchFile));
            }
        }
    }

    static class IGVArgs {
        String batchFile = null;
        String sessionFile = null;
        String dataFileString = null;
        String locusString = null;
        String propertyFile = null;
        String genomeId = null;

        IGVArgs(String[] args) {
            this.parseArgs(args);
        }

        private void parseArgs(String[] args) {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option propertyFileOption = parser.addStringOption('p', "preferences");
            CmdLineParser.Option batchFileOption = parser.addStringOption('b', "batch");
            CmdLineParser.Option genomeOption = parser.addStringOption('g', "genome");
            try {
                parser.parse(args);
            }
            catch (CmdLineParser.IllegalOptionValueException e2) {
                e2.printStackTrace();
            }
            catch (CmdLineParser.UnknownOptionException e3) {
                e3.printStackTrace();
            }
            this.propertyFile = (String)parser.getOptionValue(propertyFileOption);
            this.batchFile = (String)parser.getOptionValue(batchFileOption);
            this.genomeId = (String)parser.getOptionValue(genomeOption);
            String[] nonOptionArgs = parser.getRemainingArgs();
            if (nonOptionArgs != null && nonOptionArgs.length > 0) {
                String firstArg = nonOptionArgs[0];
                if (firstArg.endsWith("xml")) {
                    this.sessionFile = firstArg;
                } else {
                    this.dataFileString = firstArg;
                }
                if (nonOptionArgs.length > 1) {
                    this.locusString = nonOptionArgs[1];
                }
            }
        }
    }

    private class MyStatusListener
    implements StatusListener {
        private MyStatusListener() {
        }

        @Override
        public void statusChanged(StatusChangeEvent event) {
            String statusMessage = event.getStatusMessage();
            if (statusMessage != null) {
                IGVMainFrame.this.setStatusBarMessage(statusMessage);
            }
        }
    }
}

