/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.session.ViewContext;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.IGVTool;
import org.broad.igv.ui.RegionOfInterest;

public class RegionOfInterestTool
extends IGVTool {
    RegionOfInterest regionOfInterest = null;
    Integer roiStart = null;
    JButton roiButton;

    public RegionOfInterestTool(Component owner, JButton roiButton) {
        super(owner, Cursor.getPredefinedCursor(1));
        this.roiButton = roiButton;
        this.setName("Region of Interest");
    }

    public int getRoiStart() {
        return this.roiStart == null ? 0 : this.roiStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e2) {
        Chromosome chromosome;
        ViewContext viewContext = ViewContext.getInstance();
        if (e2.getButton() == 1 && e2.getClickCount() == 1 && (chromosome = viewContext.getChromosome()) != null) {
            String chromosomeName = viewContext.getChrName();
            if (chromosomeName != null) {
                int x = e2.getX();
                if (this.roiStart == null) {
                    this.roiStart = (int)viewContext.getChromosomePosition(x);
                    this.getOwner().repaint();
                } else {
                    try {
                        int roiEnd = (int)viewContext.getChromosomePosition(x);
                        int start = Math.min(this.roiStart, roiEnd);
                        int end = Math.max(this.roiStart, roiEnd);
                        if (start == end) {
                            ++end;
                        }
                        this.regionOfInterest = new RegionOfInterest(chromosomeName, start, end, null);
                        IGVMainFrame.getInstance().endROI();
                        IGVMainFrame.getInstance().addRegionOfInterest(this.regionOfInterest);
                    }
                    finally {
                        this.roiButton.setSelected(false);
                    }
                }
            }
            IGVMainFrame.getInstance().doRefresh();
        }
    }

    public RegionOfInterest getRegionOfInterest() {
        return this.regionOfInterest;
    }
}

