/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.broad.igv.h5.HDF5RemoteReader;
import org.broad.igv.ui.UIConstants;

public class ShutdownThread
extends Thread {
    private static Logger log = Logger.getLogger(ShutdownThread.class);

    @Override
    public void run() {
        HDF5RemoteReader.shutdown();
        if (UIConstants.IS_MAC) {
            File downloads;
            File desktop = new File(System.getProperty("user.home") + "/Desktop");
            if (desktop.exists() && desktop.isDirectory()) {
                ShutdownThread.cleanupJnlpFiles(desktop);
            }
            if ((downloads = new File(System.getProperty("user.home") + "/Downloads")).exists() && downloads.isDirectory()) {
                ShutdownThread.cleanupJnlpFiles(downloads);
            }
        }
    }

    public static void cleanupJnlpFiles(File desktop) {
        if (desktop.exists() && desktop.isDirectory()) {
            File[] jnlpFiles = desktop.listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    return arg0.getName().startsWith("igv") && arg0.getName().endsWith(".jnlp");
                }
            });
            Arrays.sort(jnlpFiles, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return this.getVersionNumber(file1.getName()) - this.getVersionNumber(file2.getName());
                }

                private int getVersionNumber(String fn) {
                    int idx = fn.indexOf(".jnlp");
                    int idx2 = fn.lastIndexOf("-");
                    if (idx2 < 0) {
                        return 0;
                    }
                    try {
                        return Integer.parseInt(fn.substring(idx2 + 1, idx));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0;
                    }
                }
            });
            for (int i2 = 0; i2 < jnlpFiles.length - 1; ++i2) {
                jnlpFiles[i2].delete();
            }
            if (jnlpFiles.length > 1) {
                File newestFile = jnlpFiles[jnlpFiles.length - 1];
                String fn = newestFile.getName();
                int dotIndex = fn.indexOf(".jnlp");
                int dashIndex = fn.lastIndexOf("-");
                if (dashIndex > 1) {
                    String newName = fn.substring(0, dashIndex) + fn.substring(dotIndex);
                    newestFile.renameTo(new File(newestFile.getParentFile(), newName));
                }
            }
        }
    }
}

