/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.track.TrackType;

public class UIConstants {
    private static Logger log = Logger.getLogger(UIConstants.class);
    public static final int groupGap = 10;
    public static final String APPLICATION_NAME = "IGV";
    public static final String APPLICATION_LONG_NAME = "Integrative Genomics Viewer";
    public static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    public static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().startsWith("mac");
    public static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    public static final Dimension preferredSize = new Dimension(1000, 750);
    public static TrackType overlayTrackType = TrackType.MUTATION;
    private static int doubleClickInterval = -1;
    public static final String CLICK_ITEM_TO_EDIT_TOOLTIP = "Click this item bring up its editor";
    public static final String LOAD_TRACKS_TOOLTIP = "Load data, features or sample information";
    public static final String LOAD_SERVER_DATA_TOOLTIP = "Load data, features or sample information from a server";
    public static final String SAVE_IMAGE_TOOLTIP = "Capture and save an image";
    public static final String NEW_SESSION_TOOLTIP = "Create a new session";
    public static final String SAVE_SESSION_TOOLTIP = "Save the current session";
    public static final String RESTORE_SESSION_TOOLTIP = "Reload the named session";
    public static final String EXIT_TOOLTIP = "Exit the application";
    public static final String EXPORT_REGION_TOOLTIP = "Allows currently selected regions to be exported to a file";
    public static final String IMPORT_REGION_TOOLTIP = "Allows previously exported regions to be reloaded";
    public static final String CHANGE_GENOME_TOOLTIP = "Switch the current genome";
    public static final String IMPORT_GENOME_TOOLTIP = "Create a user-defined genome and makes it available for use in the application";
    public static final String LOAD_GENOME_TOOLTIP = "Make an externally defined genome available for use in the application";
    public static final String REMOVE_USER_DEFINE_GENOME_TOOLTIP = "Removes user-defined genomes from the drop-down list";
    public static final String CLEAR_GENOME_CACHE_TOOLTIP = "Clears locally cached versions of IGV hosted genomes.";
    public static final String PREFERENCE_TOOLTIP = "Set user specific preferences";
    public static final String SHOW_ATTRIBUTE_DISPLAY_TOOLTIP = "Show or hide the attribute display";
    public static final String REFRESH_TOOLTIP = "Refresh the application's display";
    public static final String SHOW_HEATMAP_LEGEND_TOOLTIP = "IGVPanel or edit color legends and scales";
    public static final String SELECT_DISPLAYABLE_ATTRIBUTES_TOOLTIP = "Customize attribute display to show only checked attributes";
    public static final String DIRECT_DRAW_DISABLED_TOOLTIP = "Checked this item to prevent the use of direct draw when rendering images - Uncheck it to use the default system behavior";
    public static final String SORT_TRACKS_TOOLTIP = "Sort tracks by attribute value";
    public static final String GROUP_TRACKS_TOOLTIP = "Group tracks";
    public static final String FILTER_TRACKS_TOOLTIP = "Filter tracks by attribute value";
    public static final String SET_DEFAULT_TRACK_HEIGHT_TOOLTIP = "Set the height for all tracks";
    public static final String FIT_DATA_TO_WINDOW_TOOLTIP = "Resizes all track heights in order to make all tracks visible in their display with no vertical scrolling";
    public static final String HELP_TOOLTIP = "Open web help page";
    public static final String TUTORIAL_TOOLTIP = "Open tutorial web page";
    public static final String ABOUT_TOOLTIP = "Display application information";
    public static final String MACRO_SNAPSHOTS = "Macro Snapshots";
    public static final String RESET_FACTORY_TOOLTIP = "Restores all user preferences to their default settings.";
    private static File DEFAULT_USER_DIRECTORY;
    private static File DEFAULT_IGV_DIRECTORY;
    private static File GENOME_CACHE_DIRECTORY;
    private static File IGV_TEMP_DIRECTORY;
    public static final String IGV_DIR_USERPREF = "igvDir";
    public static final String OVERWRITE_SESSION_MESSAGE = "<html>Opening a session will unload all current data. <br>Are you sure you wish to continue?";
    public static final String NEW_SESSION_MESSAGE = "<html>Creating a new session will unload all current data. <br>Are you sure you wish to continue?";
    public static final String CANNOT_ACCESS_SERVER_GENOME_LIST = "The Genome server is currently inaccessible.";
    public static final String INVALID_SERVER_GENOME_LIST_HEADER = "Genomes cannot be retrieved from the server. The server-side genome list is invalid!";
    public static final int NUMBER_OF_RECENT_SESSIONS_TO_LIST = 3;
    public static final String DEFAULT_SESSION_FILE = "igv_session.xml";
    public static final String SERVER_BASE_URL = "http://www.broadinstitute.org/";
    public static final String IGV_LOG_SERVER_URL = "http://www.broadinstitute.org/igv/LogServlet";
    public static final Color LIGHT_YELLOW;
    public static final Color VERY_LIGHT_GRAY;
    public static Color NO_DATA_COLOR;
    public static final String IMPORT_GENOME_LIST_MENU_ITEM = "Import Genome...";
    public static final String LOAD_GENOME_LIST_MENU_ITEM = "Load Genome...";
    public static final String REMOVE_GENOME_LIST_MENU_ITEM = "Remove Imported Genomes...";
    public static final String GENOME_LIST_SEPARATOR = "--SEPARATOR--";

    public static int getDoubleClickInterval() {
        if (doubleClickInterval < 0) {
            try {
                Number obj = (Number)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
                doubleClickInterval = obj.intValue();
            }
            catch (Exception e2) {
                log.info("Error retrieving doubleClickInterval", e2);
                doubleClickInterval = 500;
            }
        }
        return doubleClickInterval;
    }

    public static synchronized File getUserDirectory() {
        if (DEFAULT_USER_DIRECTORY == null) {
            DEFAULT_USER_DIRECTORY = FileSystemView.getFileSystemView().getDefaultDirectory();
        }
        return DEFAULT_USER_DIRECTORY;
    }

    public static File getIgvDirectory() {
        if (System.getProperty("os.name").equals("Windows XP")) {
            try {
                Runtime.getRuntime().exec("attrib -r \"" + UIConstants.getUserDirectory().getAbsolutePath() + "\"");
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        if (DEFAULT_IGV_DIRECTORY == null) {
            int option;
            try {
                Preferences prefs = Preferences.userNodeForPackage(UIConstants.class);
                String userDir = prefs.get(IGV_DIR_USERPREF, null);
                if (userDir != null && !(DEFAULT_IGV_DIRECTORY = new File(userDir)).exists()) {
                    DEFAULT_IGV_DIRECTORY = null;
                    prefs.remove(IGV_DIR_USERPREF);
                }
            }
            catch (Exception e3) {
                Preferences prefs = Preferences.userNodeForPackage(UIConstants.class);
                prefs.remove(IGV_DIR_USERPREF);
                System.err.println("Error creating user directory");
                e3.printStackTrace();
            }
            if (DEFAULT_IGV_DIRECTORY == null) {
                String userHomeString = System.getProperty("user.home");
                File rootDir = new File(userHomeString);
                if (!rootDir.exists() || !UIConstants.canWrite(rootDir)) {
                    rootDir = UIConstants.getUserDirectory();
                }
                if (!(DEFAULT_IGV_DIRECTORY = IS_MAC ? new File(rootDir, ".igv") : new File(rootDir, "igv")).exists()) {
                    try {
                        DEFAULT_IGV_DIRECTORY.mkdir();
                    }
                    catch (Exception e4) {
                        System.err.println("Error creating user directory");
                        e4.printStackTrace();
                    }
                }
            }
            if (!(DEFAULT_IGV_DIRECTORY.exists() && DEFAULT_IGV_DIRECTORY.canRead() && UIConstants.canWrite(DEFAULT_IGV_DIRECTORY) || (option = JOptionPane.showConfirmDialog(null, "<html>The default IGV directory (" + DEFAULT_IGV_DIRECTORY + ") " + "cannot be accessed.  Click Yes to choose a new folder or No to exit.<br>" + "This folder will be used to store user preferences and cached genomes.", "IGV Directory Error", 0)) != 0)) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                int retValue = fc.showOpenDialog(null);
                if (retValue == 0) {
                    DEFAULT_IGV_DIRECTORY = fc.getSelectedFile();
                    Preferences prefs = Preferences.userNodeForPackage(UIConstants.class);
                    prefs.put(IGV_DIR_USERPREF, DEFAULT_IGV_DIRECTORY.getAbsolutePath());
                }
            }
            if (!DEFAULT_IGV_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", DEFAULT_IGV_DIRECTORY.getAbsolutePath());
            }
            if (!UIConstants.canWrite(DEFAULT_IGV_DIRECTORY)) {
                throw new DataLoadException("Cannot write to user directory", DEFAULT_IGV_DIRECTORY.getAbsolutePath());
            }
            System.out.println("IGV directory: " + DEFAULT_IGV_DIRECTORY);
        }
        return DEFAULT_IGV_DIRECTORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File directory) {
        if (IS_WINDOWS) {
            File testFile = null;
            try {
                testFile = new File(directory, "igv332415dsfjdsklt.testfile");
                if (testFile.exists()) {
                    testFile.delete();
                }
                testFile.deleteOnExit();
                testFile.createNewFile();
                boolean bl = testFile.exists();
                return bl;
            }
            catch (IOException e2) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (testFile.exists()) {
                    testFile.delete();
                }
            }
        }
        return directory.canWrite();
    }

    public static File getGenomeCacheDirectory() {
        if (GENOME_CACHE_DIRECTORY == null) {
            GENOME_CACHE_DIRECTORY = new File(UIConstants.getIgvDirectory(), "genomes");
            if (!UIConstants.getGenomeCacheDirectory().exists()) {
                UIConstants.getGenomeCacheDirectory().mkdir();
            }
            if (!UIConstants.getGenomeCacheDirectory().canRead()) {
                throw new DataLoadException("Cannot read from user directory", UIConstants.getGenomeCacheDirectory().getAbsolutePath());
            }
            if (!UIConstants.getGenomeCacheDirectory().canWrite()) {
                throw new DataLoadException("Cannot write to user directory", UIConstants.getGenomeCacheDirectory().getAbsolutePath());
            }
        }
        return GENOME_CACHE_DIRECTORY;
    }

    public static File getTmpDirectory() {
        if (IGV_TEMP_DIRECTORY == null) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            IGV_TEMP_DIRECTORY = new File(tmpDir);
            if (!UIConstants.getTmpDirectory().exists()) {
                UIConstants.getTmpDirectory().mkdir();
            }
            if (!IGV_TEMP_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", UIConstants.getTmpDirectory().getAbsolutePath());
            }
            if (!IGV_TEMP_DIRECTORY.canWrite()) {
                throw new DataLoadException("Cannot write to user directory", UIConstants.getTmpDirectory().getAbsolutePath());
            }
        }
        return IGV_TEMP_DIRECTORY;
    }

    static {
        LIGHT_YELLOW = new Color(255, 244, 201);
        VERY_LIGHT_GRAY = new Color(238, 239, 240);
        NO_DATA_COLOR = new Color(200, 200, 200, 150);
    }
}

