/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.ResourceTree;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class LoadFromServerAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFromServerAction.class);
    IGVMainFrame mainFrame;
    static HashSet<String> failedURLs = new HashSet();

    public LoadFromServerAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Load data, features or sample information from a server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        String msg;
        this.mainFrame.setStatusBarMessage("Loading ...");
        String urlString = PreferenceManager.getInstance().getDataServerURL();
        String genomeId = ViewContext.getInstance().getGenomeId();
        String genomeURL = urlString.replaceAll("\\$\\$", genomeId);
        try {
            if (genomeURL.startsWith("http:") || genomeURL.startsWith("https:")) {
                genomeURL = genomeURL + "?genome=" + genomeId;
            }
            InputStream is = null;
            HttpURLConnection conn = null;
            LinkedHashSet<URL> urls = null;
            try {
                URL masterResourceFileURL = new URL(genomeURL);
                if (genomeURL.startsWith("ftp:")) {
                    MessageUtils.showMessage("FTP protocol not supported for data registry URL");
                    return;
                }
                if (genomeURL.startsWith("http:") || genomeURL.startsWith("https:")) {
                    conn = IGVHttpUtils.openConnection(masterResourceFileURL);
                    conn.setReadTimeout(10000);
                    conn.setConnectTimeout(10000);
                    is = IGVHttpUtils.openHttpStream(masterResourceFileURL, conn);
                } else {
                    File file = new File(genomeURL.startsWith("file:") ? masterResourceFileURL.getFile() : genomeURL);
                    if (!file.exists()) {
                        MessageUtils.showMessage("ERROR: File does not exist: " + file.getAbsolutePath());
                        return;
                    }
                    is = new FileInputStream(file);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
                urls = this.getResourceUrls(bufferedReader);
            }
            catch (IOException e2) {
                if (conn.getResponseCode() == 401) {
                    String msg2 = "Authorization failure accessing resource: " + genomeURL;
                    MessageUtils.showMessage(msg2);
                    log.error("Error accessing URL: " + genomeURL, e2);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            if (urls == null || urls.isEmpty()) {
                JOptionPane.showMessageDialog(this.mainFrame, "No datasets are available for the current genome (" + genomeId + ").");
                return;
            }
            List<ResourceLocator> locators = this.selectResources(urls);
            if (locators == null) return;
            this.mainFrame.loadTracks(locators);
            return;
        }
        catch (UnknownHostException e3) {
            msg = "The application could not contact the server: Unknown Host Failure\nHost: " + e3.getMessage();
            log.error(msg);
            MessageUtils.showMessage(msg);
            return;
        }
        catch (ConnectException e4) {
            msg = "The application could not contact the server: Connection Failure!\n" + e4.getMessage();
            log.error(msg);
            MessageUtils.showMessage(msg);
            return;
        }
        catch (Exception e5) {
            msg = "Could not load information from server!\n" + e5.getMessage();
            log.error(msg);
            MessageUtils.showMessage(msg);
            return;
        }
        finally {
            this.mainFrame.showLoadedTrackCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceLocator> selectResources(LinkedHashSet<URL> xmlUrls) {
        if (xmlUrls == null || xmlUrls.isEmpty()) {
            log.error("No datasets are available from this server for the current genome (");
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean xmlParsingError = false;
        try {
            buffer.append("<html>The following urls could not be processed due to load failures:<br>");
            Document masterDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootNode = masterDocument.createElement("Global");
            rootNode.setAttribute("name", "Available Datasets");
            rootNode.setAttribute("version", "1");
            masterDocument.appendChild(rootNode);
            for (URL url : xmlUrls) {
                if (failedURLs.contains(url.toString())) continue;
                try {
                    HttpURLConnection connection = null;
                    InputStream is = null;
                    Document xmlDocument = null;
                    try {
                        connection = IGVHttpUtils.openConnection(url);
                        connection.setConnectTimeout(10000);
                        connection.setReadTimeout(10000);
                        is = IGVHttpUtils.openHttpStream(url, connection);
                        xmlDocument = Utilities.createDOMDocumentFromXmlStream(is);
                    }
                    catch (SocketTimeoutException e2) {
                        xmlParsingError = true;
                        buffer.append("Error. Connection time out reading: " + url.toString());
                        continue;
                    }
                    catch (SAXParseException e3) {
                        log.error("Invalid XML resource: " + url, e3);
                        xmlParsingError = true;
                        buffer.append(url);
                        buffer.append("<br><i>");
                        if (url.toString().contains("iwww.broad")) {
                            buffer.append("File could not be loaded from the Broad Intranet");
                        } else {
                            buffer.append(e3.getMessage());
                        }
                        buffer.append("");
                        continue;
                    }
                    catch (FileNotFoundException e4) {
                        String message = "Could not find file represented by " + url.toString();
                        log.error(message, e4);
                        xmlParsingError = true;
                        buffer.append(url);
                        buffer.append("\t  [");
                        buffer.append(e4.getMessage());
                        buffer.append("]\n");
                        continue;
                    }
                    catch (IOException e5) {
                        String msg = "";
                        if (connection.getResponseCode() == 401) {
                            failedURLs.add(url.toString());
                            msg = "Authorization failure accessing resource: " + url;
                        } else {
                            msg = "Error accessing dataset list: " + e5.toString();
                        }
                        MessageUtils.showMessage(msg);
                        log.error("Error accessing URL: " + url, e5);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        if (connection == null) continue;
                        connection.disconnect();
                        continue;
                    }
                    if (xmlDocument == null) continue;
                    NodeList elements = xmlDocument.getElementsByTagName("Global");
                    Element global = (Element)elements.item(0);
                    NodeList nodes = global.getChildNodes();
                    Element categoryNode = masterDocument.createElement("Category");
                    categoryNode.setAttribute("name", global.getAttribute("name"));
                    categoryNode.setAttribute("hyperlink", global.getAttribute("hyperlink"));
                    rootNode.appendChild(categoryNode);
                    int size = nodes.getLength();
                    for (int i2 = 0; i2 < size; ++i2) {
                        categoryNode.appendChild(masterDocument.importNode(nodes.item(i2), true));
                    }
                }
                catch (Exception e6) {
                    String message = "Cannot create an XML Document from " + url.toString();
                    log.error(message, e6);
                }
            }
            if (xmlParsingError) {
                JOptionPane.showMessageDialog(this.mainFrame, buffer.toString());
            }
            HashSet<ResourceLocator> selectedLocators = ResourceTree.getInstance().showResourceTreeDialog(this.mainFrame, masterDocument, "Available Datasets");
            ArrayList<ResourceLocator> newLoadList = new ArrayList<ResourceLocator>();
            Set<ResourceLocator> loadedResources = IGVMainFrame.getInstance().getTrackManager().getDataResourceLocators();
            loadedResources.addAll(AttributeManager.getInstance().getLoadedResources());
            if (selectedLocators != null) {
                for (ResourceLocator locator : selectedLocators) {
                    if (locator.getPath() == null || loadedResources.contains(locator)) continue;
                    newLoadList.add(locator);
                }
            }
            ArrayList<ResourceLocator> arrayList = newLoadList;
            return arrayList;
        }
        catch (Exception e7) {
            log.error("Could not load information from server", e7);
            List<ResourceLocator> list = null;
            return list;
        }
        finally {
            if (xmlParsingError) {
                log.error(buffer.toString());
            }
        }
    }

    private LinkedHashSet<URL> getResourceUrls(BufferedReader bufferedReader) throws IOException {
        String xmlFileUrl;
        LinkedHashSet<URL> xmlFileUrls = new LinkedHashSet<URL>();
        while ((xmlFileUrl = bufferedReader.readLine()) != null && xmlFileUrl.trim().length() != 0) {
            xmlFileUrl = xmlFileUrl.trim();
            xmlFileUrls.add(new URL(xmlFileUrl));
        }
        return xmlFileUrls;
    }
}

