/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class LoadFromURLMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFilesMenuAction.class);
    public static final String LOAD_FROM_DAS = "Load from DAS...";
    public static final String LOAD_FROM_URL = "Load from URL...";
    private IGVMainFrame mainFrame;

    public LoadFromURLMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Load data, features or sample information");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String url;
        if (e2.getActionCommand().equalsIgnoreCase(LOAD_FROM_URL)) {
            String url2 = JOptionPane.showInputDialog(IGVMainFrame.getInstance(), (Object)"Enter Http URL ");
            if (url2 != null && url2.trim().length() > 0) {
                if (url2.endsWith(".xml")) {
                    this.loadSession(url2);
                } else {
                    ResourceLocator rl = new ResourceLocator(url2.trim());
                    this.mainFrame.loadTracks(Arrays.asList(rl));
                }
            }
        } else if (e2.getActionCommand().equalsIgnoreCase(LOAD_FROM_DAS) && (url = JOptionPane.showInputDialog(IGVMainFrame.getInstance(), (Object)"Enter DAS URL ")) != null && url.trim().length() > 0) {
            ResourceLocator rl = new ResourceLocator(url.trim());
            rl.setType("das");
            this.mainFrame.loadTracks(Arrays.asList(rl));
        }
    }

    private void loadSession(String url) {
        int status;
        if (IGVMainFrame.getInstance().getTrackManager().getAllTracks(false).size() > 0 && ((status = JOptionPane.showConfirmDialog(this.mainFrame, "<html>Opening a session will unload all current data. <br>Are you sure you wish to continue?", null, 2, -1, null)) == 2 || status == -1)) {
            return;
        }
        try {
            this.mainFrame.doRestoreSession(new URL(url), null);
        }
        catch (MalformedURLException e1) {
            MessageUtils.showMessage("Error loading url: " + url + " (" + e1.toString() + ")");
        }
    }
}

