/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionWriter;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileChooserDialog;

public class SaveSessionMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(SaveSessionMenuAction.class);
    IGVMainFrame mainFrame;

    public SaveSessionMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Save the current session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e2) {
        File sessionFile = null;
        FileChooserDialog dialog = null;
        String currentSessionFilePath = this.mainFrame.getSession().getPath();
        dialog = new FileChooserDialog((Frame)this.mainFrame, true);
        dialog.setTitle("Save Session");
        dialog.setFileSelectionMode(0);
        if (currentSessionFilePath == null) {
            dialog.setSelectedFile(null);
        } else {
            File currentSession = new File(currentSessionFilePath);
            dialog.setSelectedFile(currentSession);
        }
        if (dialog.getSelectedFile() == null) {
            dialog.setSelectedFile(new File("igv_session.xml"));
        }
        dialog.setCurrentDirectory(PreferenceManager.getInstance().getLastSessionDirectory());
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            this.mainFrame.resetStatusMessage();
            return;
        }
        File file = dialog.getSelectedFile();
        if (file == null) {
            log.error("Failed to save session!");
            return;
        }
        sessionFile = file;
        String filePath = file.getAbsolutePath();
        sessionFile = filePath.toLowerCase().endsWith(".xml") ? file : new File(filePath + ".xml");
        this.mainFrame.setStatusBarMessage("Saving session to " + sessionFile.getAbsolutePath());
        if (sessionFile.exists()) {
            sessionFile.delete();
        }
        File sf = sessionFile;
        FileOutputStream out = null;
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            Session currentSession = this.mainFrame.getSession();
            currentSession.setFilePath(sf.getAbsolutePath());
            new SessionWriter().saveSession(currentSession, sf);
            PreferenceManager.getInstance().setLastSessionDirectory(sf.getParentFile());
        }
        catch (Exception e22) {
            JOptionPane.showMessageDialog(this.mainFrame, "There was an error writing to " + sf.getName() + "(" + e22.getMessage() + ")");
            log.error("Failed to save session!", e22);
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
            this.mainFrame.resetStatusMessage();
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException exception) {
                    log.error("Failed to close session file!", exception);
                }
            }
        }
    }
}

