/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.MenuAction;

public class SetTrackHeightMenuAction
extends MenuAction {
    IGVMainFrame mainFrame;
    static Logger log = Logger.getLogger(SetTrackHeightMenuAction.class);
    static int lastTrackHeight = -1;

    public SetTrackHeightMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Set the height for all tracks");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.doSetTrackHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doSetTrackHeight() {
        boolean doRefresh = false;
        try {
            JPanel container = new JPanel();
            JLabel trackHeightLabel = new JLabel("Track Height (pixels)");
            JTextField trackHeightField = new JTextField();
            Dimension preferredSize = trackHeightField.getPreferredSize();
            trackHeightField.setPreferredSize(new Dimension(50, (int)preferredSize.getHeight()));
            container.add(trackHeightLabel);
            container.add(trackHeightField);
            int repTrackHeight = this.getRepresentativeTrackHeight();
            trackHeightField.setText(String.valueOf(repTrackHeight));
            int status = JOptionPane.showConfirmDialog(this.mainFrame, container, "Set Track Height", 2, -1, null);
            if (status == 2 || status == -1) {
                return;
            }
            try {
                int newTrackHeight = Integer.parseInt(trackHeightField.getText().trim());
                IGVMainFrame.getInstance().getTrackManager().setAllTrackHeights(newTrackHeight);
                lastTrackHeight = newTrackHeight;
                doRefresh = true;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.mainFrame, "Track height must be an integer number.");
            }
        }
        finally {
            if (doRefresh) {
                this.mainFrame.updateTrackState();
            }
            this.mainFrame.resetStatusMessage();
        }
    }

    private int getRepresentativeTrackHeight() {
        if (lastTrackHeight > 0) {
            return lastTrackHeight;
        }
        List<Track> tracks = IGVMainFrame.getInstance().getTrackManager().getAllTracks(false);
        double[] heights = new double[tracks.size()];
        for (int i2 = 0; i2 < tracks.size(); ++i2) {
            heights[i2] = tracks.get(i2).getHeight();
        }
        int medianTrackHeight = (int)Math.round(StatUtils.percentile(heights, 50.0));
        if (medianTrackHeight > 0) {
            return medianTrackHeight;
        }
        return PreferenceManager.getInstance().getDefaultTrackHeight();
    }
}

