/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.legend.HeatmapLegendEditor;
import org.broad.igv.ui.legend.LegendPanel;
import org.broad.igv.ui.util.UIUtilities;

public class HeatmapLegendPanel
extends LegendPanel {
    static Logger log = Logger.getLogger(HeatmapLegendPanel.class);
    private TrackType type;
    protected ContinuousColorScale colorScale;

    public HeatmapLegendPanel(TrackType type) {
        this.type = type;
        this.colorScale = PreferenceManager.getInstance().getColorScale(type);
    }

    @Override
    protected void persistResetPreferences() {
        PreferenceManager.getInstance().setColorScale(this.type, this.colorScale);
    }

    @Override
    protected void resetPreferencesToDefault() {
        this.colorScale = PreferenceManager.getInstance().getDefaultColorScale(this.type);
        this.persistResetPreferences();
        this.showResetDisplay();
    }

    @Override
    protected void reloadPreferences() {
        PreferenceManager.getInstance().setColorScale(this.type, this.colorScale);
        this.repaint();
    }

    @Override
    public void doUserPreferences() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IGVMainFrame.getInstance().setStatusBarMessage("Setting view properties...");
                HeatmapLegendEditor dialog = new HeatmapLegendEditor((Frame)IGVMainFrame.getInstance(), true, HeatmapLegendPanel.this.type, HeatmapLegendPanel.this.colorScale);
                dialog.setTitle("HeatMap Preferences");
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    IGVMainFrame.getInstance().resetStatusMessage();
                    return;
                }
                HeatmapLegendPanel.this.colorScale = dialog.getColorScheme();
                PreferenceManager.getInstance().setColorScale(HeatmapLegendPanel.this.type, HeatmapLegendPanel.this.colorScale);
                IGVMainFrame.getInstance().repaintDataPanels();
                try {
                    HeatmapLegendPanel.this.reloadPreferences();
                }
                catch (Throwable throwable) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.getWindowAncestor(HeatmapLegendPanel.this).toFront();
                        }
                    });
                    IGVMainFrame.getInstance().resetStatusMessage();
                    throw throwable;
                }
                UIUtilities.invokeOnEventThread(new /* invalid duplicate definition of identical inner class */);
                IGVMainFrame.getInstance().resetStatusMessage();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintLegend(Graphics g2) {
        DecimalFormat formatter = new DecimalFormat("0.0");
        Graphics2D g2D = null;
        try {
            g2D = (Graphics2D)g2.create();
            g2D.setFont(FontManager.getScalableFont(10));
            int npts = 5;
            double max = this.colorScale.getMaximum();
            double min = this.colorScale.getMinimum();
            int w = this.getWidth() - 20;
            double dx = (double)w / (double)npts;
            double dxj = dx / 10.0;
            double delta = (max - min) / (double)npts;
            double deltaj = delta / 10.0;
            for (int i2 = 0; i2 < npts + 1; ++i2) {
                for (int j2 = i2 * 10; j2 < i2 * 10 + 10; ++j2) {
                    double val = min + (double)j2 * deltaj;
                    Color c2 = this.colorScale.getColor((float)val);
                    g2D.setColor(c2);
                    int x0 = (int)((double)j2 * dxj);
                    int x1 = (int)((double)(j2 + 1) * dxj);
                    g2D.fillRect(x0, 0, x1 - x0, this.getHeight() / 2);
                }
                double labelVal = min + (double)i2 * delta;
                int x0 = (int)((double)i2 * dx);
                g2D.setColor(Color.BLACK);
                g2D.drawString(formatter.format(labelVal), x0, this.getHeight() - 5);
            }
        }
        finally {
            g2D.dispose();
        }
    }
}

