/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.legend.HeatmapLegendPanel;
import org.broad.igv.ui.legend.LegendPanel;
import org.broad.igv.ui.legend.LohLegendPanel;
import org.broad.igv.ui.legend.MutationLegendPanel;
import org.broad.igv.ui.util.UIUtilities;
import org.jdesktop.layout.GroupLayout;

public class LegendDialog
extends JDialog {
    private JLabel cnLabel;
    private JPanel copyNoCanvas;
    private JPanel expressionCanvas;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel legendLabel1;
    private JLabel legendLabel2;
    private JLabel legendLabel3;
    private JLabel legendLabel4;
    private JPanel lohCanvas;
    private JPanel methylationCanvas;
    private JPanel mutationCanvas;
    private JButton okButton;
    private JButton resetToDefault;
    private JPanel rnaiPanel;

    public LegendDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        ((LegendPanel)this.copyNoCanvas).setTrackType(TrackType.COPY_NUMBER);
        ((LegendPanel)this.expressionCanvas).setTrackType(TrackType.GENE_EXPRESSION);
        ((LegendPanel)this.methylationCanvas).setTrackType(TrackType.DNA_METHYLATION);
        ((LohLegendPanel)this.lohCanvas).setTrackType(TrackType.LOH);
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cnLabel = new JLabel();
        this.copyNoCanvas = new HeatmapLegendPanel(TrackType.COPY_NUMBER);
        this.jLabel1 = new JLabel();
        this.legendLabel1 = new JLabel();
        this.methylationCanvas = new HeatmapLegendPanel(TrackType.DNA_METHYLATION);
        this.lohCanvas = new LohLegendPanel();
        this.legendLabel2 = new JLabel();
        this.jLabel2 = new JLabel();
        this.expressionCanvas = new HeatmapLegendPanel(TrackType.GENE_EXPRESSION);
        this.mutationCanvas = new MutationLegendPanel();
        this.legendLabel3 = new JLabel();
        this.resetToDefault = new JButton();
        this.jLabel3 = new JLabel();
        this.legendLabel4 = new JLabel();
        this.rnaiPanel = new HeatmapLegendPanel(TrackType.RNAI);
        this.setDefaultCloseOperation(2);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cnLabel.setText("Copy Number");
        GroupLayout copyNoCanvasLayout = new GroupLayout(this.copyNoCanvas);
        this.copyNoCanvas.setLayout(copyNoCanvasLayout);
        copyNoCanvasLayout.setHorizontalGroup(copyNoCanvasLayout.createParallelGroup(1).add(0, 512, Short.MAX_VALUE));
        copyNoCanvasLayout.setVerticalGroup(copyNoCanvasLayout.createParallelGroup(1).add(0, 53, Short.MAX_VALUE));
        this.jLabel1.setFont(new Font("Lucida Sans", 1, 18));
        this.jLabel1.setText("Legends");
        this.legendLabel1.setText("Expression");
        this.methylationCanvas.setMinimumSize(new Dimension(100, 100));
        GroupLayout methylationCanvasLayout = new GroupLayout(this.methylationCanvas);
        this.methylationCanvas.setLayout(methylationCanvasLayout);
        methylationCanvasLayout.setHorizontalGroup(methylationCanvasLayout.createParallelGroup(1).add(0, 512, Short.MAX_VALUE));
        methylationCanvasLayout.setVerticalGroup(methylationCanvasLayout.createParallelGroup(1).add(0, 53, Short.MAX_VALUE));
        GroupLayout lohCanvasLayout = new GroupLayout(this.lohCanvas);
        this.lohCanvas.setLayout(lohCanvasLayout);
        lohCanvasLayout.setHorizontalGroup(lohCanvasLayout.createParallelGroup(1).add(0, 512, Short.MAX_VALUE));
        lohCanvasLayout.setVerticalGroup(lohCanvasLayout.createParallelGroup(1).add(0, 24, Short.MAX_VALUE));
        this.legendLabel2.setText("LOH");
        this.jLabel2.setText("Methylation");
        GroupLayout expressionCanvasLayout = new GroupLayout(this.expressionCanvas);
        this.expressionCanvas.setLayout(expressionCanvasLayout);
        expressionCanvasLayout.setHorizontalGroup(expressionCanvasLayout.createParallelGroup(1).add(0, 512, Short.MAX_VALUE));
        expressionCanvasLayout.setVerticalGroup(expressionCanvasLayout.createParallelGroup(1).add(0, 53, Short.MAX_VALUE));
        GroupLayout mutationCanvasLayout = new GroupLayout(this.mutationCanvas);
        this.mutationCanvas.setLayout(mutationCanvasLayout);
        mutationCanvasLayout.setHorizontalGroup(mutationCanvasLayout.createParallelGroup(1).add(0, 512, Short.MAX_VALUE));
        mutationCanvasLayout.setVerticalGroup(mutationCanvasLayout.createParallelGroup(1).add(0, 49, Short.MAX_VALUE));
        this.legendLabel3.setText("Mutation");
        this.resetToDefault.setText("Reset to default");
        this.resetToDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendDialog.this.resetToDefaultActionPerformed(evt);
            }
        });
        this.resetToDefault.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
                LegendDialog.this.resetToDefaultAncestorRemoved(evt);
            }
        });
        this.jLabel3.setText("<html>* click any item to bring up its editor");
        this.legendLabel4.setText("RNAi");
        GroupLayout rnaiPanelLayout = new GroupLayout(this.rnaiPanel);
        this.rnaiPanel.setLayout(rnaiPanelLayout);
        rnaiPanelLayout.setHorizontalGroup(rnaiPanelLayout.createParallelGroup(1).add(0, 512, Short.MAX_VALUE));
        rnaiPanelLayout.setVerticalGroup(rnaiPanelLayout.createParallelGroup(1).add(0, 53, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.cnLabel).add(this.legendLabel3)).add(58, 58, 58).add(layout.createParallelGroup(1).add(this.copyNoCanvas, -2, -1, -2).add(this.expressionCanvas, -2, -1, -2)).addContainerGap(124, Short.MAX_VALUE)).add(2, layout.createSequentialGroup().addContainerGap(394, Short.MAX_VALUE).add(this.okButton).add(137, 137, 137).add(this.resetToDefault).add(67, 67, 67)).add(layout.createSequentialGroup().add(133, 133, 133).add(this.lohCanvas, -2, -1, -2).addContainerGap(155, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(133, 133, 133).add(this.mutationCanvas, -2, -1, -2).addContainerGap(155, Short.MAX_VALUE)).add(layout.createSequentialGroup().addContainerGap().add(this.legendLabel2).addContainerGap(753, Short.MAX_VALUE)).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel3, -2, 249, -2).addContainerGap(531, Short.MAX_VALUE)).add(layout.createSequentialGroup().addContainerGap().add(this.legendLabel1).addContainerGap(711, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(327, 327, 327).add(this.jLabel1).addContainerGap(395, Short.MAX_VALUE)).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(144, 144, 144).add(this.methylationCanvas, -2, -1, -2)).add(layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0, 582, -2))).addContainerGap(124, Short.MAX_VALUE)).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(144, 144, 144).add(this.rnaiPanel, -2, -1, -2)).add(layout.createSequentialGroup().add(this.legendLabel4).addPreferredGap(0, 625, -2))).addContainerGap(124, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(24, 24, 24).add(this.jLabel1).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.cnLabel).add(this.copyNoCanvas, -2, -1, -2)).add(23, 23, 23).add(layout.createParallelGroup(3).add(this.legendLabel1).add(this.expressionCanvas, -2, -1, -2)).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.legendLabel4).add(this.rnaiPanel, -2, -1, -2)).add(25, 25, 25).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.methylationCanvas, -2, 53, -2)).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(78, 78, 78).add(this.legendLabel2)).add(layout.createSequentialGroup().add(70, 70, 70).add(this.lohCanvas, -2, -1, -2))).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(46, 46, 46).add(this.legendLabel3)).add(layout.createSequentialGroup().add(27, 27, 27).add(this.mutationCanvas, -2, -1, -2))).add(31, 31, 31).add(this.jLabel3).addPreferredGap(0, 12, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.okButton).add(this.resetToDefault)).add(39, 39, 39)));
        layout.linkSize(new Component[]{this.copyNoCanvas, this.expressionCanvas, this.methylationCanvas}, 2);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void resetToDefaultActionPerformed(ActionEvent evt) {
        String message = "This will reset all heatmap preferences to their default values.\nAre you sure you want to continue?";
        boolean status = UIUtilities.showConfirmationDialog(this, message);
        if (status) {
            ((LegendPanel)this.copyNoCanvas).resetPreferencesToDefault();
            ((LegendPanel)this.expressionCanvas).resetPreferencesToDefault();
            ((LegendPanel)this.rnaiPanel).resetPreferencesToDefault();
            ((LegendPanel)this.lohCanvas).resetPreferencesToDefault();
            ((LegendPanel)this.methylationCanvas).resetPreferencesToDefault();
            ((LegendPanel)this.mutationCanvas).resetPreferencesToDefault();
        }
    }

    private void resetToDefaultAncestorRemoved(AncestorEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LegendDialog dialog = new LegendDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e2) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

