/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;

public class DataPanelPainter {
    private static Logger log = Logger.getLogger(DataPanelPainter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Collection<TrackGroup> groups, RenderContext context, int width, int height, Color background, Rectangle visibleRect) {
        Graphics graphics2D = null;
        try {
            ArrayList<Track> trackList;
            graphics2D = (Graphics2D)context.getGraphics().create();
            ((Graphics2D)graphics2D).setBackground(background);
            graphics2D.clearRect(0, 0, width, height);
            graphics2D.setColor(Color.BLACK);
            Graphics2D greyGraphics = context.getGraphic2DForColor(UIConstants.VERY_LIGHT_GRAY);
            int trackX = 0;
            int trackY = 0;
            for (TrackGroup group : groups) {
                if (visibleRect != null && trackY > visibleRect.y + visibleRect.height) break;
                if (!group.isVisible()) continue;
                if (groups.size() > 1) {
                    greyGraphics.fillRect(0, trackY + 1, width, 9);
                    trackY += 10;
                }
                if (group.isDrawBorder()) {
                    graphics2D.drawLine(0, trackY - 1, width, trackY - 1);
                }
                trackList = new ArrayList<Track>(group.getTracks());
                for (Track track : trackList) {
                    int trackHeight = track.getHeight();
                    if (visibleRect != null) {
                        if (trackY > visibleRect.y + visibleRect.height) break;
                        if (trackY + trackHeight < visibleRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight;
                            continue;
                        }
                    }
                    if (!track.isVisible()) continue;
                    trackY = this.draw(track, trackX, trackY, width, trackHeight, context);
                }
                if (!group.isDrawBorder()) continue;
                graphics2D.drawLine(0, trackY, width, trackY);
            }
            trackX = 0;
            trackY = 0;
            for (TrackGroup group : groups) {
                if (!group.isVisible()) continue;
                if (groups.size() > 1) {
                    trackY += 10;
                }
                trackList = new ArrayList<Track>(group.getTracks());
                for (Track track : trackList) {
                    if (!track.isVisible()) continue;
                    Rectangle rect = new Rectangle(trackX, trackY, width, track.getHeight());
                    track.renderBorder(context, rect);
                    trackY += track.getHeight();
                }
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    private final int draw(Track track, int trackX, int trackY, int trackWidth, int trackHeight, RenderContext context) {
        Rectangle rect = new Rectangle(trackX, trackY, trackWidth, trackHeight);
        track.render(context, rect);
        List<Track> overlayTracks = IGVMainFrame.getInstance().getTrackManager().getOverlayTracks(track);
        if (overlayTracks != null) {
            for (Track overlayTrack : overlayTracks) {
                if (overlayTrack == track) continue;
                overlayTrack.overlay(context, rect);
            }
        }
        return trackY += trackHeight;
    }
}

