/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.HeaderPanel;
import org.broad.igv.ui.util.Packable;
import org.broad.igv.ui.util.UIUtilities;

public class IGVPanel
extends JPanel {
    public static int X_SPACING_BETWEEN_COMPONENTS = 10;
    private String viewName = "IGVPanel";

    public int getViewportHeight() {
        Container parent = this.getParent();
        return parent == null ? 0 : parent.getHeight();
    }

    public int getScrollPaneHeight() {
        int height = 0;
        Container parent = this.getParent();
        height = parent instanceof JViewport ? ((JViewport)parent).getParent().getHeight() : parent.getHeight();
        return height;
    }

    public int getViewportWidth() {
        int width = 0;
        Container parent = this.getParent();
        width = parent instanceof JViewport ? (int)((JViewport)parent).getViewSize().getWidth() : parent.getWidth();
        return width;
    }

    public JViewport getViewport() {
        JViewport viewport = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            viewport = (JViewport)parent;
        }
        return viewport;
    }

    public JScrollPane getScrollPane() {
        JScrollPane scollpane = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            scollpane = (JScrollPane)((JViewport)parent).getParent();
        }
        return scollpane;
    }

    public void setHeight(int height) {
        Component[] children;
        if (height < 0) {
            height = 0;
        }
        Dimension dimension = new Dimension(this.getWidth(), height);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        for (final Component child : children = this.getComponents()) {
            final Dimension childDimension = new Dimension(child.getWidth(), height);
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    child.setSize(childDimension);
                    child.setPreferredSize(childDimension);
                }
            });
        }
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public void packView() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                Component[] children;
                Integer attributePanelEnd = null;
                int width = 0;
                for (Component child : children = IGVPanel.this.getComponents()) {
                    if (!(child instanceof Packable)) continue;
                    ((Packable)((Object)child)).packComponent();
                    if (attributePanelEnd != null) continue;
                    int x = child.getX();
                    width = child.getWidth();
                    attributePanelEnd = new Integer(x + width);
                }
                if (attributePanelEnd != null) {
                    for (Component child : children = IGVPanel.this.getComponents()) {
                        if (!(child instanceof DataPanel) && !(child instanceof HeaderPanel)) continue;
                        if (width > 0) {
                            attributePanelEnd = attributePanelEnd + X_SPACING_BETWEEN_COMPONENTS;
                        }
                        child.setLocation(attributePanelEnd, child.getY());
                    }
                }
            }
        });
    }
}

