/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import com.jidesoft.utils.SwingWorker;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Genome;
import org.broad.igv.session.ViewContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.WaitCursorManager;

public class RulerPanel
extends JPanel {
    private static Logger log = Logger.getLogger(RulerPanel.class);
    boolean drawSpan = true;
    boolean drawEllipsis = false;
    private Font tickFont = FontManager.getScalableFont(1, 9);
    private Font spanFont = FontManager.getScalableFont(1, 12);
    private Font chrFont = FontManager.getScalableFont(10);
    private List<ClickLink> chromosomeRects = new ArrayList<ClickLink>();
    private static Color dragColor = new Color(0.5f, 0.5f, 1.0f, 0.3f);
    private static Color zoomBoundColor = new Color(0.5f, 0.5f, 0.5f);
    boolean dragging = false;
    int dragStart;
    int dragEnd;
    public static final String WHOLE_GENOME_TOOLTIP = "<html>Click on a chromosome number to jump to that chromosome,<br>or click and drag to zoom in.";
    public static final String CHROM_TOOLTIP = "Click and drag to zoom in.";

    public RulerPanel() {
        this.initialize();
    }

    private boolean isWholeGenomeView() {
        return this.getViewContext().getChrName().equals("All");
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        g2.setColor(Color.black);
        if (this.isWholeGenomeView()) {
            this.drawChromosomeTicks(g2);
        } else {
            this.drawTicks(g2);
            if (this.drawSpan) {
                this.drawSpan(g2);
            }
            if (this.drawEllipsis) {
                this.drawEllipsis(g2);
            }
        }
        if (this.dragging) {
            g2.setColor(dragColor);
            int start = Math.min(this.dragStart, this.dragEnd);
            int w = Math.abs(this.dragEnd - this.dragStart);
            int height = this.getHeight();
            g2.fillRect(start, 0, w, height);
            g2.setColor(zoomBoundColor);
            g2.drawLine(this.dragStart, 0, this.dragStart, height);
            g2.drawLine(this.dragEnd, 0, this.dragEnd, height);
        }
    }

    private ViewContext getViewContext() {
        return ViewContext.getInstance();
    }

    private void drawSpan(Graphics g2) {
        int w = this.getWidth();
        g2.setFont(this.spanFont);
        int range = (int)(this.getViewContext().getScale() * (double)w) + 1;
        TickSpacing ts = this.findSpacing(range);
        String rangeString = this.formatNumber((double)range / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
        int strWidth = g2.getFontMetrics().stringWidth(rangeString);
        int strHeight = g2.getFontMetrics().getAscent();
        int strPosition = (w - strWidth) / 2;
        int lineY = this.getHeight() - 35 - strHeight / 2;
        g2.drawLine(0, lineY, (w - strWidth) / 2 - 10, lineY);
        int[] arrowX = new int[]{0, 10, 10};
        int[] arrowY = new int[]{lineY, lineY + 3, lineY - 3};
        g2.fillPolygon(arrowX, arrowY, arrowX.length);
        g2.drawLine((w + strWidth) / 2 + 10, lineY, w, lineY);
        arrowX = new int[]{w, w - 10, w - 10};
        g2.fillPolygon(arrowX, arrowY, arrowX.length);
        g2.drawString(rangeString, strPosition, this.getHeight() - 35);
    }

    private void drawEllipsis(Graphics g2) {
        double cytobandScale = (double)this.getViewContext().getChromosomeLength() / (double)this.getWidth();
        double maxPixel = this.getViewContext().getMaxPixel();
        int start = (int)(this.getViewContext().getOrigin() / cytobandScale);
        int span = (int)((double)this.getWidth() * this.getViewContext().getScale() / cytobandScale);
        int end = start + span;
        g2.drawLine(start, 0, 0, this.getHeight());
        g2.drawLine(end, 0, this.getWidth(), this.getHeight());
    }

    private void drawTicks(Graphics g2) {
        int w = this.getWidth();
        g2.setFont(this.tickFont);
        int range = (int)((double)w * this.getViewContext().getScale());
        TickSpacing ts = this.findSpacing(range);
        double spacing = ts.getMajorTick();
        int nTick = (int)(this.getViewContext().getOrigin() / spacing) - 1;
        int l = (int)((double)nTick * spacing);
        int x = this.getViewContext().getPixelPosition(l - 1);
        while (x < this.getWidth()) {
            l = (int)((double)nTick * spacing);
            x = this.getViewContext().getPixelPosition(l - 1);
            String chrPosition = this.formatNumber((double)l / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
            int strWidth = g2.getFontMetrics().stringWidth(chrPosition);
            int strPosition = x - strWidth / 2;
            if (nTick % 2 == 0) {
                g2.drawString(chrPosition, strPosition, this.getHeight() - 15);
            }
            g2.drawLine(x, this.getHeight() - 10, x, this.getHeight() - 2);
            ++nTick;
        }
    }

    private void drawChromosomeTicks(Graphics g2) {
        this.setLayout(null);
        int locationUnit = 1000;
        g2.setFont(this.chrFont);
        Genome genome = this.getViewContext().getGenome();
        if (genome == null) {
            log.info("No genome found with id: " + this.getViewContext().getGenomeId());
            PreferenceManager.getInstance().remove("DEFAULT_GENOME_KEY");
        }
        boolean even = true;
        long offset = 0L;
        this.chromosomeRects.clear();
        List<String> chrNames = genome.getChromosomeNames();
        if (chrNames == null) {
            log.info("No chromosomes found for genome: " + genome.getId());
            PreferenceManager.getInstance().remove("DEFAULT_GENOME_KEY");
        }
        if (chrNames.size() > 500) {
            return;
        }
        for (String chrName : genome.getChromosomeNames()) {
            Chromosome c2 = genome.getChromosome(chrName);
            int chrLength = c2.getLength();
            int x = (int)((double)offset / ((double)locationUnit * this.getViewContext().getScale()));
            int dw = (int)((double)chrLength / ((double)locationUnit * this.getViewContext().getScale()));
            if (dw > 1) {
                g2.drawLine(x, this.getHeight() - 10, x, this.getHeight() - 2);
                if (dw > 5) {
                    int center = x + dw / 2;
                    String chrNumber = chrName.replace("chr", "");
                    int strWidth = g2.getFontMetrics().stringWidth(chrNumber);
                    int strPosition = center - strWidth / 2;
                    int y = even ? this.getHeight() - 35 : this.getHeight() - 25;
                    g2.drawString(chrNumber, strPosition, y);
                    Rectangle clickRect = new Rectangle(strPosition, y - 15, 15, 15);
                    String tooltipText = "Jump to chromosome: " + chrName;
                    this.chromosomeRects.add(new ClickLink(clickRect, chrName, tooltipText));
                    even = !even;
                }
            }
            offset += (long)chrLength;
        }
    }

    private String formatNumber(double position) {
        DecimalFormat formatter = new DecimalFormat();
        return formatter.format((int)position);
    }

    TickSpacing findSpacing(long maxValue) {
        if (maxValue < 10L) {
            return new TickSpacing(1.0, "bp", 1);
        }
        boolean scaleInKB = this.getViewContext().getChrName().equals("All");
        int nZeroes = (int)Math.log10(maxValue);
        String majorUnit = scaleInKB ? "kb" : "bp";
        int unitMultiplier = 1;
        if (nZeroes > 9) {
            majorUnit = scaleInKB ? "tb" : "gb";
            unitMultiplier = 1000000000;
        }
        if (nZeroes > 6) {
            majorUnit = scaleInKB ? "gb" : "mb";
            unitMultiplier = 1000000;
        } else if (nZeroes > 3) {
            majorUnit = scaleInKB ? "mb" : "kb";
            unitMultiplier = 1000;
        }
        double nMajorTicks = (double)maxValue / Math.pow(10.0, nZeroes - 1);
        if (nMajorTicks < 25.0) {
            return new TickSpacing(Math.pow(10.0, nZeroes - 1), majorUnit, unitMultiplier);
        }
        return new TickSpacing(Math.pow(10.0, nZeroes) / 2.0, majorUnit, unitMultiplier);
    }

    private void initialize() {
        this.setBorder(BorderFactory.createLineBorder(new Color(0.0f, 0.0f, 0.0f, 0.2f)));
        this.setCursor(Cursor.getDefaultCursor());
        if (this.isWholeGenomeView()) {
            this.setToolTipText(WHOLE_GENOME_TOOLTIP);
        } else {
            this.setToolTipText("Click and drag to zoom");
        }
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
            int lastMousePressX;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                MouseEvent e2 = evt;
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    if (!RulerPanel.this.isWholeGenomeView()) {
                        double newLocation = ViewContext.getInstance().getChromosomePosition(e2.getX());
                        RulerPanel.this.getViewContext().centerOnLocation(newLocation);
                    } else {
                        for (ClickLink link : RulerPanel.this.chromosomeRects) {
                            if (link.region.contains(e2.getPoint())) {
                                RulerPanel.this.getViewContext().setChrName(link.value);
                                RulerPanel.this.getViewContext().recordHistory();
                                IGVMainFrame.getInstance().chromosomeChangeEvent();
                                return;
                            }
                            RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e2) {
                if (RulerPanel.this.isWholeGenomeView()) {
                    for (ClickLink link : RulerPanel.this.chromosomeRects) {
                        if (!link.region.contains(e2.getPoint())) continue;
                        RulerPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                        RulerPanel.this.setToolTipText(link.tooltipText);
                        return;
                    }
                    RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                    RulerPanel.this.setToolTipText(RulerPanel.WHOLE_GENOME_TOOLTIP);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
                RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                if (RulerPanel.this.isWholeGenomeView()) {
                    RulerPanel.this.setToolTipText(RulerPanel.WHOLE_GENOME_TOOLTIP);
                } else {
                    RulerPanel.this.setToolTipText(RulerPanel.CHROM_TOOLTIP);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e2) {
                if (Math.abs(e2.getPoint().getX() - (double)RulerPanel.this.dragStart) > 1.0) {
                    RulerPanel.this.dragEnd = e2.getX();
                    RulerPanel.this.dragging = true;
                    RulerPanel.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                RulerPanel.this.dragStart = e2.getX();
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (RulerPanel.this.dragging) {
                    RulerPanel.this.dragEnd = e2.getX();
                    RulerPanel.this.dragging = false;
                    RulerPanel.this.zoom();
                }
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private void zoom() {
        SwingWorker worker = new SwingWorker(){
            WaitCursorManager.CursorToken token;

            protected Object doInBackground() throws Exception {
                this.token = WaitCursorManager.showWaitCursor();
                ViewContext vc = RulerPanel.this.getViewContext();
                double s = vc.getChromosomePosition(RulerPanel.this.dragStart);
                double e2 = vc.getChromosomePosition(RulerPanel.this.dragEnd);
                if (e2 < s) {
                    double tmp = s;
                    s = e2;
                    e2 = tmp;
                }
                if (e2 - s < 40.0) {
                    double c2 = (s + e2) / 2.0;
                    s = c2 - 20.0;
                    e2 = c2 + 20.0;
                }
                String chr = null;
                if (RulerPanel.this.isWholeGenomeView()) {
                    Genome genome = vc.getGenome();
                    Genome.ChromosomeCoordinate start = genome.getChromosomeCoordinate((int)s);
                    Genome.ChromosomeCoordinate end = genome.getChromosomeCoordinate((int)e2);
                    chr = start.getChr();
                    s = start.getCoordinate();
                    e2 = end.getCoordinate();
                    if (end.getChr() != start.getChr()) {
                        e2 = genome.getChromosome(start.getChr()).getLength();
                    }
                } else {
                    chr = vc.getChrName();
                }
                vc.jumpTo(chr, (int)Math.min(s, e2), (int)Math.max(s, e2));
                vc.recordHistory();
                return null;
            }

            @Override
            protected void done() {
                WaitCursorManager.removeWaitCursor(this.token);
            }
        };
        worker.execute();
    }

    class ClickLink {
        Rectangle region;
        String value;
        String tooltipText;

        ClickLink(Rectangle region, String value, String tooltipText) {
            this.region = region;
            this.value = value;
            this.tooltipText = tooltipText;
        }
    }

    class TickSpacing {
        private double majorTick;
        private double minorTick;
        private String majorUnit = "";
        private int unitMultiplier = 1;

        TickSpacing(double majorTick, String majorUnit, int unitMultiplier) {
            this.majorTick = majorTick;
            this.minorTick = majorTick / 10.0;
            this.majorUnit = majorUnit;
            this.unitMultiplier = unitMultiplier;
        }

        public double getMajorTick() {
            return this.majorTick;
        }

        public double getMinorTick() {
            return this.minorTick;
        }

        public String getMajorUnit() {
            return this.majorUnit;
        }

        public void setMajorUnit(String majorUnit) {
            this.majorUnit = majorUnit;
        }

        public int getUnitMultiplier() {
            return this.unitMultiplier;
        }

        public void setUnitMultiplier(int unitMultiplier) {
            this.unitMultiplier = unitMultiplier;
        }
    }
}

