/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGVMainFrame;

public class ConfirmDialog
extends JDialog {
    String key;
    boolean okPressed = false;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label;
    private JPanel buttonBar;
    private JCheckBox doNotShowCheckbox;
    private JButton cancelButton;
    private JButton okButton;

    private ConfirmDialog(Frame owner, String message, String key) {
        super(owner);
        this.setModal(true);
        this.initComponents();
        this.label.setText("<html>" + message + "</html>");
        this.okButton.setText("Continue");
        this.key = key;
        this.getRootPane().setDefaultButton(this.cancelButton);
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        if (this.doNotShowCheckbox.isSelected()) {
            PreferenceManager.getInstance().put(this.key, "false");
        }
        this.okPressed = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        if (this.doNotShowCheckbox.isSelected()) {
            PreferenceManager.getInstance().put(this.key, "false");
        }
        this.okPressed = false;
        this.setVisible(false);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label = new JLabel();
        this.buttonBar = new JPanel();
        this.doNotShowCheckbox = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(null);
        this.label.setText("text");
        this.contentPanel.add(this.label);
        this.label.setBounds(10, 0, 565, 195);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.contentPanel.getComponentCount(); ++i2) {
            Rectangle bounds = this.contentPanel.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 0, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.doNotShowCheckbox.setText("Do not show this message again.");
        this.buttonBar.add((Component)this.doNotShowCheckbox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ConfirmDialog.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ConfirmDialog.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(600, 300);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void optionallyShowInfoDialog(String message, String key) {
        boolean show = PreferenceManager.getInstance().getBooleanPreference(key, true);
        if (show) {
            ConfirmDialog dlg = new ConfirmDialog((Frame)IGVMainFrame.getInstance(), message, key);
            dlg.okButton.setText("OK");
            dlg.cancelButton.setVisible(false);
            dlg.setVisible(true);
        }
    }

    public static boolean optionallyShowInfoDialog(String message, String key, boolean defaultValue) {
        boolean show = PreferenceManager.getInstance().getBooleanPreference(key, true);
        if (show) {
            ConfirmDialog dlg = new ConfirmDialog((Frame)IGVMainFrame.getInstance(), message, key);
            dlg.setVisible(true);
            return dlg.okPressed;
        }
        return defaultValue;
    }

    public static void main(String[] args) {
        ConfirmDialog.optionallyShowInfoDialog("asdfasd sfs sdfdsfds ddddf ef  feeeeeeeeef dfd sdfd  sdfd asdfasd sfs sdfdsfds ddddf ef  feeeeeeeeef dfd sdfd  sdfd asdfasd sfs sdfdsfds ddddf ef  feeeeeeeeef dfd sdfd  sdfd ", "focccsfcccco", true);
    }
}

