/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.broad.igv.session.ViewContext;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.SearchCommand;

public class HistoryMenu
extends JMenu {
    static int MAX_ITEMS = 30;
    private JMenuItem backItem;
    private JMenuItem forwardItem;
    private JMenuItem clearAllItem;

    public HistoryMenu() {
        this("History");
    }

    public HistoryMenu(String name) {
        super(name);
        final ViewContext.History history = ViewContext.getInstance().history;
        this.clearAllItem = new JMenuItem("Clear all");
        this.clearAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                history.clear();
            }
        });
        this.backItem = new JMenuItem("Back");
        this.backItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String locus = history.back();
                if (locus != null) {
                    new SearchCommand(ViewContext.getInstance(), locus, false).execute();
                    IGVMainFrame.getInstance().refreshCommandBar();
                }
            }
        });
        this.forwardItem = new JMenuItem("Forward");
        this.forwardItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String locus = history.forward();
                if (locus != null) {
                    new SearchCommand(ViewContext.getInstance(), locus, false).execute();
                    IGVMainFrame.getInstance().refreshCommandBar();
                }
            }
        });
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                ViewContext.History history = ViewContext.getInstance().history;
                List<String> allLoci = ViewContext.getInstance().getAllHistory();
                boolean hasBack = history.peekBack() != null;
                boolean hasForward = history.peekForward() != null;
                HistoryMenu.this.backItem.setEnabled(hasBack);
                HistoryMenu.this.forwardItem.setEnabled(hasForward);
                HistoryMenu.this.clearAllItem.setEnabled(allLoci.size() > 0);
                HistoryMenu.this.removeAll();
                HistoryMenu.this.add(HistoryMenu.this.backItem);
                HistoryMenu.this.add(HistoryMenu.this.forwardItem);
                HistoryMenu.this.addSeparator();
                int nItems = 0;
                for (int idx = allLoci.size() - 1; idx >= 0; --idx) {
                    String s = allLoci.get(idx);
                    final JMenuItem item = new JMenuItem(s);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String locus = item.getText();
                            new SearchCommand(ViewContext.getInstance(), locus, false).execute();
                            IGVMainFrame.getInstance().refreshCommandBar();
                        }
                    });
                    HistoryMenu.this.add(item);
                    if (nItems++ > MAX_ITEMS) break;
                }
                HistoryMenu.this.addSeparator();
                HistoryMenu.this.add(HistoryMenu.this.clearAllItem);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }
}

