/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.tribble.util.HttpUtils;

public class FileUtils {
    private static final String separator = System.getProperties().getProperty("file.separator");
    public static StringBuffer buffer = new StringBuffer();
    private static RollingFileAppender appender;
    private static Logger log;
    static Map<String, String> illegalChar;

    public static boolean resourceExists(String path) {
        try {
            boolean remoteFile = FileUtils.isRemote(path);
            return !remoteFile && new File(path).exists() || remoteFile && HttpUtils.resourceAvailable(new URL(path));
        }
        catch (MalformedURLException e2) {
            log.error("Malformed URL: " + path, e2);
            return false;
        }
    }

    public static boolean isRemote(String path) {
        return path.startsWith("http://") || path.startsWith("https://") || path.startsWith("ftp://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWriteTo(File file) {
        Object fos = null;
        try {
            file.createNewFile();
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            file.delete();
        }
    }

    public static String getInstallDirectory() {
        String path = FileUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File f2 = new File(path);
        if (f2.isDirectory()) {
            return f2.getAbsolutePath();
        }
        return f2.getParentFile().getAbsolutePath();
    }

    public static String getRelativePath(File baseFile, String targetFile) {
        return FileUtils.getRelativePath(baseFile, new File(targetFile));
    }

    public static String getRelativePath(File baseFile, File targetFile) {
        if (!baseFile.isDirectory()) {
            throw new RuntimeException(baseFile.getAbsolutePath() + " is not a directory!");
        }
        boolean isTargetAFile = targetFile.isFile();
        File target = targetFile;
        if (isTargetAFile) {
            target = targetFile.getParentFile();
        } else if (!targetFile.isDirectory()) {
            throw new RuntimeException(targetFile.getAbsolutePath() + " is not a directory or file!");
        }
        String path = "???";
        boolean isUsingRelativePath = true;
        boolean isMoreTargetPath = true;
        String delimeter = separator.equals("\\") ? "\\\\" : separator;
        String path1 = baseFile.getAbsolutePath();
        String path2 = target.getAbsolutePath();
        if (!path1.equals(path2)) {
            int i2;
            String[] basePath = path1.split(delimeter);
            String[] targetPath = path2.split(delimeter);
            for (i2 = 0; i2 < basePath.length && i2 != basePath.length; ++i2) {
                if (i2 == targetPath.length) {
                    int levelsBack = basePath.length - i2;
                    path = FileUtils.completeTheRelativePath(levelsBack, targetPath, i2);
                    break;
                }
                if (i2 == 0) {
                    if (!basePath[i2].equals(targetPath[i2])) {
                        path = target.getAbsolutePath();
                        isUsingRelativePath = false;
                        break;
                    }
                    path = "." + separator;
                    continue;
                }
                if (basePath[i2].equals(targetPath[i2])) continue;
                int levelsBack = basePath.length - i2;
                path = FileUtils.completeTheRelativePath(levelsBack, targetPath, i2);
                isMoreTargetPath = false;
                break;
            }
            if (isUsingRelativePath && isMoreTargetPath) {
                path = path + FileUtils.completeTheRelativePath(0, targetPath, i2);
            }
        } else {
            path = "." + separator;
        }
        if (isTargetAFile) {
            path = isUsingRelativePath ? path + targetFile.getName() : new File(path, targetFile.getName()).getAbsolutePath();
        }
        return path;
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e2) {
            return file.getAbsolutePath();
        }
    }

    public static String getPlatformIndependentPath(String path) {
        return path.replace('\\', '/');
    }

    private static String completeTheRelativePath(int levelsBack, String[] targetPath, int startingIndexForTarget) {
        buffer.delete(0, buffer.length());
        for (int j2 = 0; j2 < levelsBack; ++j2) {
            buffer.append("..");
            buffer.append(separator);
        }
        for (int k2 = startingIndexForTarget; k2 < targetPath.length; ++k2) {
            buffer.append(targetPath[k2]);
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i2 = 0; i2 < children.length; ++i2) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i2]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixEOL(String ifile, String ofile) {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(ifile));
            pw = new PrintWriter(new FileWriter(ofile));
            while ((nextLine = br.readLine()) != null) {
                pw.println(nextLine);
            }
            br.close();
            pw.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void addRollingAppenderToRootLogger() {
        FileUtils.addRollingAppenderToLogger(Logger.getRootLogger());
    }

    public static void addRollingAppenderToLogger(Logger logger) {
        if (appender == null) {
            try {
                PatternLayout layout = new PatternLayout();
                layout.setConversionPattern("%p [%d{ISO8601}] [%F:%L]  %m%n");
                appender = new RollingFileAppender();
                appender.setName("IGV_ROLLING_APPENDER");
                appender.setFile(FileUtils.getLogFilePath());
                appender.setThreshold(Level.ALL);
                appender.setMaxFileSize("1000KB");
                appender.setMaxBackupIndex(1);
                appender.setLayout(layout);
                appender.setAppend(true);
                appender.activateOptions();
                logger.addAppender(appender);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new RuntimeException(e2);
            }
        }
    }

    public static String getLogFilePath() {
        StringBuffer logFilePath = new StringBuffer();
        logFilePath.append(UIConstants.getIgvDirectory());
        logFilePath.append(separator);
        logFilePath.append("igv.log");
        File logFile = null;
        try {
            logFile = new File(logFilePath.toString().trim());
            if (!logFile.getParentFile().exists()) {
                logFile.getParentFile().mkdir();
            }
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
        }
        catch (Exception e2) {
            System.out.println("Error creating log file: " + logFile.getAbsolutePath());
            e2.printStackTrace();
        }
        return logFilePath.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(from);
            FileUtils.createFileFromStream(is, to);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFileFromStream(InputStream in, File outputFile) throws IOException {
        boolean totalSize = false;
        FileOutputStream out = null;
        try {
            int bytes_read;
            out = new FileOutputStream(outputFile);
            byte[] buffer = new byte[64000];
            while ((bytes_read = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytes_read);
            }
        }
        catch (Exception e2) {
            outputFile.delete();
            MessageUtils.showMessage("<html>Error downloading file: " + outputFile.getAbsoluteFile() + "<br/>" + e2.toString());
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceStrings(File inputFile, File outputFile, Map<String, String> replace) throws IOException {
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            String nextLine;
            reader = new BufferedReader(new FileReader(inputFile));
            writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            while ((nextLine = reader.readLine()) != null) {
                for (Map.Entry<String, String> entry : replace.entrySet()) {
                    nextLine = nextLine.replace(entry.getKey(), entry.getValue());
                }
                writer.println(nextLine);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    public static String legalFileName(String string) {
        for (Map.Entry<String, String> entry : illegalChar.entrySet()) {
            string = string.replaceAll(entry.getValue(), entry.getKey());
        }
        return string;
    }

    static {
        log = Logger.getLogger(FileUtils.class);
        illegalChar = new HashMap<String, String>();
        illegalChar.put("_qm_", "\\?");
        illegalChar.put("_fbr_", "\\[");
        illegalChar.put("_rbr_", "]");
        illegalChar.put("_fsl_", "/");
        illegalChar.put("_bsl_", "\\\\");
        illegalChar.put("_eq_", "=");
        illegalChar.put("_pl_", "\\+");
        illegalChar.put("_lt_", "<");
        illegalChar.put("_gt_", ">");
        illegalChar.put("_co_", ":");
        illegalChar.put("_sc_", ";");
        illegalChar.put("_dq_", "\"");
        illegalChar.put("_sq_", "'");
        illegalChar.put("_st_", "\\*");
        illegalChar.put("_pp_", "\\|");
    }
}

