/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;
import org.broad.igv.util.SeekableHTTPStream;
import org.broad.igv.util.SeekableStream;

public class SeekableFTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableHTTPStream.class);
    private long position = 0L;
    private String host;
    private String path;
    FTPClient ftp = null;

    SeekableFTPStream(URL url) throws IOException {
        this.host = url.getHost();
        this.path = url.getPath();
        this.ftp = this.openClient(this.host);
        this.ftp.setFileType(2);
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long skip(long n2) throws IOException {
        long bytesToSkip = n2;
        this.position += bytesToSkip;
        return bytesToSkip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        int n2;
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        InputStream is = null;
        try {
            int count;
            this.ftp.setRestartOffset(this.position);
            is = this.ftp.retrieveFileStream(this.path);
            System.out.println(this.ftp.getReplyString());
            for (n2 = 0; n2 < len; n2 += count) {
                count = is.read(buffer, offset + n2, len - n2);
                if (count >= 0) continue;
                if (n2 != 0) break;
                int n3 = -1;
                return n3;
            }
            this.position += (long)n2;
            count = n2;
            return count;
        }
        catch (EOFException e2) {
            if (n2 < 0) {
                int n4 = -1;
                return n4;
            }
            this.position += (long)n2;
            int n5 = n2;
            return n5;
        }
        finally {
            if (is != null) {
                is.close();
            }
            this.ftp.completePendingCommand();
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }

    private FTPClient openClient(String host) throws IOException {
        FTPClient ftp = new FTPClient();
        ftp.connect(host);
        System.out.println(ftp.getReplyString());
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            ftp.disconnect();
            System.err.println("FTP server refused connection.");
            throw new RuntimeException("FTP server refused connection.");
        }
        boolean success = ftp.login("anonymous", "igv-team@broadinstitute.org");
        if (!success) {
            System.err.println("FTP login failed " + ftp.getReplyString());
            throw new RuntimeException("FTP login failed " + ftp.getReplyString());
        }
        ftp.enterLocalPassiveMode();
        return ftp;
    }
}

