/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.SeekableStream;

public class SeekableHTTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableHTTPStream.class);
    private static final String WEBSERVICE_URL = "http://www.broadinstitute.org/webservices/igv";
    private static final String IGV_DATA_HOST = "www.broadinstitute.org";
    private static final String DATA_PATH = "/xchip/igv/data/public";
    private static final String DATA_HTTP_PATH = "/igvdata";
    private long position = 0L;
    private long contentLength = -1L;
    private URL url;

    SeekableHTTPStream(URL url) {
        this.url = url;
        String contentLengthString = IGVHttpUtils.getHeaderField(url, "Content-Length");
        if (contentLengthString == null) {
            log.error("Null content-length for: " + url);
            throw new RuntimeException("Error loading file: " + url + " NULL content-length");
        }
        try {
            this.contentLength = Long.parseLong(contentLengthString);
        }
        catch (NumberFormatException e2) {
            log.error("Error converting content length to number: " + this.contentLength);
            throw new RuntimeException("Error loading file: " + url + " Invalid content-length returned: " + contentLengthString);
        }
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long skip(long n2) throws IOException {
        long bytesToSkip = n2;
        if (this.contentLength > 0L) {
            bytesToSkip = Math.min(n2, this.contentLength - this.position);
        }
        this.position += bytesToSkip;
        return bytesToSkip;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        boolean useByteRange = IGVHttpUtils.useByteRange();
        return this.read(buffer, offset, len, useByteRange);
    }

    public int read(byte[] buffer, int offset, int len, boolean useByteRange) throws IOException {
        int nBytes;
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!useByteRange && (nBytes = this.readFromWebservice(buffer, offset, len)) > 0) {
            return nBytes;
        }
        InputStream is = null;
        String byteRange = "";
        int n2 = 0;
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            long endRange = this.position + (long)len - 1L;
            if (this.contentLength > 0L) {
                endRange = Math.min(endRange, this.contentLength);
            }
            byteRange = "bytes=" + this.position + "-" + endRange;
            if (endRange < this.position) {
                log.error("Invalid byteRange: " + byteRange);
                int n3 = 0;
                return n3;
            }
            props.put("Range", byteRange);
            is = IGVHttpUtils.openHttpStream(this.url, props);
            while (n2 < len) {
                int count = is.read(buffer, offset + n2, len - n2);
                if (count < 0) {
                    if (n2 != 0) break;
                    int n4 = -1;
                    return n4;
                }
                n2 += count;
            }
            this.position += (long)n2;
            int n5 = n2;
            return n5;
        }
        catch (IOException e2) {
            if (e2.getMessage().contains("416") || e2 instanceof EOFException) {
                log.error("Server returned 416 for: " + byteRange + " content-length = " + this.contentLength + "  URL: " + this.url);
                if (n2 < 0) {
                    int n6 = -1;
                    return n6;
                }
                this.position += (long)n2;
                int n7 = n2;
                return n7;
            }
            throw e2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }

    private void logHeaderFields(HttpURLConnection connection) {
        Map<String, List<String>> map = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            System.out.print(entry.getKey() + ":\t");
            for (String v : entry.getValue()) {
                System.out.print(v + " ");
            }
            System.out.println();
        }
    }

    public int readFromWebservice(byte[] buffer, int offset, int length) throws IOException {
        String host = this.url.getHost();
        if (host == null || !host.equals(IGV_DATA_HOST)) {
            return -1;
        }
        if (length < 0 || offset < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        HttpURLConnection connection = null;
        InputStream is = null;
        String path = this.url.getPath().replaceFirst(DATA_HTTP_PATH, DATA_PATH);
        URL webserviceURL = new URL("http://www.broadinstitute.org/webservices/igv?method=getRange&file=" + path + "&position=" + this.position + "&length=" + length);
        try {
            int n2;
            int count;
            connection = (HttpURLConnection)webserviceURL.openConnection();
            is = connection.getInputStream();
            for (n2 = 0; n2 < length; n2 += count) {
                count = is.read(buffer, offset + n2, length - n2);
                if (count >= 0) continue;
                int n3 = n2 == 0 ? -1 : n2;
                return n3;
            }
            this.position += (long)n2;
            if (log.isDebugEnabled()) {
                log.debug("Webservice range request: expected=" + length + " received=" + n2);
            }
            count = n2;
            return count;
        }
        catch (IOException e2) {
            log.error("Error doing webservice range query", e2);
            throw e2;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

