/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.SeekableStream;

public class SeekableServiceStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableServiceStream.class);
    private long position = 0L;
    private long contentLength = Long.MAX_VALUE;
    private ResourceLocator locator;

    public SeekableServiceStream(ResourceLocator locator) {
        this.locator = locator;
    }

    public long length() {
        return this.contentLength;
    }

    public boolean eof() throws IOException {
        return this.position >= this.contentLength;
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long skip(long n2) throws IOException {
        this.position += n2;
        return n2;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n2;
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        HttpURLConnection connection = null;
        InputStream is = null;
        URL url = new URL(this.locator.getServerURL() + "?method=getRange&file=" + this.locator.getPath() + "&position=" + this.position + "&length=" + length);
        try {
            int count;
            connection = IGVHttpUtils.openConnection(url);
            is = connection.getInputStream();
            for (n2 = 0; n2 < length; n2 += count) {
                count = is.read(buffer, offset + n2, length - n2);
                if (count >= 0) continue;
                int n3 = n2;
                return n3;
            }
            this.position += (long)n2;
            count = n2;
            return count;
        }
        catch (IOException e2) {
            if (e2.getMessage().contains("416") || e2 instanceof EOFException) {
                int n4 = n2;
                return n4;
            }
            throw e2;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] readBytes(long position, int nBytes) throws IOException {
        this.position = position;
        byte[] buffer = new byte[nBytes];
        this.read(buffer, 0, nBytes);
        return buffer;
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableServiceStream.  Must read in blocks.");
    }
}

