/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.collections;

public class DoubleArrayList {
    private transient double[] elements;
    private int size;

    public DoubleArrayList() {
        this(100);
    }

    public DoubleArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elements = new double[initialCapacity];
    }

    public DoubleArrayList(double[] elements) {
        this.elements = elements;
        this.size = elements.length;
    }

    public void add(double e2) {
        if (this.size + 1 >= this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = e2;
    }

    public void addAll(double[] args) {
        double[] newElements = new double[this.size + args.length];
        System.arraycopy(this.elements, 0, newElements, 0, this.size);
        System.arraycopy(args, 0, newElements, this.size, args.length);
        this.elements = newElements;
        this.size += args.length;
    }

    public void addAll(DoubleArrayList aList) {
        this.addAll(aList.toArray());
    }

    public double get(int idx) {
        return this.elements[idx];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    private void grow() {
        int oldCapacity = this.elements.length;
        int newCapacity = oldCapacity < 10000000 ? oldCapacity * 2 : oldCapacity * 3 / 2 + 1;
        double[] tmp = new double[newCapacity];
        System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
        this.elements = tmp;
    }

    public double[] toArray() {
        this.trimToSize();
        return this.elements;
    }

    private void trimToSize() {
        int oldCapacity = this.elements.length;
        if (this.size < oldCapacity) {
            double[] tmp = new double[this.size];
            System.arraycopy(this.elements, 0, tmp, 0, this.size);
            this.elements = tmp;
        }
    }
}

