/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.File;
import java.io.IOException;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.AsciiLineReader;
import org.broad.tribble.util.ParsingUtils;

public abstract class IndexCreator {
    protected File featureFile;
    protected FeatureCodec codec;
    protected File idxFile;

    public IndexCreator(File featureFile, FeatureCodec codec) {
        this.featureFile = featureFile;
        this.codec = codec;
        this.idxFile = new File(featureFile.getParent(), featureFile.getName() + ".idx");
        this.forceReadHeader(featureFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceReadHeader(File featureFile) {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(featureFile.getAbsolutePath());
            this.codec.readHeader(reader);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public abstract Index createIndex() throws IOException;
}

