/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.UnsortedFileException;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.interval.Interval;
import org.broad.tribble.index.interval.IntervalTreeIndex;
import org.broad.tribble.util.AsciiLineReader;
import org.broad.tribble.util.LittleEndianOutputStream;

public class IntervalIndexCreator
extends IndexCreator {
    private static Logger log = Logger.getLogger(IntervalIndexCreator.class);
    static int DEFAULT_FEATURE_COUNT = 1000;
    private int featuresPerInterval = DEFAULT_FEATURE_COUNT;
    private boolean verbose = false;

    public IntervalIndexCreator(File featureFile, FeatureCodec codec) {
        super(featureFile, codec);
    }

    public void setFeaturesPerInterval(int featuresPerInterval) {
        this.featuresPerInterval = featuresPerInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index createIndex() throws IOException {
        long filePosition;
        IntervalTreeIndex featureIndex = new IntervalTreeIndex(this.featureFile.getAbsolutePath());
        FileInputStream is = new FileInputStream(this.featureFile);
        AsciiLineReader reader = new AsciiLineReader(is);
        this.codec.readHeader(reader);
        long fileLength = this.featureFile.length();
        long progressIncrement = fileLength / 100L;
        long currentFilePosition = 0L;
        String lastChr = null;
        int lastStart = 0;
        int intervalStart = 0;
        int intervalEnd = 0;
        int progressCounter = 1;
        int lineNumber = 0;
        String nextLine = "";
        int featureCount = 0;
        Feature f2 = null;
        do {
            ++lineNumber;
            filePosition = reader.getPosition();
        } while ((nextLine = reader.readLine()) != null && (f2 = this.codec.decodeLoc(nextLine)) == null);
        if (f2 != null) {
            lastChr = f2.getChr();
            intervalStart = f2.getStart();
            intervalEnd = f2.getEnd();
            ++featureCount;
        }
        while ((nextLine = reader.readLine()) != null) {
            ++lineNumber;
            f2 = this.codec.decodeLoc(nextLine);
            if (f2 == null) continue;
            String chr = f2.getChr();
            if (!chr.equals(lastChr) || ++featureCount >= this.featuresPerInterval) {
                int bytesCount = (int)(currentFilePosition - filePosition);
                Block block = new Block(filePosition, bytesCount);
                Interval interval = new Interval(intervalStart, intervalEnd, block);
                featureIndex.insert(lastChr, interval);
                featureCount = 1;
                intervalStart = f2.getStart();
                intervalEnd = f2.getEnd();
                filePosition = currentFilePosition;
                lastStart = f2.getStart();
                lastChr = chr;
            } else {
                int start = f2.getStart();
                if (start < lastStart) {
                    throw new UnsortedFileException(" File must be sorted by start position. Sort test failed at: " + nextLine);
                }
                lastStart = start;
                intervalEnd = Math.max(f2.getEnd(), intervalEnd);
            }
            if ((currentFilePosition = reader.getPosition()) <= (long)progressCounter * progressIncrement) continue;
            this.updateProgress(progressCounter);
            ++progressCounter;
        }
        int bytesCount = (int)(currentFilePosition - filePosition);
        Block block = new Block(filePosition, bytesCount);
        Interval interval = new Interval(intervalStart, intervalEnd, block);
        featureIndex.insert(lastChr, interval);
        is.close();
        if (this.idxFile != null) {
            FilterOutputStream stream = null;
            try {
                stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(this.idxFile)));
                featureIndex.write((LittleEndianOutputStream)stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        return featureIndex;
    }

    private void updateProgress(int progressCounter) {
        if (this.verbose) {
            System.out.println("Progress: " + progressCounter + "%");
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

