/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream {
    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    public boolean readBoolean() throws IOException {
        int bool = this.in.read();
        if (bool == -1) {
            throw new EOFException();
        }
        return bool != 0;
    }

    public byte readByte(int b2) throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    public int readUnsignedByte() throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return temp;
    }

    public short readShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (short)((byte2 << 24 >>> 16) + (byte1 << 24) >>> 24);
    }

    public int readUnsignedShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (byte2 << 24 >> 16) + (byte1 << 24 >> 24);
    }

    public char readChar() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (char)((byte2 << 24 >>> 16) + (byte1 << 24 >>> 24));
    }

    public int readInt() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        int byte3 = this.in.read();
        int byte4 = this.in.read();
        if (byte4 == -1) {
            throw new EOFException();
        }
        return (byte4 << 24) + (byte3 << 24 >>> 8) + (byte2 << 24 >>> 16) + (byte1 << 24 >>> 24);
    }

    public long readLong() throws IOException {
        long byte1 = this.in.read();
        long byte2 = this.in.read();
        long byte3 = this.in.read();
        long byte4 = this.in.read();
        long byte5 = this.in.read();
        long byte6 = this.in.read();
        long byte7 = this.in.read();
        long byte8 = this.in.read();
        if (byte8 == -1L) {
            throw new EOFException();
        }
        return (byte8 << 56) + (byte7 << 56 >>> 8) + (byte6 << 56 >>> 16) + (byte5 << 56 >>> 24) + (byte4 << 56 >>> 32) + (byte3 << 56 >>> 40) + (byte2 << 56 >>> 48) + (byte1 << 56 >>> 56);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readString() throws IOException {
        byte b2;
        ByteArrayOutputStream bis = new ByteArrayOutputStream(100);
        while ((b2 = (byte)this.in.read()) != 0) {
            bis.write(b2);
        }
        return new String(bis.toByteArray());
    }
}

