/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class LittleEndianOutputStream
extends FilterOutputStream {
    protected int written;

    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b2) throws IOException {
        this.out.write(b2);
        ++this.written;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.out.write(data, offset, length);
        this.written += length;
    }

    public void writeBoolean(boolean b2) throws IOException {
        if (b2) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int b2) throws IOException {
        this.out.write(b2);
        ++this.written;
    }

    public void writeShort(int s) throws IOException {
        this.out.write(s & 0xFF);
        this.out.write(s >>> 8 & 0xFF);
        this.written += 2;
    }

    public void writeChar(int c2) throws IOException {
        this.out.write(c2 & 0xFF);
        this.out.write(c2 >>> 8 & 0xFF);
        this.written += 2;
    }

    public void writeInt(int i2) throws IOException {
        this.out.write(i2 & 0xFF);
        this.out.write(i2 >>> 8 & 0xFF);
        this.out.write(i2 >>> 16 & 0xFF);
        this.out.write(i2 >>> 24 & 0xFF);
        this.written += 4;
    }

    public void writeLong(long l) throws IOException {
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.written += 8;
    }

    public final void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public final void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeBytes(String s) throws IOException {
        int length = s.length();
        for (int i2 = 0; i2 < length; ++i2) {
            this.out.write((byte)s.charAt(i2));
        }
        this.written += length;
    }

    public void writeString(String s) throws IOException {
        this.writeBytes(s);
        this.out.write(0);
    }
}

