/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;

public class Node {
    private String name = new String();
    private String type = new String("internal");
    private Double length = new Double(0.0);
    public ArrayList<Node> children = new ArrayList();
    private int level = 0;
    private double treesize = new Double(0.0);
    private int depth = 0;
    private double newicklength = 0.0;
    private double startxcoord = -1.0;
    private double startycoord = -1.0;
    private double endxcoord = -1.0;
    private double endycoord = -1.0;
    private double standardy = -1.0;
    private boolean selected = false;
    private double xmultiplier = 0.0;
    private double ymultiplier = 0.0;

    public String getXML() {
        String string = new String();
        string = "<?xml version = \"1.0\"?>\n";
        string = string + this.generateXML();
        return string;
    }

    public String generateXML() {
        String string = new String();
        String string2 = new String();
        string2 = this.type.equals("internal") ? "INTERNAL" : "LEAF";
        string = "<" + string2;
        if (!this.name.equals("")) {
            string = string + " name = \"" + this.name + "\"";
        }
        if (this.length > 0.0) {
            string = string + " length = \"" + this.length + "\"";
        }
        string = string + ">";
        if (!this.children.isEmpty()) {
            for (Node node : this.children) {
                string = string + node.generateXML();
            }
        }
        string = string + "</" + string2 + ">";
        return string;
    }

    public String getNewick() {
        String string = new String();
        string = string + this.generateNewick();
        string = string + ";";
        return string;
    }

    public String generateNewick() {
        String string = new String();
        if (this.type.equals("internal")) {
            string = "(";
        }
        if (!this.name.equals("")) {
            string = string + this.name;
        }
        if (!this.children.isEmpty()) {
            Iterator<Node> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                string = string + node.generateNewick();
                if (!iterator.hasNext()) continue;
                string = string + ",";
            }
        }
        if (this.type.equals("internal")) {
            string = string + ")";
        }
        if (this.length > 0.0) {
            string = string + ":" + this.length;
        }
        return string;
    }

    public String getNewickExtra(ArrayList<ExtraData> arrayList, String string) {
        String string2 = new String();
        string2 = string2 + this.generateNewickExtra(arrayList, string);
        string2 = string2 + ";";
        return string2;
    }

    public String generateNewickExtra(ArrayList<ExtraData> arrayList, String string) {
        Object object;
        Object object2;
        String string2 = new String();
        if (this.type.equals("internal")) {
            string2 = "(";
        }
        if (!this.name.equals("")) {
            object2 = this.name;
            object = "";
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (!arrayList.get(i).getNewickName().equals(this.name) || arrayList.get(i).getNewickName().equals(null)) continue;
                object2 = arrayList.get(i).getFullName();
                object = arrayList.get(i).getNCBI();
            }
            if (string == "names") {
                object2 = ((String)object2).replaceAll("[^a-zA-Z0-9]", "");
                string2 = string2 + (String)object2;
            }
            if (string == "ncbi") {
                string2 = string2 + (String)object;
            }
        }
        if (!this.children.isEmpty()) {
            object2 = this.children.iterator();
            while (object2.hasNext()) {
                object = (Node)object2.next();
                string2 = string2 + ((Node)object).generateNewickExtra(arrayList, string);
                if (!object2.hasNext()) continue;
                string2 = string2 + ",";
            }
        }
        if (this.type.equals("internal")) {
            string2 = string2 + ")";
        }
        if (this.length > 0.0) {
            string2 = string2 + ":" + this.length;
        }
        return string2;
    }

    public void addChild(Node node) {
        this.children.add(node);
    }

    public void removeChild(int n) {
        this.children.remove(n);
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public Double getLength() {
        return this.length;
    }

    public void setLength(Double d) {
        this.length = d;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setTreeSize(Double d) {
        this.treesize = d;
    }

    public double getTreeSize() {
        return this.treesize;
    }

    public void setNewickLength(Double d) {
        this.newicklength = d;
    }

    public double getNewickLength() {
        return this.newicklength;
    }

    public void setStartX(double d) {
        this.startxcoord = d;
    }

    public double getStartX() {
        return this.startxcoord;
    }

    public void setStartY(double d) {
        this.startycoord = d;
    }

    public double getStartY() {
        return this.startycoord;
    }

    public void setEndX(double d) {
        this.endxcoord = d;
    }

    public double getEndX() {
        return this.endxcoord;
    }

    public void setEndY(double d) {
        this.endycoord = d;
    }

    public double getEndY() {
        return this.endycoord;
    }

    public void setStandardY(double d) {
        this.standardy = d;
    }

    public double getStandardY() {
        return this.standardy;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public double getYmultiplier() {
        return this.ymultiplier;
    }

    public double getXmultiplier() {
        return this.xmultiplier;
    }

    public void setXmultiplier(double d) {
        this.xmultiplier = d;
    }

    public void setYmultiplier(double d) {
        this.ymultiplier = d;
    }

    public String getAllNames() {
        String string = "";
        int n = this.children.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                string = this.findAllNames(this.children.get(i), string);
            }
        }
        if (!this.getName().equals("")) {
            string = string == "" ? string + this.getName() : string + "," + this.getName();
        }
        return string;
    }

    public String findAllNames(Node node, String string) {
        int n = node.children.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                string = this.findAllNames(node.children.get(i), string);
            }
        }
        if (!node.getName().equals("")) {
            string = string == "" ? string + node.getName() : string + "," + node.getName();
        }
        return string;
    }
}

