/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class TreeVector {
    private static String style;
    private static int x;
    private static int y;
    private static String treetopology;

    public TreeVector() {
        x = 0;
        y = 0;
        treetopology = "";
    }

    public static void main(String[] stringArray) {
        String string;
        String string2;
        Preferences preferences = new Preferences();
        x = 0;
        y = 0;
        Error error = new Error();
        if (null == stringArray || stringArray.length < 1) {
            System.err.println("Please enter a file name");
            System.exit(1);
        }
        System.err.println("Setting Preferences.....");
        TreeVector.processArgs(stringArray, preferences);
        System.err.println("Parsing.....");
        NewickParser newickParser = new NewickParser();
        newickParser.readFile(stringArray[0]);
        newickParser.parseTree();
        Node node = newickParser.getNode();
        DatabaseAccess databaseAccess = new DatabaseAccess();
        if (preferences.db) {
            TreeVector.register();
        }
        ArrayList<ExtraData> arrayList = new ArrayList<ExtraData>();
        ProcessNames processNames = new ProcessNames();
        if (!preferences.names.equals("none")) {
            System.err.println("Checking Selected Names.....");
            System.err.println(preferences.names);
            if (processNames.checkNames(node, preferences.names, error)) {
                System.err.println("Selected Names Found.....");
            } else {
                System.out.println("Some of the specified names were not found in the tree");
                System.exit(1);
            }
        }
        processNames.addAllNames(node, arrayList);
        System.err.println("Exploring Tree.....");
        Explorer explorer = new Explorer();
        explorer.getPositions(node);
        System.err.println("Getting Coordinates.....");
        Coordinates coordinates = x > 150 && y > 150 && x < 10000 && y < 10000 ? new Coordinates(x, y) : new Coordinates();
        if (preferences.treetype.equals("phylo")) {
            coordinates.findPhylogram(node);
        } else if (preferences.treetype.equals("clad")) {
            coordinates.findCladogram(node);
        } else {
            coordinates.findSimpleClad(node);
        }
        if (preferences.db) {
            System.err.println("Connecting to DB.....");
            databaseAccess.testMethod(node, arrayList);
        }
        SVG sVG = new SVG();
        System.err.println("Producing SVG.....");
        String string3 = preferences.treestyle.equals("triangle") ? sVG.getSVG(node, error, arrayList, preferences) : sVG.getSVG(node, error, arrayList, preferences);
        System.err.println("Creating SVG and XML Outputs.....");
        if (!preferences.embedfile.equals("")) {
            string2 = sVG.generateEmbed(preferences);
            TreeVector.stringToFile(string2, preferences.embedfile);
        }
        if (preferences.pagetoscreen) {
            string2 = sVG.generatePage(preferences);
            System.out.print(string2);
        }
        TreeVector.xmlPrinter(node, preferences);
        string2 = node.getNewick();
        TreeVector.stringToFile(string2, preferences.topologyfile);
        if (preferences.namestopologyfile != "") {
            string = node.getNewickExtra(arrayList, "names");
            TreeVector.stringToFile(string, preferences.namestopologyfile);
        }
        if (preferences.ncbitopologyfile != "") {
            string = node.getNewickExtra(arrayList, "ncbi");
            TreeVector.stringToFile(string, preferences.ncbitopologyfile);
        }
        TreeVector.stringToFile(string3, preferences.svgfile);
        if (preferences.svgtoscreen) {
            System.out.print(string3);
        }
        System.err.println("Done!");
    }

    public static void xmlPrinter(Node node, Preferences preferences) {
        String string = node.getXML();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(preferences.xmlfile);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string);
            printStream.println();
            printStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error writing to file");
        }
    }

    public static void stringToFile(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string);
            printStream.println();
            printStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error writing to file " + exception);
        }
    }

    public static void processArgs(String[] stringArray, Preferences preferences) {
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-prefs")) {
                if (i + 1 < stringArray.length) {
                    preferences.readPrefs(stringArray[++i]);
                    preferences.processPrefs();
                    continue;
                }
                System.err.println("Please specify filename and path when using -prefs");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("-simpleclad")) {
                preferences.treetype = "simpleclad";
                continue;
            }
            if (stringArray[i].equals("-clad")) {
                preferences.treetype = "clad";
                continue;
            }
            if (stringArray[i].equals("-phylo")) {
                preferences.treetype = "phylo";
                continue;
            }
            if (stringArray[i].equals("-out")) {
                if (i + 1 < stringArray.length) {
                    preferences.svgfile = stringArray[++i];
                    continue;
                }
                System.err.println("Please specify filename and path when using -out");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("-topology")) {
                if (i + 1 < stringArray.length) {
                    preferences.topologyfile = stringArray[++i];
                    continue;
                }
                System.err.println("Please specify filename and path when using -topology");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("-namestopology")) {
                if (i + 1 < stringArray.length) {
                    preferences.namestopologyfile = stringArray[++i];
                    continue;
                }
                System.err.println("Please specify filename and path when using -namestopology");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("-ncbitopology")) {
                if (i + 1 < stringArray.length) {
                    preferences.ncbitopologyfile = stringArray[++i];
                    continue;
                }
                System.err.println("Please specify filename and path when using -namestopology");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("-extradataoff")) {
                preferences.extra = false;
                continue;
            }
            if (stringArray[i].equals("-embedfile")) {
                if (i + 2 < stringArray.length) {
                    preferences.embedfile = stringArray[++i];
                    preferences.embedout = stringArray[++i];
                    continue;
                }
                System.err.println("Please specify filename and path when using -embedfile, savepath first then link for html ");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("-size")) {
                if (i + 2 < stringArray.length) {
                    x = TreeVector.getInt(stringArray[++i]);
                    preferences.x = TreeVector.getInt(stringArray[i]);
                    y = TreeVector.getInt(stringArray[++i]);
                    preferences.y = TreeVector.getInt(stringArray[i]);
                    continue;
                }
                System.err.println("Please specify size X first in this way: -size 500 600");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("-square")) {
                style = "square";
                preferences.treestyle = "square";
                continue;
            }
            if (stringArray[i].equals("-triangle")) {
                style = "triangle";
                preferences.treestyle = "triangle";
                continue;
            }
            if (stringArray[i].equals("-selectnames")) {
                if (i + 1 < stringArray.length) {
                    preferences.names = stringArray[++i];
                    continue;
                }
                System.err.println("Please enter comma separated list of genome codes");
                System.exit(1);
                continue;
            }
            System.err.println("Command not recognised, make sure you leave no gap between - and command");
            System.err.println("Valid Commands: -selectnames - simpleclad, -clad, -phylo, - size int int, -square, -triangle -out");
            System.exit(1);
        }
    }

    public static int getInt(String string) {
        int n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (Exception exception) {
            System.err.println("Please enter only integers after size command");
            System.exit(1);
        }
        return n;
    }

    public static void register() {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

