#!/usr/bin/env python

import sys
import argparse as ap

parser = ap.ArgumentParser(prog='data_path', conflict_handler='resolve',
                           description="Output the galaxy file path of datasets in a text file")

input = parser.add_argument_group('Input', '')
input.add_argument('-i', '--input', nargs='+', required=True, help="Paths to data1")
input.add_argument('-j', '--input2', nargs='*', required=True, help="Paths to data2")

if len(sys.argv) == 0:
    parser.print_usage()
    sys.exit(1)

args = parser.parse_args()
output = open('paths.txt', 'w')
if len(args.input2) == 0:
	for index,path in enumerate(args.input):
		output.write("%s\n" % (path))
else:
	for index,path in enumerate(args.input):
		output.write("%s\t%s\n" % (path, args.input2[index]))
